/**************************************************************************************
* @file         : SrcChangeHandler.h
* @author       : ECV2-Priyanka B
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle SourceChange data.
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef Tuner_SrcChangeHandler_h
#define Tuner_SrcChangeHandler_h

#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "SrcChangeIF.h"
//#include "SrcChangeCourierMsgHandler.h"
#include "AppBase/StartupSync/StartupSync.h"
//#include "SrcChangeDataBindingHandler.h"
#include "TunerDataBindingHandler.h"
#include "PresetListHandling.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "../DiagnosticsClient/DiagnosticsClientHandler.h"

namespace App {
namespace Core {

using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;
using namespace ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
/* class Tuner_SrcChangeHandler
 * The properties and methods of AudioSourceChangeProxy required to handle source change are implemented by this class.
 */

class SrcChangeHandler
   : public StartupSync::PropertyRegistrationIF,
     public hmibase::ServiceAvailableIF,
     public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceCallbackIF,
     public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::DeactivateSourceCallbackIF,
     public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceCallbackIF,
     public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListCallbackIF,
     public ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateCallbackIF,
     public ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoCallbackIF,
     public ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapCallbackIF,
     public ::ActiveRegionIdCallbackIF,
     public Sig_ActivateContextCallbackIF,
     public SrcChangeIF,
     public ToggleGadgetAudioSourceCallbackIF,
     public ToggleGadgetAudioSourceRequestCallbackIF,
// public CabinsSourceDisconnectionTriggerCallbackIF,
     public CabinsSourceRestorationInfoCallbackIF,
     public CabinsSystemsInfoCallbackIF
{
      SrcChangeHandler();
      static SrcChangeHandler* m_poSrcChangeHanlder;
   public:
      static SrcChangeHandler* poGetInstance()
      {
         if (NULL == m_poSrcChangeHanlder)
         {
            m_poSrcChangeHanlder = new SrcChangeHandler();
         }
         return m_poSrcChangeHanlder;
      }

      virtual ~SrcChangeHandler();

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void onActivateSourceError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                         const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceError >& /*error*/);
      virtual void onActivateSourceResponse(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceResponse >& /*response*/);

      virtual void onDeactivateSourceError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::DeactivateSourceError >& /*error*/);
      virtual void onDeactivateSourceResponse(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                              const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::DeactivateSourceResponse >& /*response*/);
      virtual void onActiveSourceError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceError >& /*error*/);

      virtual void onActiveSourceUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceUpdate >& update);

      virtual void onActiveSourceListError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListError >& /*error*/);
      virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListUpdate >& update);

      /*Entertainment mute functionality */
      virtual void onMuteStateError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                    const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateError >& /*error*/);
      virtual void onMuteStateUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                     const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateUpdate >& update);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdError >& error);
      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdUpdate >& update);

      virtual void onAudioStateInfoError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                         const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoError >& /*error*/);

      virtual void onAudioStateInfoUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                          const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoUpdate >& update);

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);
      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      virtual void onMuteStateMapError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapError >& error);

      virtual void onMuteStateMapUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapUpdate >& update);

      virtual void onToggleGadgetAudioSourceError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceError >& error);
      virtual void onToggleGadgetAudioSourceResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceResponse >& response);

      virtual void onToggleGadgetAudioSourceRequestError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceRequestError >& error);
      virtual void onToggleGadgetAudioSourceRequestSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceRequestSignal >& signal);

      // virtual void onCabinsSourceDisconnectionTriggerError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceDisconnectionTriggerError >& error);
      //  virtual void onCabinsSourceDisconnectionTriggerSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceDisconnectionTriggerSignal >& signal);

      virtual void onCabinsSourceRestorationInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceRestorationInfoError >& error);
      virtual void onCabinsSourceRestorationInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceRestorationInfoUpdate >& update);

      virtual void onCabinsSystemsInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSystemsInfoError >& error);
      virtual void onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSystemsInfoUpdate >& update);

      //void updateAudioSinks(int32 sink, int32 applicaiton);
      uint8 getsourceInfo();
      uint8 getConnectionState();
      void activateSource(int32& sourceID);
      void  onRequestNextBand();
      uint8 getActiveRegionValue();
      bool getCurrentRegionMuteStatus();
      std::map <uint16, bool> m_MuteStatusMap;
      void vRequestTunerSourceDeactivation(int srcid);
      void vRequestTunerSourceActivation(int16 srcid, int16 sinkId);
      void vSourceCommandActivation(int16 sourceId);
      void vCabinSourceCommandActivation(int16 sourceId);

      //void vRequestAudioConnect(uint8 syncId, uint32 currentSrc);
      int32 _sourceinfo;
      int32 prevSrcId;
      uint8 u8Src_ConnectionState;
      void setCockpitCabinValues(int sinkid, int srcid, int connectionState);
      int32 m_cockpitSrc;
      int32 m_cabinSrc;
      bool disconnect_src;
      void CANSourceData(int32 sourceID);
      void CabinCANSourceData(int32 sourceID);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)

      COURIER_MSG_MAP_DELEGATE_START()
      // ON_COURIER_MESSAGE(ShutdownMsg)
      COURIER_MSG_MAP_DELEGATE_END()

      bool isShutDown();
      TunerDataBindingHandler* _tunerDataBindingHandler;
      bool isTunerSourceRange(int srcid);
      bool isMediaSourceRange(int srcid);
      void switchToTunerHomeScreenGadget();
      void activeTunerAudioAllocationRequest();
      void reqMediaScreenToggle();
      void setSXMStatus(bool sxm_status);
      bool getSXMStatus();
      bool sxm_selected_val;
      void setBackBtnStatus(bool backbtn_status);
      bool getBackBtnStatus();
      bool backbtn_val;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      /** Instance of DiagnosticsClientHandler */
      DiagnosticsClientHandler* _DiagnosticsClientHandler;
   private:

      /** Instance of AudioSourceChangeProxy */
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy > _audioSrcChgProxy;

      /** Instance of SoundPropertiesProxy */
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy > _soundPropertiesProxy;

      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchProxy;

      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoServiceProxyClient;

      uint8 IsSrcChgReqdInOtherSinks(int32 ReqSrcID, int32 ReqSinkId);
      int32 _currSourceID;

      int32 _AudioSourceID;

      /** Instance for the TTFIs Trace command. */
      static SrcChangeHandler* _srcChangeInst;

      /** Member variable to hold connection status*/
      uint8 _tunerSourceConnStatus;

      uint8 m_u8activeRegion;
      uint8 m_SinksPendingSrcChg;
      uint8 m_CurrentSrc[7];

      uint32 _CurrentSourceID;

      bool fmConnected;
      void RunTimeSrcFM(bool fmStatus);
      bool amConnected;
      void RunTimeSrcAM(bool amStatus);
      bool dabConnected;
      void RunTimeSrcDAB(bool dabStatus);
      bool wxConnected;
      void RunTimeSrcWX(bool wxStatus);

      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
