/**************************************************************************************
* @file         : PresetListHandlingIF.h
* @author       : ECV2-Priyanka B
* @addtogroup   : Tuner HALL
* @brief        : Interface class for Preset List data handling functions.
* @copyright    : (c) 2017-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef PRESETLISTHANDLINGIF_H_
#define PRESETLISTHANDLINGIF_H_
#include "MIDW_TUNER_FIProxy.h"
#include "MIDW_TUNERMASTER_FIProxy.h"
#include "MIDW_EXT_DABTUNER_FIProxy.h"
#include "MIDW_TUNERMASTER_FI.h"
#include "MIDW_TUNERMASTER_FIClientBase.h"

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_TunerDatabinding.h"
#include "AppHmi_TunerStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"

#include "midw_tunermaster_fi_types.h"
#include "midw_tuner_fi_types.h"
#include "midw_tunermaster_fi_typesConst.h"
#include "App/Core/Tuner_Defines.h"
#include "AppBase/StartupSync/StartupSync.h"

using namespace ::asf::core;
using namespace ::MIDW_TUNERMASTER_FI;
using namespace ::midw_tunermaster_fi_types;
namespace App {
namespace Core {

class PresetListHandlingIF
{
   public:
      virtual ~PresetListHandlingIF() {};
      virtual void vAutostore() = 0;
      virtual void  vSelectPreset(uint16 u16PresetNumber) = 0;
      virtual void vStorePreset(uint16 u16PresetNumber) = 0;
      virtual void setActiveSeekStatus(bool seekStatus) = 0;
      virtual void vPreset_Handling_Start(uint8  u8PresetNr, T_e8_List enPresetType, T_e8_Band u8Band, T_e8_Preset_Action enPresetAction) = 0;
};


}
}


#endif /* PRESETLISTHANDLINGIF_H_ */
