/***************************************************************************
* Copyright(c) 2017-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
 ****************************************************************************/
#include "hall_std_if.h"
#include "PresetListHandling.h"
#include "App/Core/Tuner_Defines.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "App/Core/Utility/TunerUtility.h"
#include "App/Core/AMFMInfo/AMFMInfo.h"
//#include "App/Core/DABInfo/DabInfo.h"
#include "TunerDataBindingHandler.h"
#include "App/Core/Utility/TunerCommonHandler.h"
#include "../VehicleSrvClient/VehicleSrvClient.h"  //CAN Imp

#define IS_DAB_VALID() ((_dabFiProxy != NULL))

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TUNER_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TUNER
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Tuner_"
#define ETG_I_FILE_PREFIX                 App::Core::PresetListHandling::
#include "trcGenProj/Header/PresetListHandling.cpp.trc.h"
#endif

using namespace ::MIDW_TUNER_FI;
using namespace ::MIDW_TUNERMASTER_FI;
using namespace ::midw_tuner_fi_types;
using namespace ::midw_tunermaster_fi_types;

#define NULL_CHECK_VOID(xpointer)   if(NULL == xpointer) return;

namespace App {
namespace Core {


PresetListHandling* PresetListHandling::m_PresetListHandling = NULL;

//Add include files here

/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
PresetListHandling::PresetListHandling() :
   //	m_ptrInterfaceClass(pIfClass),
   _tunerMasterFiProxy(MIDW_TUNERMASTER_FIProxy::createProxy("tunermasterFiPort", *this)),
   _tunerFiProxy(MIDW_TUNER_FIProxy::createProxy("tunerFiPort", *this)),
   _fmPresetList(PRESET_SIZE, PresetList_Elem()),
   _amPresetList(AM_PRESET_SIZE, PresetList_Elem()),
   _FMHDActive(false),
   _AMHDActive(false)
{
   ETG_TRACE_USR3(("PresetListHandling::Constructor"));
   if (_tunerMasterFiProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _tunerMasterFiProxy->getPortName());
   }
   if (_tunerFiProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _tunerFiProxy->getPortName());
   }
   m_enCurrentTunBankID = T_e8_List__BANK_FM1;

   _TunerDataBindingHandler = TunerDataBindingHandler::getDataBindingHandlerInstance();

   ETG_I_REGISTER_FILE();
   _bandinfo = 0;
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
PresetListHandling::~PresetListHandling()
{
   //Add your code here
}


/**
* Description     : Request from Framework to start registering for properties. This request means GUI is ready now.
*
* @param[in]      : proxy : reference to the base class of all proxies
* @param[in]      : stateChange : represents a state transition of a service
* @return         : void
*/
void PresetListHandling::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR3(("PresetListHandling::registerProperties"));
}


/**
* Description     : Request from Framework to start de-registering for properties.
*
* @param[in]      : proxy : reference to the base class of all proxies
* @param[in]      : stateChange : represents a state transition of a service
* @return         : void
*/
void PresetListHandling::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR3(("PresetListHandling::deregisterProperties"));
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void PresetListHandling::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR3(("PresetListHandling::onAvailable"));
   //Add your code here
   if ((proxy == _tunerMasterFiProxy) && (_tunerMasterFiProxy.get()))
   {
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_PRESET_LISTUpReg(*this);
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg(*this);
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_BAND_INFOUpReg(*this);
   }
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void PresetListHandling::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   //Add your code here
   ETG_TRACE_USR3(("PresetListHandling::onUnAvailable"));
   _tunerMasterFiProxy->sendFID_TUNMSTR_G_PRESET_LISTRelUpRegAll();
   _tunerMasterFiProxy->sendFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpRegAll();
   _tunerMasterFiProxy->sendFID_TUNMSTR_G_BAND_INFORelUpRegAll();
}


/*******************************Implementation of Manual code*****************************************/

void PresetListHandling::onFID_TUNMSTR_S_BAND_CHANGEError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_S_BAND_CHANGEError >& /*error*/)
{
   ETG_TRACE_USR4(("onFID_TUNMSTR_S_BAND_CHANGEError"));
}


void PresetListHandling::onFID_TUNMSTR_S_BAND_CHANGEResult(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_S_BAND_CHANGEResult >& /*result*/)
{
   ETG_TRACE_USR4(("onFID_TUNMSTR_S_BAND_CHANGEResult"));
}


void PresetListHandling::onFID_TUNMSTR_G_BAND_INFOError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_G_BAND_INFOError >& /*error*/)
{
   ETG_TRACE_USR4(("onFID_TUNMSTR_G_BAND_INFOError"));
}


void PresetListHandling::onFID_TUNMSTR_G_BAND_INFOStatus(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_G_BAND_INFOStatus >& status)
{
   ETG_TRACE_USR3(("PresetListHandling:: onFID_TUNMSTR_G_BAND_INFOStatus %d", status->getBand()));
   T_e8_Band tunerBand = status->getBand();
   _bandinfo = status->getBand();
   AMFMInfo::poGetInstance()->vSetCurrentBand(tunerBand);
   if (status->getBand() == T_e8_Band__TUN_MSTR_BAND_FM)
   {
      TunerDataBindingHandler::getDataBindingHandlerInstance()->FMAMHomeScreen();
      ETG_TRACE_USR4(("T_e8_Band__TUN_MSTR_BAND_FM %d", status->getBand()));
   }
   else if (status->getBand() == T_e8_Band__TUN_MSTR_BAND_DAB)
   {
      TunerDataBindingHandler::getDataBindingHandlerInstance()->DABHomeScreen();
      ETG_TRACE_USR4(("T_e8_Band__TUN_MSTR_BAND_DAB %d", status->getBand()));
      DABSource = 1;
   }
   else if (status->getBand() == T_e8_Band__TUN_MSTR_BAND_MW)
   {
      TunerDataBindingHandler::getDataBindingHandlerInstance()->AMHomeScreen();
      ETG_TRACE_USR4(("T_e8_Band__TUN_MSTR_BAND_AM %d", status->getBand()));
   }
   else if (status->getBand() == T_e8_Band__TUN_MSTR_BAND_WB)
   {
      TunerDataBindingHandler::getDataBindingHandlerInstance()->WXHomeScreen();
      ETG_TRACE_USR4(("T_e8_Band__TUN_MSTR_BAND_WB %d", status->getBand()));
   }
   else
   {
      //Do Nothing
   }
}


uint8 PresetListHandling::getbandInfo()
{
   return _bandinfo;
}


//For HD
void PresetListHandling::setFMHDActiveStatus(bool& isActive)
{
   _FMHDActive = isActive;
}


void PresetListHandling::setAMHDActiveStatus(bool& isActive)
{
   _AMHDActive = isActive;
}


void PresetListHandling::onFID_TUNMSTR_G_PRESET_LISTError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_PRESET_LISTError >& /*error*/)
{
}


void PresetListHandling::onFID_TUNMSTR_G_PRESET_LISTStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_PRESET_LISTStatus >& status)
{
   NULL_CHECK_VOID(_TunerDataBindingHandler);
   ETG_TRACE_USR3(("PresetListHandling::onFID_TUNMSTR_G_PRESET_LISTStatus"));
   const ::boost::ptr_vector< T_PresetList >& presetList = status->getListOfStations();
   uint32 presetListSize = presetList.size();
   ETG_TRACE_USR3(("PresetListHandling::PresetList Status Size %d", presetListSize));
   bool bHDStatus = false;
   //std::ostringstream str;
   //str << "";
   uint32 SPSvalue = 0;

   ::std::string strFreq = "108.0";
   ::std::vector<std::string> aFM_Presets;
   ::std::vector<std::string> aAM_Presets;
   ::std::vector<std::string> aDAB_Presets;
   ::std::vector<std::string> aFMAST_Presets;
   ::std::vector<std::string> aAMAST_Presets;

   T_e8_List getList_id = status->getList();
   ETG_TRACE_USR3(("PresetListHandling::PresetList List Size %d", status->getList()));

   for (unsigned int itr = 0; itr < presetListSize; itr++)
   {
      switch (presetList[itr].getBand())
      {
         case T_e8_Band__TUN_MSTR_BAND_FM:
         {
            ETG_TRACE_USR3(("PresetList Status frequency Name %d", presetList[itr].getFrequency()));
            ETG_TRACE_USR3(("PresetList Status PS Name %s", presetList[itr].getPSName().c_str()));
            ETG_TRACE_USR3(("PresetList Status Frequency_Label %s", presetList[itr].getFrequency_Label().c_str()));
            if (!presetList[itr].getPSName().empty())
            {
               strFreq = presetList[itr].getPSName();
               ETG_TRACE_USR3(("PresetList strFreq %s", strFreq.c_str()));
            }
            else
            {
               vUpdateFreqConversion(presetList[itr].getFrequency(), strFreq, T_e8_Band__TUN_MSTR_BAND_FM);
            }
            ETG_TRACE_USR3(("PresetList Status Frequency_string %s", strFreq.c_str()));
            if ((getList_id == T_e8_List__BANK_FM1) || (getList_id == T_e8_List__BANK_FM2))
            {
               aFM_Presets.push_back(strFreq);
            }
            else
            {
               aFMAST_Presets.push_back(strFreq);
            }
            if (TunerCommonHandler::instance()->isHDFeatureEnabled())
            {
               ETG_TRACE_USR3(("PresetList isHDFeatureEnabled:presetList[itr] %d", presetList[itr].getFrequency()));
               //  if ((presetList[itr].getE8Modulation() == T_e8_ModulationType__TUN_MSTR_MODULATION_HD) && (_FMHDActive))
               if ((presetList[itr].getE8Modulation() == T_e8_ModulationType__TUN_MSTR_MODULATION_HD))
               {
                  bHDStatus = true;
                  SPSvalue = (presetList[itr].getU8HDAudioProgram_DRMShortID() + 1);
               }
               else
               {
                  bHDStatus = false;
                  SPSvalue = 0;
               }
            }
            _TunerDataBindingHandler->updateHDIconpresets(itr, bHDStatus, SPSvalue);
            break;
         }
         case T_e8_Band__TUN_MSTR_BAND_MW:
         {
            ETG_TRACE_USR3(("PresetList Status MW frequency Name %d", presetList[itr].getFrequency()));
            vUpdateFreqConversion(presetList[itr].getFrequency(), strFreq, T_e8_Band__TUN_MSTR_BAND_MW);
            if ((getList_id == T_e8_List__BANK_AM_MW1))
            {
               aAM_Presets.push_back(strFreq);
            }
            else
            {
               aAMAST_Presets.push_back(strFreq);
            }
            if (TunerCommonHandler::instance()->isHDFeatureEnabled())
            {
               ETG_TRACE_USR3(("PresetList isHDFeatureEnabled:presetList[itr] %d", presetList[itr].getFrequency()));
               if ((presetList[itr].getE8Modulation() == T_e8_ModulationType__TUN_MSTR_MODULATION_HD) && (_AMHDActive))
               {
                  bHDStatus = true;
                  SPSvalue = (presetList[itr].getU8HDAudioProgram_DRMShortID() + 1);
               }
               else
               {
                  bHDStatus = false;
                  SPSvalue = 0;
               }
            }
            _TunerDataBindingHandler->updateHDIconpresets(itr, bHDStatus, SPSvalue);
            break;
         }
         case T_e8_Band__TUN_MSTR_BAND_DAB:
         {
            ETG_TRACE_USR3(("DAB PresetList Status"));
            //	aDAB_Presets[itr] = presetList[itr].getPSName();
            break;
         }

         default:
            break;
      }
   }

   ETG_TRACE_USR3(("No.of FM Presets %d", aFM_Presets.size()));
   ETG_TRACE_USR3(("No.of AM Presets %d", aAM_Presets.size()));
   ETG_TRACE_USR3(("No.of DAB Presets %d", aDAB_Presets.size()));

   if (aFM_Presets.size())
   {
      _TunerDataBindingHandler->updateFMpresets(aFM_Presets);
   }

   if (aAM_Presets.size())
   {
      _TunerDataBindingHandler->updateAMpresets(aAM_Presets, TUN_PRESET_BANK_AM_MW1);
   }
}


void PresetListHandling::vUpdateFreqConversion(uint32 freq, std::string& strFreq, tU8 band)
{
   tChar szFMFrequency[M_FREQ_STR_BUFFER_SIZE] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
   tChar szAMFrequency[M_FREQ_STR_BUFFER_SIZE] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

   /*tChar szAMFrequency[M_FREQ_STR_BUFFER_SIZE] = { 0,0,0,0,0,0,0,0,0,0,0 };*/
   ETG_TRACE_USR3(("PresetListHandling::vUpdateFreqConversion(%d)", freq));

   if (TUNER_ZERO_VALUE == freq)
   {
      ETG_TRACE_USR3(("tclTunerAppLogic:: INVALID FREQUENCY : 0"));
      return;
   }
   switch (band)
   {
      case T_e8_Band__TUN_MSTR_BAND_FM:
      {
         if (TUNER_ZERO_VALUE == (freq % M_DIVIDE_BY_HUNDRED))
         {
            sprintf(szFMFrequency, "%.1f", ((tF32)freq / M_CONVERSION_KHZ_TO_MHZ));
            ETG_TRACE_USR3(("PresetListHandling::vUpdateFreqConversion if (%s)", szFMFrequency));
         }
         else
         {
            sprintf(szFMFrequency, "%.2f", ((tF32)freq / M_CONVERSION_KHZ_TO_MHZ));
            ETG_TRACE_USR3(("PresetListHandling::vUpdateFreqConversion else (%s)", szFMFrequency));
         }

         strFreq = szFMFrequency;
         ETG_TRACE_USR3(("PresetListHandling::vUpdateFreqConversion string(%s)", strFreq));
         break;
      }
      case T_e8_Band__TUN_MSTR_BAND_MW:
      {
         sprintf(szAMFrequency, "%d", freq);
         strFreq = szAMFrequency;
         break;
      }
      default:
         break;
   }
}


void PresetListHandling::fillPresetItemAt(const ::midw_tunermaster_fi_types::T_PresetList& presetItem, PresetList_Elem& destination)
{
   ETG_TRACE_USR3(("PresetListHandling::fillPresetItemAt"));

   std::ostringstream str;
   std::string band = "";
   bool bHDStatus = false;
   std::string strFreq, strPSName, PSName;
   strFreq = strPSName = "";
   str << "";

   uint32 freq = presetItem.getFrequency();
   ETG_TRACE_USR3(("PresetListHandling::fillPresetItemAt freq %d", freq));

   if (freq != 0)
   {
      strFreq = TunerUtility::formatFrequency(freq);
      strPSName = presetItem.getPSName();
      if (strPSName.empty())
      {
         strPSName = TunerUtility::formatFrequency(freq);
      }
   }
   ETG_TRACE_USR3(("PresetListHandling::fillPresetItemAt strFreq %s", strFreq.c_str()));
   destination._hdAudioPrg = str.str();
   destination._ishdStatus = bHDStatus;
   destination._preset_Freq = strFreq;
   destination._preset_PSName = strPSName;
   destination._band = band;

   ETG_TRACE_USR4(("PresetListHandling::Print data %s", strFreq.c_str()))
   ETG_TRACE_USR4(("PresetListHandling::Print data %c", destination._band.c_str()));
   ETG_TRACE_USR4(("PresetListHandling::Print data %c", destination._preset_PSName.c_str()));
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void PresetListHandling::onFID_TUNMSTR_S_PRESET_HANDLINGError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& proxy, const boost::shared_ptr< FID_TUNMSTR_S_PRESET_HANDLINGError >& error)
{
   //Add your code here
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void PresetListHandling::onFID_TUNMSTR_S_PRESET_HANDLINGResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& proxy, const boost::shared_ptr< FID_TUNMSTR_S_PRESET_HANDLINGResult >& result)
{
   ETG_TRACE_USR3(("PresetListHandling::onFID_TUNMSTR_S_PRESET_HANDLINGResult"));
   //Add your code here
   //if(NULL != m_ptrInterfaceClass)
   //	{
   //	 	m_ptrInterfaceClass->onFID_TUNMSTR_S_PRESET_HANDLINGResult(tunermaster_statusresponse, source, action);
   //	}
}


void PresetListHandling::onFID_TUNMSTR_G_GET_AUTOSTORE_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_GET_AUTOSTORE_STATUSError >& /*error*/)
{}
void PresetListHandling::onFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus >& status)
{
   ETG_TRACE_USR3(("PresetListHandling::onFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus"));
   bool autostore_status = status->getAutostore_State();
   T_e8_AST_Types AST_Type = status->getAST_Type();
   ETG_TRACE_USR3(("PresetListHandling::AutoStore_Status== %d", autostore_status));
   ETG_TRACE_USR3(("PresetListHandling::AST_Type== %d", AST_Type));

   _TunerDataBindingHandler->updateASTStatus(autostore_status);
   if (autostore_status)
   {
      ETG_TRACE_USR3(("PresetListHandling::Popup_PFO_AST"));
      POST_MSG((COURIER_MESSAGE_NEW(Popup_PFO_AST)()));
   }
   else
   {
      POST_MSG((COURIER_MESSAGE_NEW(Popup_PFO_ASTClose)()));
   }
}


void PresetListHandling::onFID_TUNMSTR_S_AUTOSTOREResult(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& proxy, const ::boost::shared_ptr< FID_TUNMSTR_S_AUTOSTOREResult >& result)
{
   ETG_TRACE_USR3(("PresetListHandling::onFID_TUNMSTR_S_AUTOSTOREResult"));
   T_e8_Source Source_Active = result->getSource();
   ETG_TRACE_USR3(("PresetListHandling::Source_Active== %d", Source_Active));
}


void PresetListHandling::onFID_TUNMSTR_S_AUTOSTOREError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& proxy, const ::boost::shared_ptr< FID_TUNMSTR_S_AUTOSTOREError >& error)
{}

void PresetListHandling::setActiveSeekStatus(bool seekStatus)
{
}


/************************************************************************
*FUNCTION:     vPreset_Handling_Start

*10.09.13 Pushpa
*Rev 0.1 Initial Revision
************************************************************************/

void PresetListHandling::vPreset_Handling_Start(tU8  u8PresetNr, T_e8_List enPresetType, T_e8_Band u8Band, T_e8_Preset_Action enPresetAction)
{
   std::vector<uint8> deleteList;
   ETG_TRACE_USR3(("PresetListHandling::vPreset_Handling_Start(Action: %d, Nr: %d, Type: %d, Band: %d)", enPresetAction, u8PresetNr, enPresetType, u8Band));
   _tunerMasterFiProxy->sendFID_TUNMSTR_S_PRESET_HANDLINGStart(*this, enPresetAction, u8PresetNr, enPresetType, u8Band, 0, 0, 0, "", static_cast<T_e8_PresetType>(0), deleteList);
}


void PresetListHandling::vAutostore()
{
   ETG_TRACE_USR3(("PresetListHandling::vAutostore()"));
   T_e8_List enBankID = m_enCurrentTunBankID;
   if (T_e8_List__BANK_DABAST == enBankID)
   {
      enBankID = T_e8_List__BANK_DAB1;
   }
   vAutostore_Start(true, enBankID);
}


tVoid PresetListHandling::vAutostore_Start(tBool  bIsAutoStoreStart, T_e8_List enPresetType)
{
   ETG_TRACE_USR3(("PresetListHandling::vAutostore_Start"));
   if (_tunerMasterFiProxy.get())
   {
      _tunerMasterFiProxy->sendFID_TUNMSTR_S_AUTOSTOREStart(*this, true, enPresetType/*ListType*/, T_e8_AST_Types__NORMAL_AST);
   }
}


tVoid PresetListHandling::vAutostore_Stop()
{
   ETG_TRACE_USR3(("PresetListHandling::vAutostore_Stop"));
   if (_tunerMasterFiProxy.get())
   {
      _tunerMasterFiProxy->sendFID_TUNMSTR_S_AUTOSTOREStart(*this, false, m_enCurrentTunBankID/*ListType*/, T_e8_AST_Types__NORMAL_AST);
      TunerDataBindingHandler::getDataBindingHandlerInstance()->updateASTStatus(false);
   }
}


void PresetListHandling::vSelectPreset(tU16 u16PresetNumber)
{
   ETG_TRACE_USR3(("PresetListHandling::vSelectPreset(%d)", u16PresetNumber));
   T_e8_List enBankID = m_enCurrentTunBankID;
   tU16 u16ActPresetNumber = u16PresetNumber;
   if (u16PresetNumber <= MAX_FM_PRESET_LIST)
   {
      if (T_e8_Band__TUN_MSTR_BAND_DAB == AMFMInfo::poGetInstance()->e8GetCurrentBand())
      {
         enBankID = T_e8_List__BANK_DAB1;
      }

      vPreset_Handling_Start(u16PresetNumber, enBankID, AMFMInfo::poGetInstance()->e8GetCurrentBand(), T_e8_Preset_Action__TUNMSTR_PresetRecall);
   }
}


void PresetListHandling::vStorePreset(tU16 u16PresetNumber)
{
   ETG_TRACE_USR3(("PresetListHandling::vStorePreset"));
   T_e8_List enBankID = m_enCurrentTunBankID;
   tU16 u16ActPresetNumber = u16PresetNumber;
   if (u16PresetNumber <= MAX_FM_PRESET_LIST)
   {
      vPreset_Handling_Start(u16PresetNumber, enBankID, AMFMInfo::poGetInstance()->e8GetCurrentBand(), T_e8_Preset_Action__TUNMSTR_PresetSave);
   }
}


/************************************************************************
*FUNCTION: 		vSelectPresetList
*DESCRIPTION:
*PARAMETER :
*
*
*RETURNVALUE:
*
*HISTORY:
*25.07.13 Pushpa Talawar
*Rev 1.0 Initial Revision.
************************************************************************/

void PresetListHandling::vSelectPresetList(int iViewId)
{
   ETG_TRACE_USR3(("AMFMInfo::vSelectPresetList(%d)", iViewId));

   T_e8_Tun_ListID e8ListID = T_e8_Tun_ListID__TUN_BANK_NONE;
   T_e8_List e8TunerMasterListID = T_e8_List__BANK_FM1;

   switch (iViewId)
   {
      case VIEW_AM:
      {
         e8ListID = T_e8_Tun_ListID__TUN_BANK_AM_MW1;
         e8TunerMasterListID = T_e8_List__BANK_AM_MW1;
      }
      break;

      case VIEW_AM_AST:
      {
         e8ListID = T_e8_Tun_ListID__TUN_BANK_AM_MWAST;
         e8TunerMasterListID = T_e8_List__BANK_AM_MWAST;
      }
      break;

      case VIEW_DAB:
      {
         //e8ListID = T_e8_Tun_ListID__TUN_BANK_DAB1;
         e8TunerMasterListID = T_e8_List__BANK_DAB1;
      }
      break;
      case VIEW_DAB_AST:
      {
         //e8ListID = T_e8_Tun_ListID__TUN_BANK_DABAST;
         e8TunerMasterListID = T_e8_List__BANK_DABAST;
      }
      break;

      case VIEW_FM1:
      case VIEW_FM2:
      {
         e8ListID = T_e8_Tun_ListID__TUN_BANK_FM1;
         e8TunerMasterListID = T_e8_List__BANK_FM1;
      }
      break;
      /* case VIEW_FM2:
      {
      	e8ListID = T_e8_Tun_ListID__TUN_BANK_FM2;
      	e8TunerMasterListID = T_e8_List__BANK_FM2;
      }
      break; */
      case VIEW_FM_AST:
      {
         e8ListID = T_e8_Tun_ListID__TUN_BANK_FM_AST;
         e8TunerMasterListID = T_e8_List__BANK_FMAST;
      }
      break;
      default:
      {
         //
      }
      break;
   }

   if (m_enCurrentTunBankID != e8TunerMasterListID)
   {
      m_enCurrentTunBankID = e8TunerMasterListID;
   }

   if ((T_e8_Tun_ListID__TUN_BANK_NONE != e8ListID) && (iViewId != 0))
   {
      ETG_TRACE_USR3(("SENDING SET_ACTIVE_PRESETLIST %d", e8ListID));
      ((_tunerFiProxy.get()) && (_tunerFiProxy->sendFID_TUN_S_SET_ACTIVE_PRESETLISTStart(*this, e8ListID)));
   }
   else
   {
      ETG_TRACE_USR3(("NOT SENDING SET_ACTIVE_PRESETLIST"));
   }
}


/**
* Description     : Virtual function implemented to get update of FID_TUNMSTR_S_PRESET_HANDLING Error
*
* @param[in]      : proxy: the client side representation of the CCA Functional Interface 'MIDW_TUNERMASTER_FIProxy'
* @param[in]      : error : The error message of 'FID_TUNMSTR_S_PRESET_HANDLING'
* @return         : void
*/
void PresetListHandling::onFID_TUN_S_SET_ACTIVE_PRESETLISTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_ACTIVE_PRESETLISTError >& /*error*/)
{
}


/**
* Description     : Virtual function implemented to get the result of method start AtSeek with TunerHeader
*
* @param[in]      : proxy: the client side representation of the CCA Functional Interface 'MIDW_TUNER_FIProxy'
* @param[in]      : result : The result message of the method "AtSeek with TunerHeader"
* @return         : void
*/
void PresetListHandling::onFID_TUN_S_SET_ACTIVE_PRESETLISTResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_ACTIVE_PRESETLISTResult >& /*result*/)
{
}


/* ***********************************************************
* Function 	: IsBandFM
* Description 	: Return true if the current band is FM
* Return value	: tclPresetInfoList*
* 16.01.18 Narahari M S
* Rev 1.0 Initial Revision.
* ***********************************************************/
bool PresetListHandling::IsBandFM()
{
   tBool bIsBandFM = false;
   if (AMFMInfo::poGetInstance()->e8GetCurrentBand() == T_e8_Band__TUN_MSTR_BAND_FM)
   {
      bIsBandFM = true;
      ETG_TRACE_USR3((" AMFMInfo tclTunerAppLogic::IsBandFM()"));
   }
   return bIsBandFM;
}


// bool PresetListHandling::IsBandAM()
// {
// tBool bIsBandAM = false;
// //added enum type for coverity in if condition
// if ((T_e8_Tun_TunerBand__TUN_BAND_MW == T_e8_Tun_TunerBand(m_enCurrentTunBankID)))
// {
// bIsBandAM = true;
// ETG_TRACE_USR3((" AMFMInfo tclTunerAppLogic::IsBandAM()"));
// }
// return bIsBandAM;
// }

bool PresetListHandling::IsBandDAB()
{
   tBool bIsBandDAB = false;
   if ((T_e8_List__BANK_DAB1 == m_enCurrentTunBankID)) /*|| (T_e8_List__BANK_DABAST == m_enCurrentTunBankID)) */
   {
      bIsBandDAB = true;
      ETG_TRACE_USR3((" AMFMInfo tclTunerAppLogic::IsBandDAB()"));
   }
   return bIsBandDAB;
}


} // namespace Core
}  // namespace App
