/**************************************************************************************
 * @file         : LanguageDefines.h
 * @author       : Padma Krishnamurthy
 * @addtogroup   : Tuner Hall
 * @brief        : Contains scope specific translation text Ids.
 * @copyright    : (c) 2017-2018 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef LANGUAGEDEFINES_H_
#define LANGUAGEDEFINES_H_

//#include "HmiTranslation_TextIds.h"
#include <CanderaWidget/String/String.h>

const unsigned int TextId_Invalid  = 0x0;
const unsigned int TextId_txt_TUNER__DR_ADVISORY_VC_01 = 0x04;
const unsigned int TextId_txt_TUNER__DR_ADVISORY_VC_02 = 0x03;
//Scope 2 Text Ids
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
#define TextId_IT_00208_Scan_Button                               TextId_IT_00208
#define TextId_New_Audio_0081_Info                                TextId_New_Audio_0081
#define TextId_New_Audio_0043_Refresh                             TextId_New_Audio_0043
#define TextId_IT_03324_TA_button                                 TextId_IT_03324
#define TextId_IT_03325_REG_Button                                TextId_IT_03325
#define TextId_AUDIO_9106_Call_Sign                               TextId_AUDIO_9106
#define TextId_AUDIO_9107_HD_Active                               TextId_AUDIO_9107
#define TextId_AUDIO_9108_Station_Id                              TextId_AUDIO_9108
#define TextId_AUDIO_9109_HD_Audio                                TextId_AUDIO_9109
#define TextId_AUDIO_9110_Blend_Status                            TextId_AUDIO_9110
#define TextId_AUDIO_9111_CD_No                                   TextId_AUDIO_9111
#define TextId_IT_03801_STM_Freq                                  TextId_IT_03801
#define TextId_IT_0326_STM_Quality                                TextId_New_Audio_0326
#define TextId_IT_0324_AMFM_Antenna_Status                        TextId_New_Audio_0324
#define TextId_IT_0325_Field_Strength                             TextId_New_Audio_0325
#define TextId_AUDIO_9102_DAB_FM                                  TextId_AUDIO_9102
#define TextId_New_Audio_9115_PSNAME                              TextId_AUDIO_9115
#define TextId_New_Audio_9116_Multipath                           TextId_AUDIO_9116
#define TextId_New_Audio_9117_Neighbour_Channel                   TextId_AUDIO_9117
#define TextId_New_Audio_9118_Not_available_advisory              TextId_AUDIO_9118
#define TextId_New_Audio_9119_No_info                             TextId_AUDIO_9119
#define TextId_IT_05016_loading_advisory                          TextId_IT_05016
#define TextId_AUDIO_9113_Service_RAdio_Item0                     TextId_AUDIO_9113
#define TextId_AUDIO_9112_Service_RAdio_Item1                     TextId_AUDIO_9112
#define TextId_AUDIO_9114_Service_RAdio_Item2                     TextId_AUDIO_9114
#define TextId_RADIO__SETTINGS_EU_ListButton_RDS_Active           TextId_RADIO__SETTINGS_EU_ListButton_RDS
#define TextId_RADIO__SETTINGS_EU_ListButton_TA_Active            TextId_RADIO__SETTINGS_EU_ListButton_TrafficAnnouncement
#define TextId_AUDIO_9101_RDS                                     TextId_AUDIO_9101
#define TextId_IT_03312_TA_interrupt                              TextId_IT_03312
#define TextId_IT_03309_Alarm_interrupt                           TextId_IT_03309
#define TUNER_RADIO_LIST_NUM_LI_01_Song_Name                      TextId_Invalid
#define TUNER_RADIO_LIST_NUM_LI_02_Artist_Name                    TextId_Invalid
#define TUNER_RADIO_LIST_NUM_LI_03_Album                          TextId_Invalid
#define TUNER_RADIO_LIST_NUM_LI_04_Comment                        TextId_Invalid
#define TUNER_RADIO_LIST_NUM_LI_05_Commercial                     TextId_Invalid
#define TUNER_RADIO_LIST_NUM_LI_06_Slogan                         TextId_Invalid
#define TUNER_RADIO_LIST_NUM_LI_07_Empty                          TextId_Invalid
#define TUNER_RADIO_SETTINGS_NUM_LI_08_AM                         TextId_Invalid
#define TUNER_RADIO_SETTINGS_NUM_LI_09_Radio_Text                 TextId_Invalid
#define TUNER_RADIO_SETTINGS_NUM_LI_10_HD_Radio                   TextId_Invalid
#define TUNER_RADIO_SETTINGS_NUM_LI_11_Region                     TextId_Invalid
#define TUNER_RADIO_SETTINGS_NUM_LI_12_TA_i_Traffic               TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_LI_13_Simulacast_Handover         TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_LI_14_Time_shift                  TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_LI_15_i_Announcement              TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_16_Transport                TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_17_Warning                  TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_18_News                     TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_19_Weather                  TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_20_Event                    TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_21_Special_Event            TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_22_Radio_Info               TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_23_Sport                    TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_IA_LI_24_Finance                  TextId_Invalid
#define TUNER_TPOPUP_NO_PRESET_PC_01_The_preset_is_empty          TextId_Invalid
#define TUNER_TPOPUP_PRESET_SAVED_PC_02_Preset_Saved              TextId_Invalid
#define TUNER_TPOPUP_PRESET_REPLACED_PC_03_Preset_replaced        TextId_Invalid
#define TUNER__ICPOP_AM_OFF_PC_04_AM_presets_deleted              TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_01_SCAN                        TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_02_Radio_settings              TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_03_Ambiance                    TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_04_Sounds_settings             TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_05_User_manual                 TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_06_DR_settings                 TextId_Invalid
#define TUNER_RADIO_SETTINGS_DR_LT_03_Digital_Radio_settings      TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_07_Musical_Event               TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_08_Program                     TextId_Invalid
#define TUNER_ZONE3_OPTION_RESET_LI_01_Reset                      TextId_Invalid
#define TUNER_ZONE3_POPOUT_LIST_LI_09_Update_list                 TextId_Invalid
#define TUNER_ZONE3_TAB_BUTTON_BL_01_Frequency                    TextId_Invalid
#define TUNER_ZONE3_TAB_BUTTON_BL_01_Channels                     TextId_Invalid
#define TUNER_TPOPUP_TA_INTERRUPTION                              TextId_Invalid
#define TUNER_TPOPUP_IA_INTERRUPTION                              TextId_Invalid
#define TUNER_TPOPUP_ALARM                                        TextId_Invalid
#define TUNER_TPOPUP_BAND_FM_01                                   TextId_Invalid
#define TUNER_TPOPUP_BAND_AM_02                                   TextId_Invalid
#define TUNER_TPOPUP_BAND_DR_03                                   TextId_Invalid

//End of Scope 2 Text Ids


//Scope 2.1 Text Ids
#else
#define TextId_IT_00208_Scan_Button                               TextId_Invalid
#define TextId_New_Audio_0081_Info                                TextId_Invalid
#define TextId_New_Audio_0043_Refresh                             TextId_Invalid
#define TextId_IT_03324_TA_button                                 TextId_Invalid
#define TextId_IT_03325_REG_Button                                TextId_Invalid
#define TextId_AUDIO_9106_Call_Sign                               TextId_Invalid
#define TextId_AUDIO_9107_HD_Active                               TextId_Invalid
#define TextId_AUDIO_9108_Station_Id                              TextId_Invalid
#define TextId_AUDIO_9109_HD_Audio                                TextId_Invalid
#define TextId_AUDIO_9110_Blend_Status                            TextId_Invalid
#define TextId_AUDIO_9111_CD_No                                   TextId_Invalid
#define TextId_IT_03801_STM_Freq                                  TextId_Invalid
#define TextId_IT_0326_STM_Quality                                TextId_Invalid
#define TextId_IT_0324_AMFM_Antenna_Status                        TextId_Invalid
#define TextId_IT_0325_Field_Strength                             TextId_Invalid
#define TextId_AUDIO_9102_DAB_FM                                  TextId_Invalid
#define TextId_New_Audio_9115_PSNAME                              TextId_Invalid
#define TextId_New_Audio_9116_Multipath                           TextId_Invalid
#define TextId_New_Audio_9117_Neighbour_Channel                   TextId_Invalid
#define TextId_New_Audio_9118_Not_available_advisory              TextId_txt_TUNER__DR_ADVISORY_VC_01
#define TextId_New_Audio_9119_No_info                             TextId_Invalid
#define TextId_IT_05016_loading_advisory                          TextId_txt_TUNER__DR_ADVISORY_VC_02
#define TextId_AUDIO_9113_Service_RAdio_Item0                     TextId_Invalid
#define TextId_AUDIO_9112_Service_RAdio_Item1                     TextId_Invalid
#define TextId_AUDIO_9114_Service_RAdio_Item2                     TextId_Invalid
#define TextId_RADIO__SETTINGS_EU_ListButton_RDS_Active           TextId_Invalid
#define TextId_RADIO__SETTINGS_EU_ListButton_TA_Active            TextId_Invalid
#define TextId_AUDIO_9101_RDS                                     TextId_Invalid
#define TextId_IT_03312_TA_interrupt                              TextId_Invalid
#define TextId_IT_03309_Alarm_interrupt                           TextId_Invalid
#define TUNER_RADIO_LIST_NUM_LI_01_Song_Name                      TextId_txt_TUNER_RADIO_LIST_NUM_LI_01
#define TUNER_RADIO_LIST_NUM_LI_02_Artist_Name                    TextId_txt_TUNER_RADIO_LIST_NUM_LI_02
#define TUNER_RADIO_LIST_NUM_LI_03_Album                          TextId_txt_TUNER_RADIO_LIST_NUM_LI_03
#define TUNER_RADIO_LIST_NUM_LI_04_Comment                        TextId_txt_TUNER_RADIO_LIST_NUM_LI_04
#define TUNER_RADIO_LIST_NUM_LI_05_Commercial                     TextId_txt_TUNER_RADIO_LIST_NUM_LI_05
#define TUNER_RADIO_LIST_NUM_LI_06_Slogan                         TextId_txt_TUNER_RADIO_LIST_NUM_LI_06
#define TUNER_RADIO_LIST_NUM_LI_07_Empty                          TextId_txt_TUNER_RADIO_LIST_NUM_LI_07
#define TUNER_RADIO_SETTINGS_NUM_LI_08_AM                         TextId_txt_TUNER_RADIO_SETTINGS_NUM_LI_08
#define TUNER_RADIO_SETTINGS_NUM_LI_09_Radio_Text                 TextId_txt_TUNER_RADIO_SETTINGS_NUM_LI_09
#define TUNER_RADIO_SETTINGS_NUM_LI_10_HD_Radio                   TextId_txt_TUNER_RADIO_SETTINGS_NUM_LI_10
#define TUNER_RADIO_SETTINGS_NUM_LI_11_Region                     TextId_txt_TUNER_RADIO_SETTINGS_NUM_LI_11
#define TUNER_RADIO_SETTINGS_NUM_LI_12_TA_i_Traffic               TextId_txt_TUNER_RADIO_SETTINGS_NUM_LI_12
#define TUNER_RADIO_SETTINGS_DR_LI_13_Simulacast_Handover         TextId_txt_TUNER_RADIO_SETTINGS_DR_LI_13
#define TUNER_RADIO_SETTINGS_DR_LI_14_Time_shift                  TextId_txt_TUNER_RADIO_SETTINGS_DR_LI_14
#define TUNER_RADIO_SETTINGS_DR_LI_15_i_Announcement              TextId_txt_TUNER_RADIO_SETTINGS_DR_LI_15
#define TUNER_RADIO_SETTINGS_DR_IA_LI_16_Transport                TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_16
#define TUNER_RADIO_SETTINGS_DR_IA_LI_17_Warning                  TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_17
#define TUNER_RADIO_SETTINGS_DR_IA_LI_18_News                     TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_18
#define TUNER_RADIO_SETTINGS_DR_IA_LI_19_Weather                  TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_19
#define TUNER_RADIO_SETTINGS_DR_IA_LI_20_Event                    TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_20
#define TUNER_RADIO_SETTINGS_DR_IA_LI_21_Special_Event            TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_21
#define TUNER_RADIO_SETTINGS_DR_IA_LI_22_Radio_Info               TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_22
#define TUNER_RADIO_SETTINGS_DR_IA_LI_23_Sport                    TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_23
#define TUNER_RADIO_SETTINGS_DR_IA_LI_24_Finance                  TextId_txt_TUNER_RADIO_SETTINGS_DR_IA_LI_24
#define TUNER_TPOPUP_NO_PRESET_PC_01_The_preset_is_empty          TextId_txt_TUNER_TPOPUP_NO_PRESET_PC_01
#define TUNER_TPOPUP_PRESET_SAVED_PC_02_Preset_Saved              TextId_txt_TUNER_TPOPUP_PRESET_SAVED_PC_02
#define TUNER_TPOPUP_PRESET_REPLACED_PC_03_Preset_replaced        TextId_txt_TUNER_TPOPUP_PRESET_REPLACED_PC_03
#define TUNER__ICPOP_AM_OFF_PC_04_AM_presets_deleted              TextId_txt_TUNER__ICPOP_AM_OFF_PC_04
#define TUNER_ZONE3_POPOUT_LIST_LI_01_SCAN                        TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_01
#define TUNER_ZONE3_POPOUT_LIST_LI_02_Radio_settings              TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_02
#define TUNER_ZONE3_POPOUT_LIST_LI_03_Ambiance                    TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_03
#define TUNER_ZONE3_POPOUT_LIST_LI_04_Sounds_settings             TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_04
#define TUNER_ZONE3_POPOUT_LIST_LI_05_User_manual                 TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_05
#define TUNER_ZONE3_POPOUT_LIST_LI_06_DR_settings                 TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_06
#define TUNER_RADIO_SETTINGS_DR_LT_03_Digital_Radio_settings      TextId_txt_TUNER_RADIO_SETTINGS_DR_LT_03
#define TUNER_ZONE3_POPOUT_LIST_LI_07_Musical_Event               TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_07
#define TUNER_ZONE3_POPOUT_LIST_LI_08_Program                     TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_08
#define TUNER_ZONE3_OPTION_RESET_LI_01_Reset                      TextId_txt_TUNER_ZONE3_OPTION_RESET_LI_01
#define TUNER_ZONE3_POPOUT_LIST_LI_09_Update_list                 TextId_txt_TUNER_ZONE3_POPOUT_LIST_LI_09
#define TUNER_ZONE3_TAB_BUTTON_BL_01_Frequency                    TextId_txt_TUNER_ZONE3_TAB_BUTTON_BL_01
#define TUNER_ZONE3_TAB_BUTTON_BL_01_Channels                     TextId_txt_TUNER_ZONE3_TAB_BUTTON_BL_04
#define TUNER_TPOPUP_TA_INTERRUPTION                              TextId_txt_TUNER_TPOPUP_TA_INTERRUPTION_PC_01
#define TUNER_TPOPUP_IA_INTERRUPTION                              TextId_txt_TUNER_TPOPUP_IA_INTERRUPTION_PC_02
#define TUNER_TPOPUP_ALARM                                        TextId_txt_TUNER_TPOPUP_ALARM_PC_03
#define TUNER_TPOPUP_BAND_FM_01                                   TextId_txt_TUNER_TPOPUP_BAND_FM_01
#define TUNER_TPOPUP_BAND_AM_02                                   TextId_txt_TUNER_TPOPUP_BAND_AM_02
#define TUNER_TPOPUP_BAND_DR_03                                   TextId_txt_TUNER_TPOPUP_BAND_DR_03


//End of Scope 2.1 Text Ids
#endif

#endif //LANGUAGEDEFINES_H_
