/**************************************************************************************
* @file         : DiagnosticsClientHandler.cpp
* @author       : ECH2 Swarna Trivedi
* @addtogroup   : AppHmi_Tuner
* @brief        :
* @copyright    : (C) 2022 Robert Bosch GmbH
*                 (C) 2022 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "DiagnosticsClientHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TUNER_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TUNER
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_TUNER_"
#define ETG_I_FILE_PREFIX                 App::Core::DiagnosticsClient::
#include "trcGenProj/Header/DiagnosticsClientHandler.cpp.trc.h"
#endif

static const uint16_t RUNTIME_U16_APP_FM = 0x0000;
static const uint16_t RUNTIME_U16_APP_AM = 0x0001;
static const uint16_t RUNTIME_U16_APP_DAB = 0x0002;
static const uint16_t RUNTIME_U16_APP_WX = 0x0009;


using namespace ::asf::core;
using namespace Midw_Diagnostics_FI;

class StartupSync;

namespace App {
namespace Core {

//DEFINE_CLASS_LOGGER_AND_LEVEL("App/Core", DiagnosticsClientHandler, Info);

DiagnosticsClientHandler* DiagnosticsClientHandler::m_poDiagnosticsClientHandler = NULL;

DiagnosticsClientHandler::DiagnosticsClientHandler(const std::string& diagnosticsFiPort)
   : _diagnosticProxy(Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy::createProxy(diagnosticsFiPort, *this))
{
   if (_diagnosticProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _diagnosticProxy->getPortName());
      ETG_TRACE_USR4(("DiagnosticsClientHandler::Constructor DiagnosticsClientHandler"));
   }
}


void DiagnosticsClientHandler::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onAvailable"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
}


void DiagnosticsClientHandler::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onUnavailable"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
}


void DiagnosticsClientHandler::registerProperties(const ::boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::registerProperties()"));
}


void DiagnosticsClientHandler::deregisterProperties(const ::boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::deregisterProperties()"));
}


void DiagnosticsClientHandler::onSetRunTimeSourceDataError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataError >& error)
{
   ETG_TRACE_ERR(("DiagnosticsClientHandler::onSetRunTimeSourceDataError()"));
}


void DiagnosticsClientHandler::onSetRunTimeSourceDataResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataResult >& result)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onSetRunTimeSourceDataResult()"));
}


void DiagnosticsClientHandler::updateFMRuntimeInfo(uint32_t seconds)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::updateFMRuntimeInfo : %d seconds", seconds));
   if (_diagnosticProxy.get())
   {
      ETG_TRACE_USR4(("DiagnosticsClientHandler::updateFMRuntimeInfo Sent"));
      _diagnosticProxy->sendSetRunTimeSourceDataStart(*this, RUNTIME_U16_APP_FM, seconds);
   }
}


void DiagnosticsClientHandler::updateAMRuntimeInfo(uint32_t seconds)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::updateAMRuntimeInfo : %d seconds", seconds));
   if (_diagnosticProxy.get())
   {
      ETG_TRACE_USR4(("DiagnosticsClientHandler::updateAMRuntimeInfo Sent"));
      _diagnosticProxy->sendSetRunTimeSourceDataStart(*this, RUNTIME_U16_APP_AM, seconds);
   }
}


void DiagnosticsClientHandler::updateDABRuntimeInfo(uint32_t seconds)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::updateDABRuntimeInfo : %d seconds", seconds));
   if (_diagnosticProxy.get())
   {
      ETG_TRACE_USR4(("DiagnosticsClientHandler::updateDABRuntimeInfo Sent"));

      _diagnosticProxy->sendSetRunTimeSourceDataStart(*this, RUNTIME_U16_APP_DAB, seconds);
   }
}


void DiagnosticsClientHandler::updateWXRuntimeInfo(uint32_t seconds)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::updateWXRuntimeInfo : %d seconds", seconds));
   if (_diagnosticProxy.get())
   {
      ETG_TRACE_USR4(("DiagnosticsClientHandler::updateWXRuntimeInfo Sent"));
      _diagnosticProxy->sendSetRunTimeSourceDataStart(*this, RUNTIME_U16_APP_WX, seconds);
   }
}


} // namespace App
} // namespace Core
