
/**************************************************************************************
* @file         : TunerDataBindingHandler.h
* @author       : ECG-Narahari
* @addtogroup   : Tuner Data Binding Handler
* @brief        : Class contains utility functions to handle DataBinding messages required for AM FM Info and HD data.
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef TunerDataBindingHandler_h
#define TunerDataBindingHandler_h
#include "App/Core/Utility/TunerUtility.h"
#include "AppHmi_TunerStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "midw_tuner_fi_typesConst.h"
#include "TunerStdSpecTypes.h"
#include "App/Core/Utility/Timer.h"
#include "asf/core/Timer.h"
#include "AppHmi_TunerMessages.h"
#include "AMFMInfoCourierMsgHandler.h"
#include "HMI/CGIComponents/TunerViewDefines.h"
#include "App/Core/Tuner_Defines.h"

#include <View/CGI/CgiExtensions/ImageLoader.h>

#define TUNER1 0
#define TUNER2 1
#define TUNER3 2
#define TUNER4 3
#define ACTIVETUNER1 0
#define ACTIVETUNER2 1
#define ACTIVETUNER3 2
#define ACTIVETUNER4 3
#define FMBAND1 0
#define FMBAND2 1
#define AMBAND 3
#define ONE 1
#define EN_PRESET_NONE 0

struct NARRadioMainData
{
   NARRadioMainData() : _artistName(""), _trackName(""), _albumName(""), _HDInfoGenre(""), _radiotxt(""), _commerialPriceString(""),
      _commerialValidity(""), _commerialContactURL(""), _commerialRecievedAs(""), _commerialSellerName(""),
      _commerialDesc(""), _commentLanguage(""), _commentShortDec(""), _commentActualTxt(""), _slogan(""), _advisoryText("") {}
   std::string _artistName;
   std::string _trackName;
   std::string _albumName;
   std::string _HDInfoGenre;
   std::string _radiotxt;
   std::string _commerialPriceString;
   std::string _commerialValidity;
   std::string _commerialContactURL;
   std::string _commerialRecievedAs;
   std::string _commerialSellerName;
   std::string _commerialDesc;
   std::string _commentLanguage;
   std::string _commentShortDec;
   std::string _commentActualTxt;
   std::string _slogan;
   std::string _advisoryText;
};


using namespace Courier;

namespace App {
namespace Core {
class AMFMInfoCourierMsgHandler;
class TunerDataBindingHandler : public ::asf::core::TimerCallbackIF
{
      /* class TunerDataBindingHandler
       * This class handles the methods to update HALL data to data binding variables.
       */
      TunerDataBindingHandler();
   public:

      virtual ~TunerDataBindingHandler();

      void updateRadioText(std::string& radiotxt);

      /* Binding source instance - Updates details name frequency PS name, TP text, View name and frequency unit */
      DataBindingItem<StationInfoSourceDataBindingSource> oTunerInfoData;
      DataBindingItem<PresetInfoFM1DataBindingSource> oTunerPresetFM1;
      DataBindingItem<PresetInfoFM2DataBindingSource> oTunerPresetFM2;
      DataBindingItem<PresetInfoFMASTDataBindingSource> oTunerPresetFMAST;
      DataBindingItem<PresetInfoAMDataBindingSource> oTunerPresetAM;
      DataBindingItem<PresetInfoAMASTDataBindingSource> oTunerPresetAMAST;
      DataBindingItem<PresetInfoDABDataBindingSource> oTunerPresetDAB;
      DataBindingItem<PresetInfoDABASTDataBindingSource> oTunerPresetDABAST;
      DataBindingItem<tuningScale_SliderMarkerPositionDataBindingSource> oTunerSliderMarkerPosition;
      DataBindingItem<Preset_PopupDataBindingSource> oTunerPopupData;
      DataBindingItem<TunerOptionsDataBindingSource> oCheckBoxData;
      DataBindingItem<DABOptionsDataBindingSource> oDabOptionsData;
      DataBindingItem<MenuSelectionDataBindingSource> oMenuSelectionData;
      DataBindingItem<Menu_NumOptionsDataBindingSource> oMenu_NumOptionsData;
      DataBindingItem<Scan_ASTDataBindingSource> oScanASTStatusData;
      DataBindingItem<EngineeringInfoDataBindingSource> oEngineeringMenuData;
      DataBindingItem<EngineeringInfo1DataBindingSource> oEngineeringMenuData1;
      DataBindingItem<EngineeringInfo2DataBindingSource> oEngineeringMenuData2;
      DataBindingItem<RadioBandInfoDataBindingSource> oRadioBandInfoData;
      DataBindingItem<PgBar_timerDataBindingSource> oPgBar_timerData;
      DataBindingItem<RDSOptionsDataBindingSource> oRDSOptions;
      DataBindingItem<tuningSliderDataBindingSource>otuningSlider;
      DataBindingItem<AppFlyInDataBindingSource>oAppFlyIn;
      /* Binding source instance - Updates the browse list  */
      DataBindingItem<BrowseListPointerDataBindingSource> oBrowseListPointer;
      /* Binding source instance - Updates the browse list size  */
      DataBindingItem<BrowseListSizeDataBindingSource> oBrowseListSize;
      /* Binding source instance - Updates the browse list selected element index  */
      DataBindingItem<BrowseListSelectedLineDataBindingSource> oBrowseListSelectedElement;
      DataBindingItem<DABChannelInfoDataBindingSource> oDABChannelInfo;
      DataBindingItem<HomeScreenInfoDataBindingSource> oHomeScreenInfo;
      DataBindingItem<ActiveBankInfoDataBindingSource> oActiveBankInfo;
      DataBindingItem<ActiveSourceInfoDataBindingSource> oActiveSourceInfo;
      DataBindingItem<VariantInfoDataBindingSource> oVariantInfo;
      DataBindingItem<DABPresetInfoDataBindingSource> oDABPresetInfo;
      DataBindingItem<FMAMPresetInfoDataBindingSource> oFMAMPresetInfo;
      DataBindingItem<AMPresetInfoDataBindingSource> oAMPresetInfo;
      DataBindingItem<TAInfoDataBindingSource> oTAInfo;
      DataBindingItem<Tuner1DataBindingSource> oTTMonitor1;
      DataBindingItem<Tuner2DataBindingSource> oTTMonitor2;
      DataBindingItem<Tuner3DataBindingSource> oTTMonitor3;
      DataBindingItem<Tuner3DataBindingSource> oTTMonitor4;
      DataBindingItem<TunerSource_BandDataBindingSource> oTTTunerSource_Band;
      DataBindingItem<DAB_Setup_ScreenDataBindingSource> oDABSetupMonitor;
      DataBindingItem<DAB_Test_ModeDataBindingSource> oDABTestModePointer;
      DataBindingItem<DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource> oDABTestModeActivertunerInfo;
      DataBindingItem<DABTestModeEnsembleInfoDataBindingSource> oDABTestModeActiveEnsembleInfo;
      DataBindingItem<DABGTestModeInfoDataBindingSource> oDABTestModeGTestmodeInfo;
      DataBindingItem<DABGTestModeAnnoStatusInfoDataBindingSource> oDABTestModeAnnoStatusInfo;
      DataBindingItem<DABGTestModeActiveCompDataBindingSource> oDABTestModeActiveCompInfo;
      DataBindingItem<DABTestModeGAvailabiltyInfoDataBindingSource> oDABTestModeGAvailabiltyInfo;
      DataBindingItem<DABTestModeServiceFollowingInfoDataBindingSource> oDABTestServiceFollowingInfo;
      DataBindingItem<TmcInformationDataDataBindingSource> oTmcInformationData;
      DataBindingItem<TmcStationInfoDataDataBindingSource> oTmcStationInformationData;
      DataBindingItem<TestModeAvailabilityInfoDataBindingSource> oTestModeAvailabilityInfo;
      DataBindingItem<Scan_StatusDataBindingSource> oTunerScanInfoData;
      DataBindingItem<Source_SlectionDataBindingSource> oTunerSourceIconData;
      DataBindingItem<FMSetupMenuInfoDataBindingSource> oFMSetupMenuInfo;
      DataBindingItem<LayerNextPresets_FMDataBindingSource> oLayerNextPresets_FM;
      DataBindingItem<LayerNextPresets_AMDataBindingSource> oLayerNextPresets_AM;
      DataBindingItem<LayerNextPresets_DABDataBindingSource> oLayerNextPresets_DAB;
      DataBindingItem<NextPrevious_Status_FMDataBindingSource> oNextPrevious_Status_FM;
      DataBindingItem<NextPrevious_Status_AMDataBindingSource> oNextPrevious_Status_AM;
      DataBindingItem<NextPrevious_Status_DABDataBindingSource> oNextPrevious_Status_DAB;
      DataBindingItem<SearchNextPrevious_IconActiveDataBindingSource> oSearchNextPrevious_IconActive;
      //map<UInt8,UInt8> m_ActiveLineIndexInfoMap;

      //HD items=======wst4kor======================
      DataBindingItem<AmHdOnOffDataBindingSource> oAmHdOnOffInfo;
      DataBindingItem<FmHdOnOffDataBindingSource> oFmHdOnOffInfo;
      DataBindingItem<FmHdLogoDataBindingSource> oFmHDlogo;
      DataBindingItem<AmHdLogoDataBindingSource> oAmHDlogo;
      DataBindingItem<HDButtonVisibilityDataBindingSource> oHDButtonVisibility;
      DataBindingItem<HDProgramListVisibilityDataBindingSource> oHDAudioProgramVisibility;
      DataBindingItem<HDAudioMPSDataBindingSource> oHDAudioProgMps;
      DataBindingItem<HDAudioSPS1DataBindingSource> oHDAudioProgSps1;
      DataBindingItem<HDAudioSPS2DataBindingSource> oHDAudioProgSps2;
      DataBindingItem<HDAudioSPS3DataBindingSource> oHDAudioProgSps3;
      DataBindingItem<HDAudioSPS4DataBindingSource> oHDAudioProgSps4;
      DataBindingItem<HDAudioSPS5DataBindingSource> oHDAudioProgSps5;
      DataBindingItem<HDAudioSPS6DataBindingSource> oHDAudioProgSps6;
      DataBindingItem<HDAudioSPS7DataBindingSource> oHDAudioProgSps7;
      DataBindingItem<ChannelInfoDataBindingSource> oChannelInfo;
      DataBindingItem<HDParamTuningIconDataBindingSource> oHDParamTuningIcon;
      DataBindingItem<AMFMLogoImageDataBindingSource> _amfmLogoImage;
      //HD Preset list icon update
      DataBindingItem<HDIconPreset1DataBindingSource> oHDIconPreset1;
      DataBindingItem<HDIconPreset2DataBindingSource> oHDIconPreset2;
      DataBindingItem<HDIconPreset3DataBindingSource> oHDIconPreset3;
      DataBindingItem<HDIconPreset4DataBindingSource> oHDIconPreset4;
      DataBindingItem<HDIconPreset5DataBindingSource> oHDIconPreset5;
      DataBindingItem<HDIconPreset6DataBindingSource> oHDIconPreset6;
      DataBindingItem<HDIconPreset7DataBindingSource> oHDIconPreset7;
      DataBindingItem<HDIconPreset8DataBindingSource> oHDIconPreset8;
      DataBindingItem<HDIconPreset9DataBindingSource> oHDIconPreset9;
      DataBindingItem<HDIconPreset10DataBindingSource> oHDIconPreset10;
      DataBindingItem<HDIconPreset11DataBindingSource> oHDIconPreset11;
      DataBindingItem<HDIconPreset12DataBindingSource> oHDIconPreset12;

      void setHdButtonVisibilityStatus(bool HDButtonStatus);
      void updateFMHDLogo(uint8 HDlogoStatus);
      void updateAMHDLogo(uint8 HDlogoStatus);
      void setHdAudioProgramVisibilityStatus(bool HDProgramvisibilityStatus);
      void setHDProgSizeAndSwitch(uint8 audioProgram, float size, uint8 active);
      void updateAMHDIndicatorStatus(bool isActive);
      void updateFMHDIndicatorStatus(bool isActive);
      void updateAdvisoryData(uint8 enHDRStatus);
      void updatePSDData(NARRadioMainData& radioMainData);
      void updateHdInfoData(NARRadioMainData& radioMainData);
      void updateHDAlbumArt(const ::std::vector< uint8 >& u8ImageData, uint32 u32ImageDataSize, bool displayStatus);
      void updateHDIconpresets(uint8 presetNo, uint8 bHDStatus, uint32 SPSvalue);
      void setCategory(std::string& category);
      void clearAlbumArt();
      void clearDefaultAlbumArt();
      void setBallGameMode(bool& status);
      //For HD Info Screen
      DataBindingItem<RdsRadioTextDataBindingSource> _rdsRadioTextInfo;
      DataBindingItem<HomeScreenFmHdLogoDataBindingSource> oHomeScreenFmHdLogo;
      DataBindingItem<HomeScreenAmHdLogoDataBindingSource> oHomeScreenAmHdLogo;
      void HomeScreenFMHDLogo(uint8 HomeScreenHDlogo);
      void HomeScreenAMHDLogo(uint8 HomeScreenHDlogo);
      void setRDSRadioText();
      void updateRdsRadioText(std::string& radioText);
      static void TraceCmd_RdsRadioTextUpdate(std::string radioText);

      //Added for HD DTM wst4kor
      DataBindingItem<DtmHDDataBindingSource> oDtmHD;
      void setHDProgSizeTestmode(uint8 TestaudioProgram, uint8 Testactive);
      void setHDProgAvailableTestmode(uint8 TestaudioProgramAvailable, uint8 Testavailable);
      DataBindingItem<TMHDAudioMPSDataBindingSource>  oTMHDAudioMPS;
      DataBindingItem<TMHDAudioSPS1DataBindingSource> oTMHDAudioSPS1;
      DataBindingItem<TMHDAudioSPS2DataBindingSource> oTMHDAudioSPS2;
      DataBindingItem<TMHDAudioSPS3DataBindingSource> oTMHDAudioSPS3;
      DataBindingItem<TMHDAudioSPS4DataBindingSource> oTMHDAudioSPS4;
      DataBindingItem<TMHDAudioSPS5DataBindingSource> oTMHDAudioSPS5;
      DataBindingItem<TMHDAudioSPS6DataBindingSource> oTMHDAudioSPS6;
      DataBindingItem<TMHDAudioSPS7DataBindingSource> oTMHDAudioSPS7;

      DataBindingItem<SPIVisibilityTunerDataBindingSource> oSPIVisibilityDataTuner;

      bool cobOnShutdownMsg(const Courier::Message& corfoMsg);
      bool cobOnUpdateTunerStatusMsg(const Courier::Message& corfoMsg) const;
      void InitialIconHighlight();
      /* Handles popup message  */
      bool bOnPresetPopupMsg(const Courier::Message& corfoMsg);
      void vSendCheckBoxMsg(tenMenuID enType, Courier::UInt32 u32SelectedItem);

      /* Updates TunerInfo fields on waveband change */
      //bool bOnUpdateWaveBandStatusMsg(const Courier::Message& corfoMsg);
      void CheckAMActivation();
      /* Updates the frequency value */
      bool bOnUpdateFrequencyMsg(const Courier::Message& corfoMsg);

      //bool bOnUpdatePSNameTPMsg(const Courier::Message& corfoMsg);
      //bool bOnUpdatePresetMsg(const Courier::Message &corfoMsg);

      tVoid vHandleSliderChange(const Courier::Request& request);												//	To handle the change in the slider direction
      bool bOnUpdate_Slider_TunerFrequencyMsg(const Courier::Message& corfoMsg);
      bool bOnUpdateRDSSupport(const Courier::Message& corfoMsg);

      bool bOnUpdateEngineeringMenuMsg(const Courier::Message& corfoMsg);
      bool bOnUpdateEngineeringMenuMsg1(const Courier::Message& corfoMsg);
      bool bOnUpdateEngineeringMenuMsg2(const Courier::Message& corfoMsg);

      bool bOnUpdateBandscanStatus(const Courier::Message& corfoMsg);
      bool bOnUpdateAntennaStatus(const Courier::Message& corfoMsg);

      bool bOnChannelInfoMsg(const Courier::Message& corfoMsg);  //wst4kor

      bool bOnUpdateBrowseMsg(const Courier::Message& corfoMsg);
      bool bOnUpdateWindowData(const Courier::Message& corfoMsg);
      bool bOnDABChannelInfoMsg(const Courier::Message& corfoMsg);
      bool bOnCannotStorePopupMsg(const Courier::Message& corfoMsg);
      bool bOnUpdateAutoStoreMsg(const Courier::Message& corfoMsg);
      bool cobSelectedListItemInfo(const Courier::Message& corfoMsg);
      tVoid vUpdateTASourceProvider(void);
      tVoid vUpdatePTY31SourceProvider(void);
      tVoid vHandleMainMenuOption(Courier::UInt32 u32SelectedItem);
      bool bOnUpdateTTMonitorTuner1(const Courier::Message& corfoMsg);
      bool bOnUpdateTTMonitorTuner2(const Courier::Message& corfoMsg);
      bool bOnUpdateTTMonitorTunerSource_Band(const Courier::Message& corfoMsg);
      bool bOnUpdateDABConcealmentLevelMsg(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeActiveServiceInfo(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeActiveEnsembleInfo(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeTunerStatusInfo(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeGTestmodeInfo(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeBGTestmodeInfo(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeAnnoStatus(const Courier::Message& corfoMsg);
      bool bOnUpdateDABGTestModeActiveComp(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeGAvailabilty(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeServiceFollowingStatus(const Courier::Message& corfoMsg);
      bool bOnUpdateDABTestModeTASource(const Courier::Message& corfoMsg);
      tVoid vHandleDABPTYFilterOption(Courier::UInt32 u32SelectedItem);
      bool bOnTmcStnInfoData(const Courier::Message& corfoMsg);
      bool bSendSliderRequestToBL();
      bool bOnUpdateActiveLineIndexInfo(const Courier::Message& corfoMsg);
      void updateFmTAStnName(const std::string& serviceLabel, const uint8 currentAnnoType);
      std::string m_sfrequencyvalue;
      std::string m_amFrequencyvalue;
      std::string m_FMStationName;
      std::string getfrequencyvalue();
      tU32 m_u32SliderValue;
      uint32 previousFreqvalue;
      void updateDabOtherAnnouncementsName(const std::string& serviceLabel);
      void vPresetTimeoutHandler();
      void vSliderTimeoutHandler();
      void vUpdateCurrentbankIcon();
      void ScanActive(bool scan_status);
      void updateFrequency(uint8& currentBand, uint32& currentFreqvalue, std::string& FrequencyUnit, std::string& psName);
      bool bOnUpdate_Slider_TunerFrequencyMsg(tU32 slidervalue);
      void updateFMpresets(::std::vector<std::string>& rfoPresetList);
      void updateFMpresets(::std::vector<std::string>& rfoPresetList, tU8 u8BankID);
      void updateAMpresets(::std::vector<std::string>& rfoPresetList, tU8 u8BankID);
      void updateDABpresets(::std::vector<std::string>& rfoPresetList);
      void updatedata(void);
      void CheckDABMounted();
      void CheckSXMMounted();
      bool updateASTStatus(bool status);
      bool vUpdate_DAB_PresetFocused(tU16 PresetNumber);
      bool vUpdate_FM_PresetFocused(tU16 PresetNumber);
      bool vUpdate_AM_PresetFocused(tU16 PresetNumber);
      void UpdateSourceIconData(tU8 Previous_View);
      void UpdateSourceIcon(tU8 Previous_View);
      void UpdateDABServiceLinkingMsg(uint8 index);
      //TestMode Functions
      void updateCalibrationData(std::string calibFMTun1, std::string calibFMTun2, std::string calibFMTun3, std::string calibFMTun4, std::string calibAMTun);
      void updateTun1QuadData(std::string band, std::string freq, std::string PI, std::string psName, std::string FS_Q, std::string hCut, std::string sharx,
                              std::string PD, std::string TP, std::string TA, std::string RDS, std::string AFlength, std::string MP_NC, std::string deviation, std::string CS);
      void updateTun2QuadData(std::string band, std::string freq, std::string PI, std::string psName, std::string FS_Q, std::string hCut, std::string sharx,
                              std::string PD, std::string TP, std::string TA, std::string RDS, std::string AFlength, std::string MP_NC, std::string deviation, std::string CS);
      void updateTun3QuadData(std::string band, std::string freq, std::string PI, std::string psName, std::string FS_Q, std::string hCut, std::string sharx,
                              std::string PD, std::string TP, std::string TA, std::string RDS, std::string AFlength, std::string MP_NC, std::string deviation, std::string CS);
      void updateTun4QuadData(std::string band, std::string freq, std::string PI, std::string psName, std::string FS_Q, std::string hCut, std::string sharx,
                              std::string PD, std::string TP, std::string TA, std::string RDS, std::string AFlength, std::string MP_NC, std::string deviation, std::string CS);

      void updateQuadMonitorStatus(bool tuner1Status, bool tuner2Status, bool tuner3Status, bool tuner4Status,
                                   bool band1Status, bool band2Status, bool band3Status, bool band4Status,
                                   bool isBand1Enabled, bool isBand2Enabled, bool isBand3Enabled, bool isBand4Enabled, bool isTuner1Enable, bool isTuner2Enable, bool isTuner3Enable, bool isTuner4Enable);

      void updateTMactiveTunerdata(uint8 activeBand);
      void updateEngineeringMenu(std::string freq, std::string psName, std::string PI, std::string FS_Q, std::string Quality, std::string hCut, std::string sharx,
                                 std::string deviation, std::string CS);
      //KDS Related methods
      void setFMSliderValues(uint32 u32FMLowRange, uint32 u32FMHiRange, uint32 u32FMFrequencyStep);
      void setAMSliderValues(uint32 u32AMStartFreq, uint16 u16AMmaxvalue, uint8 u8AMnoofsteps, uint32 u32AMFrequencyStepSize);
      void FMAMHomeScreen();
      void AMHomeScreen();
      void DABHomeScreen();
      void WXHomeScreen();
      //wst4kor HD Test Mode
      void updateHdDTMScreenInfo(std::string hdStatus, std::string sisStatus, std::string audStatus,
                                 std::string blendStatus);
      void updateHdDTMAudiblePhysicalTunerInfo(std::string HD10Freq, std::string FST);
      void updateHdDTMSecPhysicalTunerInfo(std::string HD05Freq, std::string HD05FST);
      void updateDTMHdAudibleTunerCdNo(std::string Hd10cd_No);
      void updateDTMHdInfo(std::string hdCallSign, std::string cdNo, std::string audQuality);
      void updateDTMHdTransitionCount(std::string transitionCount);
      void updateFmPsName(std::string& psName);
      void updateAmPsName(std::string& psName);
      std::string _AMPSName;

      void vOnUpdateSearchNextPreviousIconMsg(bool iconState);
      void updateSpidataVisibilityonTunerGadget(bool val);
      void SetSXMActive(bool active);
      //Current value for the  progress bar in the popup view
      tU8 m_u8timerCount;
      tU8 m_u8popupState;
      bool m_bIsTASourceDAB;
      bool m_bIsPTYSourceDAB;
      Candera::String m_sFMTASourcePSName;
      Candera::String m_sDABTASourcePSName;
      tU8  m_u8FMFocusedPresestNumber;
      tU8  m_u8AMFocusedPresestNumber;
      tU8 m_u8CurrentPresetNr;
      tU32 m_u32FMHiRange;
      tU32 m_u32FMLowRange;
      tU32 m_u32AMHiRange;
      tU32 m_u32AMLowRange;

      bool onCourierMessage(const ChannelInfoMsg& corfoMsg);  //wst4kor

      void TunerPLMsg(tU8 u8EventType, tU32 u32Para, Candera::String const& szStrPara);
      bool onCourierMessage(const TunerEngineeringModeMsg2& corfoMsg);
      bool onCourierMessage(const UpdatePresetMsg& corfoMsg);
      //bool onCourierMessage(const TunerPLMsg& corfoMsg);
      //bool onCourierMessage(const TunerEngineeringModeMsg2& corfoMsg);
      bool onCourierMessage(const Courier::StartupMsg& corfoMsg);
      bool onCourierMessage(const ShutdownMsg& corfoMsg);
      bool onCourierMessage(const UpdateTunerStatusMsg& corfoMsg);

      //bool onCourierMessage(const UpdateWaveBandStatusMsg& corfoMsg);
      bool onCourierMessage(const UpdateFrequencyMsg& corfoMsg);
      bool onCourierMessage(const UpdatePSNameTPMsg& corfoMsg);
      bool onCourierMessage(const UpdateFMPresetFocused& corfoMsg);
      bool onCourierMessage(const UpdateAMPresetFocused& corfoMsg);
      bool onCourierMessage(const PresetPopupMsg& corfoMsg);
      bool onCourierMessage(const LPReleaseMsg& corfoMsg);
      //bool onCourierMessage(const UpdateModelMsg& corfoMsg);
      bool onCourierMessage(const Courier::UpdateModelMsg& corfoMsg);
      bool onCourierMessage(const Update_Slider_TunerFrequencyMsg& corfoMsg);
      bool onCourierMessage(const UpdateCurrentBank& corfoMsg);
      bool onCourierMessage(const RDSSupport& corfoMsg);
      //bool onCourierMessage(const TunerEngineeringModeMsg& corfoMsg);
      //bool onCourierMessage(const TunerEngineeringModeMsg1& corfoMsg);
      bool onCourierMessage(const AntennaStatus& corfoMsg);
      bool onCourierMessage(const BandscanStatus& corfoMsg);
      //bool onCourierMessage(const TunerPLMsg& corfoMsg);
      bool onCourierMessage(const BrowseListRespMsg& corfoMsg);
      //bool onCourierMessage(const Courier::UpdateWindowData& corfoMsg);
      bool onCourierMessage(const DABChannelInfoMsg& corfoMsg);
      bool onCourierMessage(const CannotStorePopupMsg& corfoMsg);
      bool onCourierMessage(const UpdateAutoStoreMsg& corfoMsg);
      //bool onCourierMessage(const SelectedListItemInfo& corfoMsg);
      bool onCourierMessage(const TripleTunerMonitorDataSet1& corfoMsg);
      bool onCourierMessage(const TripleTunerMonitorDataSet2& corfoMsg);
      bool onCourierMessage(const TripleTunerMonitorDataSet3& corfoMsg);
      bool onCourierMessage(const DABServiceLinkingMsg& corfoMsg);
      bool onCourierMessage(const DABConcealmentLevelMsg& corfoMsg);
      bool onCourierMessage(const DABTestModeActiveServiceInfo& corfoMsg);
      bool onCourierMessage(const DABTestModeActiveEnsembleInfo& corfoMsg);
      bool onCourierMessage(const DABTestModeTunerStatusInfo& corfoMsg);
      bool onCourierMessage(const DABTestModeBGTestmodeInfo& corfoMsg);
      bool onCourierMessage(const DABTestModeGTestmodeInfo& corfoMsg);
      bool onCourierMessage(const DABTestModeAnnoStatus& corfoMsg);
      bool onCourierMessage(const DABTestModeActiveCompInfo& corfoMsg);
      bool onCourierMessage(const DABTestModeGAvailabilty& corfoMsg);
      bool onCourierMessage(const DABTestModeServiceFollowingStatus& corfoMsg);
      bool onCourierMessage(const DABTestModeTASource& corfoMsg);
      bool onCourierMessage(const TmcStnInfoData& corfoMsg);
      bool onCourierMessage(const ActiveLineIndexInfoMsg& corfoMsg);
      bool onCourierMessage(const NextSelectMsg_FM& corfoMsg);
      bool onCourierMessage(const PreviousSelectMsg_FM& corfoMsg);
      bool onCourierMessage(const NextSelectMsg_AM& corfoMsg);
      bool onCourierMessage(const PreviousSelectMsg_AM& corfoMsg);
      bool onCourierMessage(const NextSelectMsg_DAB& corfoMsg);
      bool onCourierMessage(const PreviousSelectMsg_DAB& corfoMsg);
      bool onCourierMessage(const NextIconSelectMsg& corfoMsg);
      bool onCourierMessage(const PreviousIconSelectMsg& corfoMsg);
      bool onCourierMessage(const AbortNextPreviousIcon& corfoMsg);

      bool onCourierMessage(const GuiStartupFinishedUpdMsg& oMsg);

      asf::core::Timer m_oTimerPreset;
      asf::core::Timer m_oTimerSlider;

      void startPresetTimer();
      void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      void updateDabChannelData(std::string psName, std::string shortPsName, std::string activePresetNumText, uint8 presetIndicatorIndex);
      void setDLSelements(std::string davAdv, std::string radioText, uint8 switchIndex, uint8 enDabStatus);
      void setEnsembleName(std::string ensembleText);
      static TunerDataBindingHandler* getDataBindingHandlerInstance();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(TunerEngineeringModeMsg2)
      ON_COURIER_MESSAGE(UpdatePresetMsg)
      //ON_COURIER_MESSAGE(TunerPLMsg)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(ShutdownMsg)
      ON_COURIER_MESSAGE(UpdateTunerStatusMsg)
      //ON_COURIER_MESSAGE(UpdateWaveBandStatusMsg::ID, bOnUpdateWaveBandStatusMsg)
      ON_COURIER_MESSAGE(UpdateFrequencyMsg)
      ON_COURIER_MESSAGE(UpdatePSNameTPMsg)
      ON_COURIER_MESSAGE(UpdateFMPresetFocused)
      ON_COURIER_MESSAGE(UpdateAMPresetFocused)
      ON_COURIER_MESSAGE(PresetPopupMsg)
      ON_COURIER_MESSAGE(LPReleaseMsg)
      ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      ON_COURIER_MESSAGE(Update_Slider_TunerFrequencyMsg)
      ON_COURIER_MESSAGE(UpdateCurrentBank)
      ON_COURIER_MESSAGE(RDSSupport)
      //ON_COURIER_MESSAGE(TunerEngineeringModeMsg::ID, bOnUpdateEngineeringMenuMsg)
      //ON_COURIER_MESSAGE(TunerEngineeringModeMsg1::ID, bOnUpdateEngineeringMenuMsg1)
      //ON_COURIER_MESSAGE(TunerEngineeringModeMsg2)
      ON_COURIER_MESSAGE(AntennaStatus)
      ON_COURIER_MESSAGE(BandscanStatus)
      //ON_COURIER_MESSAGE(TunerPLMsg)
      ON_COURIER_MESSAGE(BrowseListRespMsg)
      //ON_COURIER_MESSAGE(UpdateWindowData)
      ON_COURIER_MESSAGE(DABChannelInfoMsg)
      ON_COURIER_MESSAGE(CannotStorePopupMsg)
      ON_COURIER_MESSAGE(UpdateAutoStoreMsg)
      //ON_COURIER_MESSAGE(SelectedListItemInfo)
      ON_COURIER_MESSAGE(TripleTunerMonitorDataSet1)
      ON_COURIER_MESSAGE(TripleTunerMonitorDataSet2)
      ON_COURIER_MESSAGE(TripleTunerMonitorDataSet3)
      ON_COURIER_MESSAGE(DABServiceLinkingMsg)
      ON_COURIER_MESSAGE(DABConcealmentLevelMsg)
      ON_COURIER_MESSAGE(DABTestModeActiveServiceInfo)
      ON_COURIER_MESSAGE(DABTestModeActiveEnsembleInfo)
      ON_COURIER_MESSAGE(DABTestModeTunerStatusInfo)
      ON_COURIER_MESSAGE(DABTestModeBGTestmodeInfo)
      ON_COURIER_MESSAGE(DABTestModeGTestmodeInfo)
      ON_COURIER_MESSAGE(DABTestModeAnnoStatus)
      ON_COURIER_MESSAGE(DABTestModeActiveCompInfo)
      ON_COURIER_MESSAGE(DABTestModeGAvailabilty)
      ON_COURIER_MESSAGE(DABTestModeServiceFollowingStatus)
      ON_COURIER_MESSAGE(DABTestModeTASource)
      ON_COURIER_MESSAGE(TmcStnInfoData)
      ON_COURIER_MESSAGE(ActiveLineIndexInfoMsg)
      ON_COURIER_MESSAGE(NextSelectMsg_FM)
      ON_COURIER_MESSAGE(PreviousSelectMsg_FM)
      ON_COURIER_MESSAGE(NextSelectMsg_AM)
      ON_COURIER_MESSAGE(PreviousSelectMsg_AM)
      ON_COURIER_MESSAGE(NextSelectMsg_DAB)
      ON_COURIER_MESSAGE(PreviousSelectMsg_DAB)
      ON_COURIER_MESSAGE(NextIconSelectMsg)
      ON_COURIER_MESSAGE(PreviousIconSelectMsg)
      ON_COURIER_MESSAGE(AbortNextPreviousIcon)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)

      ON_COURIER_MESSAGE(ChannelInfoMsg)  //wst4kor

      COURIER_MSG_MAP_END()

   private:
      static TunerDataBindingHandler* m_tunerDataBindingHandler;

      /** Instance for the timer */
      asf::core::Timer _hdStationLogoTimer;

      bool _hdAlbumArtVisibilityStatus;
      bool _isHDAlbumArtSet;
      ::std::vector< uint8 > _u8HdImageData;

      std::string _imageData;
      std::string _radioMainText;
};


} // namespace Core
} // namespace App
#endif
