/**************************************************************************************
* @file         : ATStationInfo.h
* @author       : ECV- pbe5kor
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle AM FM AtStationinfo data.
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ATSTATIONINFO_H_
#define ATSTATIONINFO_H_

#include "MIDW_TUNER_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AMFMInfoIF.h"
#include "AMFMStationList.h"
//#include "App/Core/TestMode/AMFMTestMode.h"
//#include "TunerDataBindingHandler.h"
#include "AMFMTestMode.h"
#include "App/Core/AMFMInfo/AMFMHDdata.h"
#include "App/Core/Utility/TunerCommonHandler.h"
#include "AMFMHDdata.h"
#include "AMFMTestMode.h"


class StartupSync;
namespace App {
namespace Core {

/*
class PresetListHandlingIF;
class AMFMTestmodeIF;
class TestModeIF; */
class AMFMInfoIF;
class AMFMStationIF;
class AMFMHDdata;

/* class ATStationInfo
 * All the properties and methods of MIDW_TUNER_FI are implemented by this class
 */
class ATStationInfo : public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOCallbackIF
{
   private:
      ATStationInfo();
      static ATStationInfo* m_poATStationInfo;
   public:

      static ATStationInfo* poGetInstance()
      {
         if (NULL == m_poATStationInfo)
         {
            m_poATStationInfo = new ATStationInfo();
         }
         return m_poATStationInfo;
      }
      virtual ~ATStationInfo();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      // class FID_TUN_G_ATSTATIONINFOCallbackIF implementation
      virtual void onFID_TUN_G_ATSTATIONINFOError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOError >& /*error*/);
      virtual void onFID_TUN_G_ATSTATIONINFOStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOStatus >& status);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      /** Instance of MIDW_TUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;

      /** Instance of PresetListHandlingIF */
      //PresetListHandlingIF* _PresetListHandlingIF;

      /** Instance of AMFMInfoIF */
      AMFMInfoIF* _AMFMInfoIF;
      AMFMStationList* _AMFMStationListIF;
      AMFMHDdata* _AMFMHDdata;
      AMFMTestMode* _AMFMTestMode;
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif /* ATSTATIONINFO_H_ */
