/**************************************************************************************
* @file         : AMFMStationListTimer.h
* @author       : ECV2-Deepak Bayiri
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle AM FM List Timer.
* @copyright    : (c) 2017-2017 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef AMFMStationListTimer_H_
#define AMFMStationListTimer_H_

#include "asf/core/Timer.h"
namespace App {
namespace Core {


class clStationListTimer : public ::asf::core::TimerCallbackIF
{
   public:

      virtual ~clStationListTimer();
      clStationListTimer();
      static clStationListTimer* getInstance();
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

      void restartTimer();
      void startTimer();
      void stopTimer();

      /** Instance for the timer */
      asf::core::Timer _stationListTimer;

      /** Instance of clStationListTimer */
      static clStationListTimer* _stnListTimer;
};


}
}


#endif
