/**************************************************************************************
* @file         : AMFMStationIF.h
* @author       : ECV2-Rohini S R
* @addtogroup   : Tuner HALL
* @brief        : Interface class for AM FM AtstationInfo handling functions.
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AMFMSTATIONIF_H_
#define AMFMSTATIONIF_H_

#include "asf/core/Types.h"
#include "MIDW_TUNER_FIProxy.h"

namespace App {
namespace Core {

class AMFMStationIF
{
   public:
      virtual ~AMFMStationIF() {};

      virtual void setStartIndex() = 0;
      virtual void setAtStationInfoDataToAMFMStationList(const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOStatus >& status) = 0;

      //  virtual void fmListOperate(uint8& entered) = 0;
      // virtual void ListHKHandling(const uint8& hkValue) = 0;
      // virtual void scan(bool scanOnOff) = 0;
      // virtual void sendConfigListUpdateStart(bool& startStop) = 0;
      virtual void setAtStationInfoHDdataToAMFMSTationList(const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOStatus >& status) = 0;
      virtual void setFMHDActiveStatus(bool& FMHDActiveStatus) = 0;
      virtual void setAMHDActiveStatus(bool& AMHDActiveStatus) = 0;
      virtual void setHDDecodingData(bool& HDDataDecoding, bool& HDAudioDecoding) = 0;
      virtual void setHDTimerStatus(bool HDTimerStatus) = 0;

#if  defined VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
      virtual void AmListOperate(uint8& entered) = 0;
      virtual void startStopListTimer(bool timerStatus) = 0;
      virtual void setFooterTxt(uint32 focusIndex) = 0;
#endif
};


}
}


#endif /* AMFMSTATIONIF_H_ */
