/**************************************************************************************
* @file         : AMFMCourierMsgIF.h
* @author       : ECV2-Rohini S R
* @addtogroup   : Tuner HALL
* @brief        : Interface class for AM FM Info handling functions.
* @copyright    : (c) 2017-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AMFMInfoIF_H_
#define AMFMInfoIF_H_

#include "asf/core/Types.h"

namespace App {
namespace Core {

class AMFMInfoIF
{
   public:
      virtual ~AMFMInfoIF() {};
      virtual void seek(uint8 mode) = 0;
      virtual void vScanRequestMessage() = 0;
      virtual void vSlider_TunerFrequencyMsg(uint32 u32SliderValue) = 0;
      virtual void setAtStationInfoRadioMainData(uint8& currentBand, uint32& currentFreq, uint16& presetID, std::string& psName) = 0;
      virtual void vSeekStart(uint8 seekMode, uint32 u32Frequency) = 0;
      virtual void vTuneFrequencyStart(uint8 manualFreqAdjustmentDirection, uint8 u8NumberOfTicks) = 0;
      virtual void setTunerAppStatus(uint8& appStatus) = 0;
};


}
}


#endif /* AMFMInfoIF_H_ */
