/*****************************************************************************
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle AM FM Info.
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AMFMInfo_H
#define AMFMInfo_H

#include "MIDW_TUNER_FIProxy.h"
#include "AMFMInfoIF.h"
#include "AppBase/ServiceAvailableIF.h"
#include "TunerDataBindingHandler.h"
#include "AMFMInfoCourierMsgHandler.h"
#include "ATStationInfo.h"
#include "AppHmi_TunerDatabinding.h"
#include "AppHmi_TunerStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "midw_tuner_fi_types.h"
#include "midw_tunermaster_fi_types.h"
#include "App/Core/PresetListHandler/PresetListHandling.h"
#include "App/datapool/TunerDataPoolConfig.h"
#include "AMFMStationList.h"
#include "PresetListHandling.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "../SourceChangeHandler/SrcChangeHandler.h"

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif

#define TUN_DIRECTION_UP            ((VS_UINT32) 0ul)
#define TUN_DIRECTION_DOWN          ((VS_UINT32) 1ul)
#define MAX_PRESET_PS_NAME     (32+1)
#define MAX_BANK_PRESET_LIST   (6+1)
#define MAX_FM_PRESET_LIST     (12)

#define AM_SLIDER_STEP_9k           (9)
#define AM_SLIDER_1611              1611
#define AM_SLIDER_NOOFSTEPS_9K      1209
#define AM_SLIDER_MAX_9K            1721

#define AM_SLIDER_1629              1629
#define AM_SLIDER_NOOFSTEPS_EU_9K   1209
#define AM_SLIDER_MAX_EU_9K         1721

//
//#define Enum_APP_MODE_DOWNLOAD           ((VS_UINT32) 5ul)
//#define Enum_APP_MODE_SECURE             ((VS_UINT32) 7ul)
//#define Enum_TUN_PI_STEP                 ((VS_UINT32) 4ul)

class StartupSync;
namespace App {
namespace Core {


//Forward Declarations
class PresetListHandlingIF;

using namespace ::midw_tuner_fi_types;
using namespace ::midw_tunermaster_fi_types;
using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;

typedef struct
{
   tU32 m_u32Frequency;
   tU8  m_u8PresetNumber;
} t_rPresetInfoElement;

typedef struct
{
   tU32 u32Frequency;
   tU16 u16PI;
   std::string sPSName;
   T_e8_Tun_TunerBand e8Band;
   T_e8_AtStationTPinfo e8AtStationTPinfo;
   tU16 u16PresetListID;
   tU16 u16PresetElementId;
   tU16 u16ConfigListElementID;
} t_rAtStationInfo;

class tclTunStaionList
{
   public:
      tU32 u32PI;
      std::string szPsName;
      tU32 u32Frequency;
      tBool bTpInfo;
      tU8 u8ElementSelected;
      tU8 u8PositionInPresetList;
      //midw_fi_tcl_e8_Tun_ListID e8PresetListForAcmp;
};


class tclAFStaionList
{
   public:
      std::string AFData;
      tU32 u32AFFrequency;
      tU8 u8ElementSelected;
};


class tclTMCStaionList
{
   public:
      std::string szPsName;
      std::string szTMCData;
      tU32 u32Frequency;
      tU8 u8ElementSelected;
      tU32 u32PI;
      tU8 u8SID;
      tU8 u8Quality;
      tU8 u8CC;
      tU8 u8LTN;
      tU8 u8PTY;
};


class tclPresetInfoList
{
   public:
      tclPresetInfoList();
      t_rPresetInfoElement m_arPresetInfoList[MAX_BANK_PRESET_LIST];
};


class tclFMPresetInfoList : public tclPresetInfoList
{
   public:
      std::string m_oaPSName[MAX_BANK_PRESET_LIST];
};


/* class AMFMInfo
 * All the properties and methods of MIDW_TUNER_FI are implemented by this class
 */
class AMFMInfo : public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_RADIO_TEXTCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_ATSEEK_WITH_TUNERHEADERCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_ATFREQUENCYCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SET_PICallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_ATSEEKCallbackIF,
   public ::ActiveRegionIdCallbackIF,
   public AMFMInfoIF
{
   private:
      AMFMInfo();
      AMFMInfo(const AMFMInfo&);
      AMFMInfo& operator =(const AMFMInfo&);
      static AMFMInfo* m_poAMFMInfo;
   public:

      static AMFMInfo* poGetInstance()
      {
         if (NULL == m_poAMFMInfo)
         {
            m_poAMFMInfo = new AMFMInfo();
         }

         return m_poAMFMInfo;
      }

      virtual ~AMFMInfo();
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      //virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange &stateChange);

      // class FID_TUN_G_ATSEEKCallbackIF implementation
      virtual void onFID_TUN_G_RADIO_TEXTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_RADIO_TEXTError >& /*error*/);
      virtual void onFID_TUN_G_RADIO_TEXTStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_RADIO_TEXTStatus >& status);

      virtual void onFID_TUN_S_ATSEEK_WITH_TUNERHEADERError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_ATSEEK_WITH_TUNERHEADERError >& /*error*/);
      virtual void onFID_TUN_S_ATSEEK_WITH_TUNERHEADERResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult >& /*result*/);

      virtual void onFID_TUN_S_ATFREQUENCYError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_ATFREQUENCYError >& /*error*/);
      virtual void onFID_TUN_S_ATFREQUENCYResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_ATFREQUENCYResult >& /*result*/);

      virtual void onFID_TUN_S_DIRECT_FREQUENCYError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYError >& /*error*/);
      virtual void onFID_TUN_S_DIRECT_FREQUENCYResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYResult >& /*result*/);

      virtual void onFID_TUN_S_SET_PIError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_PIError >& /*error*/);
      virtual void onFID_TUN_S_SET_PIResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_PIResult >& /*result*/);

      virtual void onFID_TUN_G_ATSEEKError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSEEKError >& /*error*/);
      virtual void onFID_TUN_G_ATSEEKStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSEEKStatus >& status);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdError >& error);
      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdUpdate >& update);

      void vTuneFrequencyStart(tU8 manualFreqAdjustmentDirection, tU8 u8NumberOfTicks);
      void seek(tU8 mode);
      void vSeekStart(tU8 seekMode, tU32 u32Frequency);
      void vScanRequestMessage();
      void vSlider_TunerFrequencyMsg(uint32 u32SliderValue);
      void vDirect_Frequency_Change_Start(T_e8_Tun_TunerBand u8Band, tU32 u32Frequency);

      virtual void setAtStationInfoRadioMainData(uint8& currentBand, uint32& currentFreq, uint16& presetID, std::string& psName);
      void vOnUpdateScanMsg(tBool bIsScanActive);
      virtual void vUpdateSliderValue();
      bool bSendMsgToPL(tU8 u8EventType, tU32 u32Para, Candera::String const& szStrPara) const;

      std::string getFrequencyUnit();

      void vUpdateFreqConversion();
      void vUpdatePSName(const tChar* szPSName)const;
      void vUpdateFrequency(const tChar* szFrequency, tU8 u8Band)const;

      void setTunerAppStatus(uint8& appStatus);

      //TTFis Trace cmds
      static void TraceCmd_onSeek(uint8 seekType, uint8 seekDirection, uint8 keytype);
      static void TraceCmd_onTargetSeek(uint8 seekDirection);
      static void TraceCmd_onAutoSeek(uint8 seekDirection);
      static void TraceCmd_onManualStepSeek(uint8 seekDirection);
      static void TraceCmd_onScan();
      static void TraceCmd_onTestCommand(uint8 u8TestNumber);
      static void TraceCmd_onSwitchPlayView(uint8 u8PlayView);

      void manualStepSeek(uint8& seekDirection);
      void targetSeek(uint8& seekDirection);
      //virtual void seek(uint8 seekType, uint8 seekDirection, uint8 keytype);

      bool IsBandFM(T_e8_Tun_TunerBand enPrestType);
      //bool IsBandAM(T_e8_Tun_TunerBand enPrestType);
      bool IsBandDAB(T_e8_Tun_TunerBand enPrestType);
      bool bOnUpdateScanMsg(bool ScanActive, bool Seekstatus);
      tVoid vAbortTunerFunctionality();

      void vUpdateKDSValueToModel() const;
      void vGetKDSValue();

      //KDS related Ends
      void setTunerAppStatus(uint8 appStatus);

      void getRegionType();   //for HD wst4kor

      tclPresetInfoList* poGetPresetList(T_e8_Tun_ListID enPrestType);

      T_e8_Band e8GetCurrentBand() const
      {
         return _band;
      }

      void vSetCurrentBand(T_e8_Band e8Band)
      {
         _band = e8Band;
      }

      //Added for HD Button status
      void setFMHDIndicatorStatus(bool isActive);
      bool getFMHDIndicatorStatus();
      bool HDActive;

      t_rAtStationInfo m_rAtStationInfo;
      tclPresetInfoList m_oAMPresetInfo;
      tclPresetInfoList m_oAM_ASTPresetInfo;
      tclFMPresetInfoList m_oFM1PresetInfo;
      tclFMPresetInfoList m_oFM2PresetInfo;
      tclFMPresetInfoList m_oFM_ASTPresetInfo;

      tBool m_bIsScanActive;
      //tBool m_bIsSearchNextPreviousIcon;
      T_e8_Tun_TunerSeek m_enSeekType;
      T_e8_Band _band;
      tU32 m_u32AMFrequencyStep;
      tU32 m_u32FMFrequencyStep;
      tU32 m_u32FMLowRange;
      tU32 m_u32FMHiRange;
      tU32 m_u32AMLowRange;
      tU32 m_u32AMHiRange;
      bool m_bIsSeekStatus;
      tU16 m_u8AMnoofsteps;
      tU16 m_u16AMmaxvalue;
      tBool m_TAActive;

      tU8 m_bRDSConfigEnable;
      tBool m_bOptRadioText;
      tBool m_PTY31Active;
      tU8 m_u8KDSConfigREG_Enable;
      tU8 m_u8KDSConfigTA_Enable;
      tU32 m_u32AMStartFreq;
      tBool m_bOptDabDynamicText;
      tBool m_bOptDabFmFollowing;
      tBool m_EnggModeActive;
      tBool m_bOptDabDabFollowing;
      tU8 m_u8KDSConfigAF_Enable;
      tU32 m_u32CurrentTunedFreq;

      /** Member variable to hold Tuner Background status*/
      uint8 _tunerStatus;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_AmFmInfoCourierMsgHandler)

      COURIER_MSG_MAP_DELEGATE_END()

      void vRequestView1(tenViewID u8TestNumber);
      void onTunerCommandReq(uint32 u8tunerCommand);
      void onTACommandReq(uint32 u8taCommand);
      void onRDSCommandReq(uint32 u8rdsCommand);

   private:

      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;     // Instance of MIDW_TUNER_FIProxy
      TunerDataBindingHandler* _AmFmInfoDataBinder;
      AMFMInfoCourierMsgHandler* _AmFmInfoCourierMsgHandler;
      std::string _radiotxt;
      bool bIsValidString(std::string& rfoString, tBool bEmptyString = TRUE);

      uint8 m_u8activeRegion;

      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App
#endif
