/**************************************************************************************
* @file         : AMFMHDdata.h
* @author       : ECV- Rohini S R
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle AM FM HD data.
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AMFMHDDATA_H_
#define AMFMHDDATA_H_

#include "MIDW_TUNER_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
//#include "AMFMHDdataIF.h"
#include "TunerDataBindingHandler.h"
#include "AMFMStationIF.h"
//#include "PresetListHandlingIF.h"
#include "App/Core/RadioSettings/RadioSetting.h"
#include "AppHmi_TunerDatabinding.h"
#include "AMFMStationList.h"
#include "Common/DataModel/ListRegistry.h"
#include "AMFMInfo.h"
#include "AMFMInfoIF.h"

class StartupSync;
namespace App {
namespace Core {

//Forward Declarations


using namespace ::midw_tuner_fi_types;
using namespace ::midw_tunermaster_fi_types;
using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;

//class PresetListHandlingIF;
class TunerDataBindingHandler;
class AMFMStationIF;
class RadioSetting;
class AMFMInfo;

struct HDInfoScreenGenre
{
   std::string hdInfogenreName;
   int hdInfogenreID;  //TODO:once text id's available remove the string entry
};


struct HDMainScreenGenre
{
   std::string hdMainScrngenre;
   int hdMainScrngenreID;  //TODO:once text id's available remove the string entry
};


/* class AMFMHDdata
 * All the properties and methods of MIDW_TUNER_FI are implemented by this class
 */
class AMFMHDdata : public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_HD_PSD_DATACallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_DEMODULATION_SWITCH_STATUSCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SET_DEMODULATION_SWITCHCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_HD_IMAGEFILE_UPDATECallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_HD_LONGNAMECallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_HD_AVISORY_INFOCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_HD_SIGNALLOST_TIMERCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_RADIO_TEXTCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOCallbackIF
{
   private:
      AMFMHDdata();
      AMFMHDdata(const AMFMHDdata&);
      AMFMHDdata& operator =(const AMFMHDdata&);
      static AMFMHDdata* m_poAMFMHDdata;
   public:
      static AMFMHDdata* poGetInstance()
      {
         if (NULL == m_poAMFMHDdata)
         {
            m_poAMFMHDdata = new AMFMHDdata();
         }

         return m_poAMFMHDdata;
      }
      virtual ~AMFMHDdata();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      //Properties
      virtual void onFID_TUN_G_HD_PSD_DATAError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_PSD_DATAError >& /*error*/);
      virtual void onFID_TUN_G_HD_PSD_DATAStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_PSD_DATAStatus >& status);

      virtual void onFID_TUN_G_DEMODULATION_SWITCH_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_DEMODULATION_SWITCH_STATUSError >& /*error*/);
      virtual void onFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus >& status);

      virtual void onFID_TUN_S_SET_DEMODULATION_SWITCHError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_DEMODULATION_SWITCHError >& /*error*/);
      virtual void onFID_TUN_S_SET_DEMODULATION_SWITCHResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_DEMODULATION_SWITCHResult >& result);

      virtual void onFID_TUN_G_HD_IMAGEFILE_UPDATEError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_IMAGEFILE_UPDATEError >& /*error*/);
      virtual void onFID_TUN_G_HD_IMAGEFILE_UPDATEStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_IMAGEFILE_UPDATEStatus >& status);

      virtual void onFID_TUN_G_HD_LONGNAMEError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_LONGNAMEError >& /*error*/);
      virtual void onFID_TUN_G_HD_LONGNAMEStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_LONGNAMEStatus >& /*status*/);

      virtual void onFID_TUN_G_HD_AVISORY_INFOError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_AVISORY_INFOError >& /*error*/);
      virtual void onFID_TUN_G_HD_AVISORY_INFOStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_AVISORY_INFOStatus >& status);

      virtual void onFID_TUN_G_HD_SIGNALLOST_TIMERError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_SIGNALLOST_TIMERError >& /*error*/);
      virtual void onFID_TUN_G_HD_SIGNALLOST_TIMERStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_HD_SIGNALLOST_TIMERStatus >& status);

      virtual void onFID_TUN_G_RADIO_TEXTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_RADIO_TEXTError >& /*error*/);
      virtual void onFID_TUN_G_RADIO_TEXTStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_RADIO_TEXTStatus >& status);

      virtual void onFID_TUN_G_ATSTATIONINFOError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOError >& /*error*/);
      virtual void onFID_TUN_G_ATSTATIONINFOStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOStatus >& status);

      /** Member variable to hold  HD data decoding status */
      bool _HDDataDecoding;

      /** Member variable to hold  HD Audio decoding status */
      bool _HDAudioDecoding;

      /** Member variable to highlight active HD Audio Program  */
      uint8 _activeHDAudioPrg;

      /** Variable to hold Current band */
      uint8 _band;

      /** Variable to hold Demod data */
      bool _isDemodSet;

      /** Variable to hold switch index on radio Main screen */
      uint8 _switchIndex;

      uint32 _timerStatus;

      /** Variable to hold Category Name in NAR variant */
      std::string _categoryName;

      /** Instance for the Radio Main Data */
      NARRadioMainData _radioMainData;

      /* Boolean Member Variable is true if FM HD status is active */
      bool _FMHDActive;

      /** Boolean Member Variable is true if AM HD status is active */
      bool _AMHDActive;

      /** Member Variable to hold Screen entry/exit status */
      bool _HdInfoScreenStatus;

      //Advisory text
      HdAdvisory enHDStatus;

      std::string _radiotxt;

      void clearHDInfoData();
      void clearOtherHDData();
      void clearPSDData();
      void updateHDLogo();
      void setHdLogoAndAudioProgramStatus();
      void setHdLogotoAcquiring();
      void setSwitchIndex();
      void updatePSName();

      bool bIsHDActive();

      /** Vector to hold HD Image*/
      std::vector<uint8> _HDImageFileInfo;

      void setBallGameModeData(bool& BallGameMode);

      uint8 getHDSwitchIndex();

      virtual void setHDInfoData(std::string& HDcallSign, uint8& activeHDAudioPrg, uint32& currentFreq, uint8& currentBand, std::string& psName, uint8& HDStationGenre);

      virtual void setHDData(bool& HDDataDecoding, bool& HDAudioDecoding);

      virtual void onToggleHD(const uint8& bandType);

      virtual void onHDInfoScreenAccessStatus(uint8& HDInfoScrStatus);
      void updateListInfo(uint32& listID);
      std::string getPSDGenre(std::string HDInfoGenre);
      bool is_digits(const std::string& str);

      bool getFMHDActiveStatus() const
      {
         return _FMHDActive;
      }

      bool getAMHDActiveStatus() const
      {
         return _AMHDActive;
      }

   private:
      /** Instance of MIDW_TUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;

      /** Instance for the PresetListHandlingIF */
      //PresetListHandlingIF* _PresetListHandlingIF;

      /** Instance of CourierMsgIF */
      //  AMFMHDdataIF* _AMFMHDdataIF;

      /** Instance for the DataBindingHandler */
      TunerDataBindingHandler* _AmFmInfoDataBinder;

      /** Instance for the AMFMStationList */
      AMFMStationList* _AMFMStationIF;

      /** Instance of AMFMInfo */
      AMFMInfo* _AmFmInfo;

      std::string _HDCallSign;

      /** Variable to hold Current tuned Frequency */
      uint32 _CurrentFreq;
      std::string _psName;

      // TunerCommonHandler* _TunerCommonHandler;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      /** Instance for the RadioSettings */
      RadioSettings* _RadioSettings;
#endif
      /** Member Variable to hold Screen entry/exit status */
      // bool _HdInfoScreenStatus;

      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif /* AMFMHDDATA_H_ */
