/**
 * @file        :  CGIAppViewFactory.cpp
 * @addtogroup  :  AppHmi_Testmode
 * @brief       :  SXM HALL class which contains all the necessary business logic required for CGI App
 * @copyright   :  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "gui_std_if.h"
#include "CGIAppViewFactory.h"
#include "AppHmi_TestmodeMessages.h"
// the views
#include "CGIAppViewController_Testmode.h"
#include "CgiExtensions/ViewScene2D.h"
/*-------------------------------------*/
/**
* RenderTargetInvalidatingViewScene is derived from ViewSceneBase.
* This class is used to invalidate the scene
*.
*
*/

SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_1_BLACK),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_2_WHITE),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_3_RED),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_4_GREEN),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_5_BLUE),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_8_MURA1),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_9_MURA2),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_TESTMODE__MAIN),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_TestModeScreens),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_TestmodeSourceSelection),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_MonitorTestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_TestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SystemSettingTestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_Triple_Tuner_Monitor),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_Triple_Tuner_Monitor2),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_Triple_Tuner_Monitor3),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB_Monitor),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_RVC_TESTMODE),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_TestMode_SXM_Monitor_List),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_SXM),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_SXM_Channel_List),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_Pfo_HealthCareMntr_DiagCtnrlTrouble),

// simple view controller from AppHmi_Tuner_SimpleViewController.h have not to be added here
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   COURIER_UNUSED(viewController);
}


/****************************EOF***********************/
