/**
 * @file        :  HMIModelComponent.h
 * @addtogroup  :  AppHmi_Testmode
 * @brief       :  SXM HALL class which contains all the necessary business logic required for SXM HMI
 * @copyright   :  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#if !defined(_HMI_MODEL_COMPONENT_H)
#define _HMI_MODEL_COMPONENT_H

#include "AppHmi_TestmodeMessages.h"

class HMIModelComponent
{
   public:
      //  Binding source instances
      //Courier::DataItemContainer<DummyDataBindingSource>m_DummyData;

      // Incomming events ...
      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      //bool onCourierMessage(const DummyChangedUpdMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_VIEW_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      //ON_COURIER_MESSAGE(DummyChangedUpdMsg)
      COURIER_MSG_MAP_END()

      HMIModelComponent();
      virtual ~HMIModelComponent();
      bool Init();
};


#endif // _HMI_MODEL_COMPONENT_H
