/* ***************************************************************************************
* FILE:          TestmodeHall.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TestmodeHall.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef TestmodeHall_h
#define TestmodeHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"
#include "AppHmi_TestmodeMessages.h"
//#include "App/datapool/TestmodeDataPoolConfig.h"
#include "TunerTestMode/AMFMTestMode.h"
#include "SystemSettingTestMode/SystemSettingTestMode.h"
#include "AudioTestMode/AudioTestMode.h"
//#include "WeatherBand/WeatherBandMain.h"
#include "SxmAudio/SxmTestMonitor.h"
#include "RVCTestMode/RearViewCamera.h"
#include "Diagnostics/NACVdemo.h"
#include "PhoneTestMode/PhoneTestMode.h"
#include "HealthCareTestMode/HealthCareTestMode.h"


//applicationSwitch changes
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"

#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include <Adapter/LanguageHandlerAdapter.h>

namespace App {
namespace Core {

class TestmodeHall
   : public HallComponentBase
//, public Sig_ActivateContextCallbackIF
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      TestmodeHall();
      virtual ~TestmodeHall();
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

      //  virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);

      //  virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      static void TraceCmd_onSwitchDisplayUpdateImageView(int u8TestNumber);

   protected:

      virtual bool onCourierMessage(const SwitchApplicationReq& oMsg);
      virtual uint8 readLanguageOnStartUp();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(SwitchApplicationReq)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_AMFMTestMode)
      //COURIER_MSG_DELEGATE_TO_OBJ(_RearViewCamera)
      COURIER_MSG_DELEGATE_TO_OBJ(_SxmTestMonitor)
      COURIER_MSG_DELEGATE_TO_OBJ(_HealthCareTestMode)
      //COURIER_MSG_DELEGATE_TO_OBJ(_WeatherBandMain)
      COURIER_MSG_DELEGATE_TO_OBJ(_ncdemo)
      COURIER_MSG_DELEGATE_TO_OBJ(_AudioTestMode)
      COURIER_MSG_DELEGATE_TO_OBJ(_SystemSettingTestMode)
      //COURIER_MSG_DELEGATE_TO_OBJ()
      COURIER_MSG_DELEGATE_TO_OBJ(_phoneTestModeProxy)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_MAP_DELEGATE_END()

      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);

   private:
      ApplicationSwitchClientComponent* _applicationSwitchClient;//applicationSwitch
      AMFMTestMode* _AMFMTestMode;
      RearViewCamera* _RearViewCamera;
      SystemSettingTestMode* _SystemSettingTestMode;
      HealthCareTestMode* _HealthCareTestMode;
      /** Instance of SxmAudioHall */
      SxmTestMonitor* _SxmTestMonitor;
      AudioTestMode* _AudioTestMode;
      // WeatherBandMain* _WeatherBandMain;
      NACVdemo* _ncdemo;
      PhoneTestMode* _phoneTestModeProxy;
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
