/* ***************************************************************************************
* FILE:          TestmodeHall.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TestmodeHall.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "hall_std_if.h"
#include "TestmodeHall.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TESTMODE_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX                 App::Core::TestmodeHall::
#include "trcGenProj/Header/TestmodeHall.cpp.trc.h"
#endif

using namespace ::App::Core;
using namespace ::CourierTunnelService::CourierMessageReceiver;

NACVdemo* test = NULL;
SystemSettingTestMode* systest = NULL;

namespace App {
namespace Core {

DEFINE_CLASS_LOGGER_AND_LEVEL("App/Core", TestmodeHall, Info);

TestmodeHall::TestmodeHall()
   : HallComponentBase("", "App.Core.AppHmi_Testmode", "/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Testmode"),
     _AMFMTestMode(NULL),
     _SxmTestMonitor(NULL),
     _AudioTestMode(NULL),
     _applicationSwitchClient(NULL),
     _SystemSettingTestMode(NULL),
     _HealthCareTestMode(NULL),
     //  _WeatherBandMain(NULL),
     _ncdemo(NULL),
     _RearViewCamera(NULL),
     _phoneTestModeProxy(NULL)
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("TestmodeHall : Constructor"));
   _AMFMTestMode = AMFMTestMode::poGetInstance();
   _RearViewCamera = RearViewCamera::poGetInstance();
   _SxmTestMonitor = SxmTestMonitor::poGetInstance();
   _AudioTestMode = AudioTestMode::poGetInstance();
   _SystemSettingTestMode = SystemSettingTestMode::poGetInstance();
   _HealthCareTestMode = HealthCareTestMode::poGetInstance();
   //_WeatherBandMain = WeatherBandMain::poGetInstance();
   _ncdemo = NACVdemo::getInstance();
   _applicationSwitchClient = ApplicationSwitchClientComponent::poGetInstance();
   _phoneTestModeProxy = PhoneTestMode::poGetInstance();
   test = _ncdemo;
   systest = _SystemSettingTestMode;

   if (_applicationSwitchClient != NULL)
   {
      _applicationSwitchClient->setApplicationID(APPID_APPHMI_TESTMODE);
   }
}


TestmodeHall::~TestmodeHall()
{
   ETG_TRACE_USR4(("TestmodeHall() : Class Destructor"));
   if (_AMFMTestMode != NULL)
   {
      delete	_AMFMTestMode;
   }
   if (_SxmTestMonitor != NULL)
   {
      delete _SxmTestMonitor;
   }
   if (_AudioTestMode != NULL)
   {
      delete _AudioTestMode;
   }
   if (_SystemSettingTestMode != NULL)
   {
      delete _SystemSettingTestMode;
   }
   if (_HealthCareTestMode != NULL)
   {
      delete _HealthCareTestMode;
   }
   if (_applicationSwitchClient != NULL)
   {
      delete _applicationSwitchClient;
   }
   if (_RearViewCamera != NULL)
   {
      delete	_RearViewCamera;
   }
   // if (_WeatherBandMain != NULL)
   // {
   //    delete	_WeatherBandMain;
   // }
   if (_ncdemo != NULL)
   {
      delete	_ncdemo;
   }
   if (_phoneTestModeProxy != NULL)
   {
      delete	_phoneTestModeProxy;
   }
}


void TestmodeHall::onExpired(asf::core::Timer& /*timer*/, boost::shared_ptr<asf::core::TimerPayload> /*data*/)
{
   ETG_TRACE_USR4(("TestmodeHall::onExpired()"));
}


/*void TestmodeHall::onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error)
{
}


void TestmodeHall::onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal)
{
}


*/
/**
* Description     : This method will be called on system startup for language translation
*
* @return         : uint8
*/
uint8 TestmodeHall::readLanguageOnStartUp()
{
   return 0;
}


bool TestmodeHall::onCourierMessage(const SwitchApplicationReq& oMsg)
{
   ETG_TRACE_USR3(("TestmodeHall->onCourierMessage:SwitchApplicationReq()"));

   if (_applicationSwitchClient != NULL)
   {
      //_applicationSwitchClient->requestSwitchApplication(APPID_APPHMI_MASTER);
      SystemSettingTestMode::poGetInstance()->reqContextSwitchSrcSelectionHome();
   }
   else
   {
      ETG_TRACE_USR3(("TestmodeHall->Null pointer"));
   }
   return true;
}


bool TestmodeHall::onCourierMessage(const ButtonReactionMsg& oMsg)
{
   ETG_TRACE_USR4(("TestmodeHall::ButtonReactionMsg()"));

   const Courier::ViewId TEST_MODE_MENU = Courier::ViewId("Testmode#Scenes#R_TestmodeSourceSelection");
   const Courier::Identifier IdNavigationBtn = Courier::Identifier("Layer_TouchArea_Navigation/ButtonWidget");
   const Courier::Identifier senderInfo = oMsg.GetSender();
   const Courier::ViewId sceneName = oMsg.GetView();
   const enReaction  btnReaction = oMsg.GetEnReaction();
   bool isMsgConsumed = false;

   if (enRelease == btnReaction)
   {
      if ((sceneName == TEST_MODE_MENU) && (senderInfo == IdNavigationBtn))
      {
         _applicationSwitchClient->requestContextSwitchApplication(2, APPID_APPHMI_TESTMODE, enActivityIDs__eActivityID_DIAGNOSIS, APPID_APPHMI_NAVIGATION, enActivityIDs__eActivityID_NAVI_TESTMODE_VIEW);
         isMsgConsumed = true;
      }
   }
   //SXM
   ListProviderEventInfo info;

   if ((ListProviderEventInfo::GetItemIdentifierInfo(oMsg.GetSender(), info) == true))
   {
      unsigned int listId = info.getListId();     // the list id for generic access
      uint32 hdlRow = info.getHdlRow();     // normaly the itr
      unsigned int hdlCol = info.getHdlCol();     // if more than 1 active element in one list row, e.g. Button in a button line

      ETG_TRACE_USR4(("AMFMStationList::onCourierMessage::ButtonReactionMsg::%d", oMsg.GetEnReaction()));

      if (oMsg.GetEnReaction() == enRelease)
      {
         switch (info.getListId())
         {
            case LISTID_SXM_CHN_LIST:
            {
               ETG_TRACE_USR4(("AMFMStationList::onCourierMessage::ButtonReactionMsg LISTID_FM %d", hdlRow));
               SxmTestMonitor::poGetInstance() -> SxmListSelectedIndex(hdlRow);
               isMsgConsumed = true;
            }
            break;
            default:
               break;
         }
         if (isMsgConsumed)
         {
            POST_MSG((COURIER_MESSAGE_NEW(ButtonListItemUpdMsg)(listId, hdlRow, hdlCol, enRelease)));
         }
      }
   }
   return isMsgConsumed;
}


ETG_I_CMD_DEFINE((TraceCmd_onSwitchDisplayUpdateImageView, "TraceCmd_onSwitchDisplayUpdateImageView %d", int))
void TestmodeHall::TraceCmd_onSwitchDisplayUpdateImageView(int u8TestNumber)
{
   ETG_TRACE_USR4(("TraceCmd_onSwitchDisplayUpdateImageView: %d", u8TestNumber));
   //SceneSelectoption = 0;
   systest->totest(u8TestNumber);
}


} // namespace Core
} // namespace App
