/**
 * @file        :  TestmodeGui.cpp
 * @addtogroup  :  AppHmi_Testmode
 * @brief       :  Class which contains all the necessary business logic required to handle gui instance and gadgets
 * @copyright   :  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "gui_std_if.h"
#include "TestmodeGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"


//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TESTMODE_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX                 App::Core::TestmodeGui::
#include "trcGenProj/Header/TestmodeGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////

//                                   main surface,                                      video surface,                    popup surfaces
//DEFAULT_APPSETTINGS(static_cast<int>(SURFACEID_MAIN_SURFACE_TUNER), static_cast<int>(SURFACEID_NONE), static_cast<int>(SURFACEID_TOP_POPUP_SURFACE_TUNER), static_cast<int>(SURFACEID_CENTER_POPUP_SURFACE_TUNER))
//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_TESTMODE, SURFACEID_NONE, SURFACEID_TOP_POPUP_SURFACE_TESTMODE, SURFACEID_CENTER_POPUP_SURFACE_TESTMODE)
//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_TESTMODE, SURFACEID_NONE, SURFACEID_TOP_POPUP_SURFACE_TESTMODE, SURFACEID_CENTER_POPUP_SURFACE_TESTMODE)
//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_TESTMODE,SURFACEID_NONE, SURFACEID_TOP_POPUP_SURFACE_TESTMODE, SURFACEID_CENTER_POPUP_SURFACE_TESTMODE)
APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_TESTMODE),
//
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_TESTMODE),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_TESTMODE)

                            APPSETTINGS_END()
                            using namespace ::hmi;

namespace App {
namespace Core {

TestmodeGui::TestmodeGui() : GuiComponentBase(hmi::apps::reference::appHmi_Testmode, appSettings)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_TESTMODE_APPCTRL_PROXY);
   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_TESTMODE, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_TESTMODE, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_TESTMODE, DisplayID_D1);
}


TestmodeGui::~TestmodeGui()
{
   ETG_I_UNREGISTER_FILE();
}


unsigned int TestmodeGui::getDefaultTraceClass()
{
   return TR_CLASS_APPHMI_TESTMODE_MAIN;
}


void TestmodeGui::setupCgiInstance()
{
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


void TestmodeGui::preRun()
{
//   DP_vCreateDatapool();
   PersistentValuesRead();
}


void TestmodeGui::postRun()
{
   PersistentValuesWrite();
}


void TestmodeGui::PersistentValuesRead()
{
//   dp_tclhmiAppSxmPersMemVarsSxm dp;
//   _mvar = dp.tGetData();
}


void TestmodeGui::PersistentValuesWrite()
{
//   dp_tclhmiAppSxmPersMemVarsSxm dp;
//   dp.s32SetData(_mvar);
}


/**
 *sink for not processed ttfis input messages
 */
void TestmodeGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_FATAL(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
