/**************************************************************************************
* @file         : SystemSettingTestMode.cpp
* @author       : RBEI/ECG5-INF4CV_Team
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*21.09.17 Rev. 0.1 Prashant BG (RBEI/ECH2)
* 		  			Initial Revision.
**************************************************************************************/
#include <vector>
#include "hall_std_if.h"
#include "SystemSettingTestMode.h"
#include "Common/DataModel/ListRegistry.h"
#include "Core/LanguageDefines.h"
#include "CanderaWidget/String/String.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TESTMODE_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX                 App::Core::SystemSettingTestMode::
#include "trcGenProj/Header/SystemSettingTestMode.cpp.trc.h"
#endif

/* using namespace ::rvc_cca_fi;
using namespace ::rvc_cca_fi_types; */
using namespace ::App::Core;
using namespace ::asf::core;
#define PORTNAME "applicationSwitchPort"

namespace App {
namespace Core {

SystemSettingTestMode* SystemSettingTestMode::_SystemSettingTestMode = NULL;

SystemSettingTestMode::SystemSettingTestMode()
   : _testModeValue(0)

{
   testmode = false;
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("SystemSettingTestMode Constructor is called"));
   _applicationSwitchClientComponent = ApplicationSwitchClientComponent :: poGetInstance();
   m_poApplicationSwitchProxy = ApplicationSwitchProxy::createProxy(PORTNAME, *this);
   readTestmode();
}


SystemSettingTestMode::~SystemSettingTestMode()
{
   ETG_TRACE_USR4(("SystemSettingTestMode destructor is called"));
}


void SystemSettingTestMode::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("SystemSettingTestMode registerPropertiesr is called"));
}


void SystemSettingTestMode::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("SystemSettingTestMode deregisterPropertiesr is called"));
}


void SystemSettingTestMode::reqContextSwitchSrcSelectionHome()
{
   ETG_TRACE_USR4(("SystemSettingTestMode reqContextSwitchSrcSelectionHome is called"));
   _applicationSwitchClientComponent->requestContextSwitchApplication(2, APPID_APPHMI_TESTMODE, enActivityIDs__eActivityID_TESTMODE_SOURCESELECTION_SCREEN, APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_HOME);
}


void SystemSettingTestMode::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("SystemSettingTestMode Service onAvailable"));
   if (m_poApplicationSwitchProxy && m_poApplicationSwitchProxy == proxy)
   {
      m_poApplicationSwitchProxy->sendActiveRegionIdRegister(*this);
      m_poApplicationSwitchProxy->sendSig_ActivateContextRegister(*this);

      ETG_TRACE_USR4(("Registered for sendSig_ActivateContextRegister"));
   }
   //m_poRvcFiProxy->sendReverseSignalStatusUpReg(*this);
}


void SystemSettingTestMode::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("SystemSettingTestMode Service onUnavailable"));
   m_poApplicationSwitchProxy->sendActiveRegionIdDeregisterAll();
   //m_poApplicationSwitchProxy->sendSig_ActivateContextDeregisterAll(*this);

   //m_poRvcFiProxy->sendReverseSignalStatusRelUpRegAll();
}


uint8 SystemSettingTestMode::getKdsVariantSelection()
{
   uint8 u8VariantSelection = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("AIVIVariantCoding", "VariantSelection", (uint8*) &u8VariantSelection, 1))
   {
      ETG_TRACE_COMP(("SystemSettingTestMode::getKdsVariantSelection(%d)", u8VariantSelection));
   }
   else
   {
      ETG_TRACE_COMP(("Error!!! SystemSettingTestMode::getKdsVariantSelection(%d)", u8VariantSelection));
   }
   return u8VariantSelection;
}


bool SystemSettingTestMode::onCourierMessage(const GuiStartupFinishedUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("TunerDataBindingHandler::GuiStartupFinishedUpdMsg()"));
   testmode_Variantcheck();
   return false;
}


void SystemSettingTestMode::testmode_Variantcheck()
{
#ifdef VARIANT_S_FTR_ENABLE_NAVIGATION
   ETG_TRACE_USR4(("TestmodeHall::testmode_cmc()"));
   enVariantType variantType = (enVariantType)getKdsVariantSelection();
   (*oSmart_Info).mNaviIconVisibility = (VARIANT_TYPE_NONNAVI != variantType) ? 1 : 0;
   (*oSmart_Info).mCameraIconVisibility = 1;
   oSmart_Info.MarkAllItemsModified();
   oSmart_Info.SendUpdate();
#else  //for smart navi and camera icons should be invisible
   ETG_TRACE_USR4(("TestmodeHall::testmode_smart()"));
   (*oSmart_Info).mNaviIconVisibility = 0;
   (*oSmart_Info).mCameraIconVisibility = 0;
   oSmart_Info.MarkAllItemsModified();
   oSmart_Info.SendUpdate();
#endif
}


void SystemSettingTestMode::onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
      const ::boost::shared_ptr< ActiveRegionIdError >& error)
{
}


void SystemSettingTestMode::onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
      const ::boost::shared_ptr< ActiveRegionIdUpdate >& update)
{
   //m_u8activeRegion = update->getActiveRegionId();
   ETG_TRACE_USR4(("SystemSettingTestMode::m_u8activeRegion: %d", update->getActiveRegionId()));
}


void SystemSettingTestMode::DisplayUpdateImage(int DisplayValue)
{
   ETG_TRACE_USR4(("SystemSettingTestMode : DisplayUpdateImage %d %d", DisplayValue, testmode));
   (*mSystemSettingTestMode).mSettingScreenTest = DisplayValue;
   mSystemSettingTestMode.MarkAllItemsModified();
   mSystemSettingTestMode.SendUpdate(true);

   //if (::SceneSelectOption == 1)
   if (testmode == false)
   {
      ETG_TRACE_USR4(("SystemSettingTestMode :Entered SceneSelectOption==1"));
      ::SceneSelectOption = 2;
      _applicationSwitchClientComponent->requestContextSwitchApplication(2, 0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0, APPID_APPHMI_TESTMODE, enActivityIDs__eActivityID_DIAGNOSIS);
      testmode = true;
   }
   ETG_TRACE_USR4(("SystemSettingTestMode:DisplayUpdateImage -->DisplayValue:%d", DisplayValue));
}


void SystemSettingTestMode::ActivateTestScreen()
{
   ETG_TRACE_USR4(("SystemSettingTestMode :Entered SceneSelectOption==1"));
   ::SceneSelectOption = 2;
   _applicationSwitchClientComponent->requestContextSwitchApplication(2, 0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0, APPID_APPHMI_TESTMODE, enActivityIDs__eActivityID_DIAGNOSIS);
   testmode = true;
}


void SystemSettingTestMode::ExitTestScreen()
{
   ::SceneSelectOption = 1;
   ETG_TRACE_USR4(("SystemSettingTestMode:DisplayUpdateImage -->ExitTestScreen"));
   _applicationSwitchClientComponent->requestContextSwitchApplication(2, APPID_APPHMI_TESTMODE, enActivityIDs__eActivityID_DIAGNOSIS, APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)80);
   testmode = false;
}


void SystemSettingTestMode::onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error)
{
   ETG_TRACE_USR4(("SystemSettingTestMode::onSig_ActivateContextError"));
}


void SystemSettingTestMode::onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal)
{
   ETG_TRACE_USR4(("SystemSettingTestMode::onSig_ActivateContextSignal %d", signal->getTargetactivityId()));
   uint16 activityID = signal->getTargetactivityId();
   switch (activityID)
   {
      case enActivityIDs__eActivityID_TESTMODE_SOURCESELECTION_SCREEN://settings screen
      {
         if (_testModeValue == TESTMODE_ENABLE)
         {
            ETG_TRACE_USR4(("SystemSettingTestMode::Open_Settings_Screen "));
            POST_MSG((COURIER_MESSAGE_NEW(Open_Settings_Screen)()));
         }
      }
      break;
      default:
         break;
   }
   //DisplaySystemSettingScene();
}


void SystemSettingTestMode::DisplaySystemSettingScene()
{
   ETG_TRACE_USR4(("SystemSettingTestMode::DisplaySystemSettingScene"));
   POST_MSG((COURIER_MESSAGE_NEW(Popup_PFO_TriggerSystemSetting)()));
   //POST_MSG((COURIER_MESSAGE_NEW(Popup_PFO_TriggerSystemSetting)()));
}


void SystemSettingTestMode::totest(int i)
{
   ETG_TRACE_USR4(("SystemSettingTestMode::totest %d", i));
   if (i == 1)
   {
      ETG_TRACE_USR4(("SystemSettingTestMode::totest 1"));
      ExitTestScreen();
      //SceneSelectOption = 1;
      //::SceneSelectOption = 1;
      //_applicationSwitchClientComponent->requestContextSwitchApplication(2,APPID_APPHMI_TESTMODE,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)eActivityID_DIAGNOSIS,APPID_APPHMI_MASTER,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)80);
   }
   if (i == 2)
   {
      ETG_TRACE_USR4(("SystemSettingTestMode::totest 2"));
      //SceneSelectOption = 0;
      //SceneSelectoption = 1;
      //::SceneSelectOption = 2;
      //_applicationSwitchClientComponent->requestContextSwitchApplication(2,0,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0 ,APPID_APPHMI_TESTMODE,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)eActivityID_DIAGNOSIS);
   }
}


void SystemSettingTestMode::readTestmode()
{
   dp_tclKdsBlockingTestMode _TestmodeBlockInformation;
   _TestmodeBlockInformation.u8GetBlockingTestModeApplicationSwitch(_testModeValue);
}


/*void SystemSettingTestMode::set(int i)
{
	//SceneSelectoption = i;
}*/

/*ETG_I_CMD_DEFINE((TraceCmd_onSwitchDisplayUpdateImageView, "TraceCmd_onSwitchDisplayUpdateImageView %d", int))
		void SystemSettingTestMode::TraceCmd_onSwitchDisplayUpdateImageView(int u8TestNumber)
		{
			ETG_TRACE_USR4(("TraceCmd_onSwitchDisplayUpdateImageView: %d", u8TestNumber));
			if (_SystemSettingTestMode != NULL)
			{
				_SystemSettingTestMode->DisplayUpdateImage(u8TestNumber);
				//DisplayUpdateImage(u8TestNumber);
			}
			else
			{
				ETG_TRACE_USR4(("TraceCmd_onSwitchDisplayUpdateImageView is Null Pointer "));
			}
		}*/


/*ETG_I_CMD_DEFINE((TraceCmd_onTriggerDisplayUpdateImageView, "TraceCmd_onTriggerDisplayUpdateImageView "))
		void SystemSettingTestMode::TraceCmd_onTriggerDisplayUpdateImageView()
		{
			ETG_TRACE_USR4(("TraceCmd_onTriggerDisplayUpdateImageView is Triggered "));
			if (_SystemSettingTestMode != NULL)
			{
				_SystemSettingTestMode->DisplaySystemSettingScene();
				//DisplayUpdateImage(u8TestNumber);
			}
			else
			{
				ETG_TRACE_USR4(("TraceCmd_onTriggerDisplayUpdateImageView is Null Pointer "));
			}
		}		*/

bool SystemSettingTestMode::onCourierMessage(const ContextToMaster& /*oMsg*/)
{
   uint16 activityID = 0;
   activityID = enActivityIDs__eActivityID_TESTMODE_WITHOUTNOTCH_SCREEN;
   ETG_TRACE_USR4(("SystemSettingTestMode::ContextToMaster==%d", activityID));
   _applicationSwitchClientComponent->requestSendContext(2, APPID_APPHMI_TESTMODE, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)activityID);
   return true;
}


}//namespace
}//App
