/**************************************************************************************
 * @file         : SxmAudioTypes.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Contains user defined types.
 * @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMAUDIOTYPES_H_
#define _SXMAUDIOTYPES_H_

#define LISTID_SXM 360
#define LISTID_SXM_CHN_LIST 380

struct PresetListEntryType
{
   uint16 ServiceID;
   uint16 ChannelID;
   bool ChannelActive;
   uint8 ChnGraphicAvail;
   bool IsSmartFavorite;
   PresetListEntryType(const uint16 lServiceID, const uint16 lChannelID, const bool lChannelActive, const uint8 lChnGraphicAvail, const bool lIsSmartFavorite)
      : ServiceID(lServiceID), ChannelID(lChannelID), ChannelActive(lChannelActive), ChnGraphicAvail(lChnGraphicAvail),
        IsSmartFavorite(lIsSmartFavorite)
   {
   }
   PresetListEntryType() : ServiceID(0), ChannelID(0), ChannelActive(false), ChnGraphicAvail(0), IsSmartFavorite(false)
   {}
};


struct PresetListResultType
{
   uint16 ServiceID;
   uint16 ChannelID;
   ::std::vector< uint8 > u8ImageData;
   uint8 PresetNo;
   PresetListResultType(const uint16 lServiceID, const uint16 lChannelID, const ::std::vector< uint8 > lu8ImageData, const uint8 lPresetNo)
      : ServiceID(lServiceID), ChannelID(lChannelID), u8ImageData(lu8ImageData), PresetNo(lPresetNo)
   {
   }
   PresetListResultType() : ServiceID(0), ChannelID(0), u8ImageData(0), PresetNo(0)
   {}
   ~PresetListResultType()
   {
      u8ImageData.clear();
   }
};


struct ChannelGraphicsType
{
   uint16 ServiceID;
   ::std::vector< uint8 > u8ImageData;
   uint32 u32Size;
   ChannelGraphicsType(uint16 u16ServiceID, const ::std::vector< uint8 >& lu8ImageData, const uint32 lu32Size)
   {
      ServiceID = u16ServiceID;
      u8ImageData.clear();
      u8ImageData = lu8ImageData;
      u32Size = lu32Size;
   }
   ChannelGraphicsType()
   {
      ServiceID = 0;
      u8ImageData.clear();
      u32Size = 0;
   }
   ~ChannelGraphicsType()
   {
      u8ImageData.clear();
   }
};


struct MonitorList
{
   std::string label;
   std::string value;
};


struct DTM
{
   std::string label;
   uint value;
};


struct SxmMonitorListType
{
   std::string label;
   std::string value;
   SxmMonitorListType(std::string llabel = "", std::string lvalue = "") : label(llabel), value(lvalue) {}
};


struct StructPrestList
{
   uint8 idx;
   std::string pName;
   StructPrestList(uint8 index = 0U, std::string presetName = ""):
      idx(index),
      pName(presetName)
   {	}
};


enum SXMAudio_List
{
   SXM_RADIO_ID = 0,
   SXM_ANTENNA_STATUS,
   SXM_SIGNAL_QUALITY,
   SXM_UPC_LID0,
   SXM_UPC_LID1,
   SXM_AUDIO,
   SXM_TRAFFIC,
   SXM_TRAVEL_LINK,
   SXM_MODULE_SUBSCRIPTION,
   SXM_MODULE_SUSPEND_DATE,
   SXM_CHANNEL_ART,
   SXM_MOVIES,
   SXM_AGW,
   SXM_TAB_WEATHER,
   SXM_FUEL,
   SXM_STOCKS,
   SXM_SPORTS,
   SXM_ALERTS,
   SXM_SAFEVIEW,
   SXM_PARKING
};


enum SXMAntenna_Status
{
   FC_SXM_DIAG_ANT_UNSUPPORTED = 0,
   FC_SXM_DIAG_ANT_DETECTED,
   FC_SXM_DIAG_ANT_NOTDETECTED,
   FC_SXM_DIAG_ANT_SHORTED,
   FC_SXM_DIAG_ANT_UNKNOWN
};


enum SXMDiag_Antenna_Status
{
   SXM__AUDIO_DIAG_WAIT = 0,
   SXM__AUDIO_DIAG_OK,
   SXM__AUDIO_DIAG_DISCONNECTED,
   SXM__AUDIO_DIAG_SHORTED,
   SXM__AUDIO_DIAG_UNKNOWN
};


enum SXMAudio_Diag_Signal
{
   SXM__AUDIO_DIAG_NOSIGNAL = 0,
   SXM__AUDIO_DIAG_WEAK,
   SXM__AUDIO_DIAG_GOOD,
   SXM__AUDIO_DIAG_EXCELLENT,
   SXM__AUDIO_DIAG_WAIT_ //to check in original
};


enum SXMSignal_Quality
{
   FC_SXM_DIAG_SQ_NO_SIGNAL = 0,
   FC_SXM_DIAG_SQ_WEAK_SIGNAL,
   FC_SXM_DIAG_SQ_GOOD_SIGNAL,
   FC_SXM_DIAG_SQ_EXCELLENT_SIGNAL,
   FC_SXM_DIAG_SQ_INVALID_SIGNAL
};


enum SXMDataser_Status
{
   SXM_UNKNOWN = 0,
   SXM_SUBSCRIBED = 2,
   SXM_NOT_SUBSCRIBED,
   SXM_NOT_AVAILABLE,
   SXM_NO_ANTENNA,
   SXM_NO_SIGNAL
};


enum SXMTravellink_Status
{
   TRAVELLINK_UNKNOWN = 0,
   TRAVELLINK_SUBSCRIBED,
   TRAVELLINK_NOT_SUBSCRIBED,
   TRAVELLINK_NOT_AVAILABLE,
   TRAVELLINK_LOADING
};


enum SXMAudio_status
{
   SXM_AUDIO_NOTSUBSCRIBED = 0,
   SXM_AUDIO_SUBSCRIBED,
   SXM_AUDIO_SUSPEND_ALERT,
   SXM_AUDIO_SUSPENDED
};


enum SXMAudio_Diag_status
{
   SXM__AUDIO_DIAG_NOTSUBSCRIBED = 0,
   SXM__AUDIO_DIAG_SUBSCRIBED,
   SXM__AUDIO_DIAG_SUSPENDALERT,
   SXM__AUDIO_DIAG_SUSPENDED,
   SXM__AUDIO_DIAG_INVALID
};


enum SxmTestMode_Signal
{
   SIGNAL = 0,
   TUNER_STATUS,
   LOCKENSA,
   LOCKENSB,
   BER,
   CNA,
   CNB,
   RS,
   TUNER_FREQ,
   RSSI,
   OVERLAY_STATUS,
   OBERA,
   OBERB,
   ORS,
   CAPABILITY,
   MOD_TYPE,
   MOD_HW,
   MOD_SW,
   SXI,
   BB,
   HDEC,
   RF,
   HMI,
   CGS_DB,
   FUEL_DB,
   MOVIE_DB,
   TAB_WEATHER_DB,
   STOCK_DB,
   SMS
};


enum SxmDTMTestMode_signal
{
   SUB_STATUS = 0,
   REASON_CODE,
   SUSPEND_DATE
};


enum SxmAudioAlert
{
   ENABLE = 0,
   DISABLE
};


enum SxmAudioCGListType
{
   SxmAudioChannelListType = 0,
   SxmAudioAlertInfoType,
   SxmAudioSportsFlashEventType
};


#define ALERT_SETTINGS_MAX_ENTRY 4

enum SxmChannelID
{
   START_CHANNEL_ID = 1,
   END_CHANNEL_ID = 999
};


enum SxmListItems
{
   Item_0 = 0,
   Item_1,
   Item_2,
   Item_3,
   Item_4,
   Item_5,
   Item_6,
   Item_7,
   Item_8,
   Item_9,
   Item_10,
   Item_11,
   Item_12,
   Item_13,
   Item_14,
   Item_15,
   Item_16,
   Item_17
};


enum SxmStmData
{
   SXM_DIAG_RADIOID = 0,
   SXM_DIAG_ANTENNA_STATUS,
   SXM_DIAG_SIGNAL_QUALITY,
   SXM_DIAG_MODULE_SUBSTATUS,
   SXM_DIAG_MODULE_SUSPENDDATE,
   SXM_DIAG_AUDIO_SUBSTATUS,
   SXM_DIAG_CG_SUBSTATUS,
   SXM_DIAG_TRAFFIC_SUBSTATUS,
   SXM_DIAG_TRAVELLINK_SUBSTATUS,
   SXM_DIAG_MOVIES_SUBSTATUS,
   SXM_DIAG_AGW_SUBSTATUS,
   SXM_DIAG_WSALERTS_SUBSTATUS,
   SXM_DIAG_TABWEATHER_SUBSTATUS,
   SXM_DIAG_FUEL_SUBSTATUS,
   SXM_DIAG_PARKING_SUBSTATUS,
   SXM_DIAG_SPORTS_SUBSTATUS,
   SXM_DIAG_STOCKS_SUBSTATUS
};


// SXM_DIAG_CANADIANFUEL_SUBSTATUS,
//SXM_DIAG_EXTERNAL_SUBSTATUS
enum SxmMonitorData
{
   SXM_DIAG_SIGNAL_STRENGTH,
   SXM_DIAG_TUNER_STATUS,
   SXM_DIAG_LOCKA,
   SXM_DIAG_LOCKB,
   SXM_DIAG_BER,
   SXM_DIAG_CN_S1,
   SXM_DIAG_CN_S2,
   SXM_DIAG_RSERRS,
   SXM_DIAG_TUNER_FREQUENCY,
   SXM_DIAG_RSSI,
   SXM_DIAG_OVERLAY_STATUS,
   SXM_DIAG_OBER_S1,
   SXM_DIAG_OBER_S2,
   SXM_DIAG_OBER_T,
   SXM_DIAG_OTP0,
   SXM_DIAG_OTP1,
   SXM_DIAG_OTP2,
   SXM_DIAG_MODULE_TYPE,
   SXM_DIAG_MODULE_HW,
   SXM_DIAG_MODULE_SW,
   SXM_DIAG_SXI,
   SXM_DIAG_BB,
   SXM_DIAG_HDEC,
   SXM_DIAG_RF,
   SXM_DIAG_SPL,
   SXM_DIAG_CAPABILITY,
   SXM_DIAG_SUBSTATUS,
   SXM_DIAG_REASON_CODE,
   SXM_DIAG_SUSPEND_DATE,
   SXM_DIAG_SMS_VERSION,
   SXM_DIAG_HU_SW_VERSION,
   SXM_DIAG_HU_HW_VERSION,
   SXM_DIAG_CGS_DB,
   SXM_DIAG_TABW_DB,
   SXM_DIAG_WSA_DB,
   SXM_DIAG_FUELUS_DB,
   SXM_DIAG_FUELCANADA_DB,
   SXM_DIAG_MOVIES_DB,
   SXM_DIAG_PARKING_DB,
   SXM_DIAG_SPORTS_DB,
   SXM_DIAG_STOCK_DB,
   SXM_DIAG_PHONETICS_DB
};


enum SxmInfoData
{
   SXMINFO_SIGNAL_QUALITY,
   SXMINFO_AUDIO,
   SXMINFO_TRAFFIC,
   SXMINFO_TRAVEL_LINK,
   SXMINFO_RADIO_ID
};


enum DiagSxmReset
{
   SXM_TESTMODE_COMPLETE_DEFAULT_SETTING = 0,
   SXM_TESTMODE_RESET_CGS = 2,
   SXM_TESTMODE_RESET_MOVIE = 4,
   SXM_TESTMODE_RESET_TABWEATHER = 6,
   SXM_TESTMODE_RESET_FUEL_US = 7,
   SXM_TESTMODE_STOCKS = 8,
   SXM_TESTMODE_SPORTS = 9,
   SXM_TESTMODE_EXTERNAL_SUBSTATUS = 14,
   SXM_TESTMODE_WS_ALERTS = 11,
   SXM_TESTMODE_RESET_FUEL_CANADA = 10,
   SXM_TESTMODE_PARKING = 12,
   SXM_TESTMODE_PHONETICS = 13
};


#endif
