/**************************************************************************************
* @file         : <RearViewCamera.cpp>
* @author       : <ECG> <INF4CV> Sathiya Jayanth Raman
* @addtogroup   :
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef REARVIEWCAMERA_H_
#define REARVIEWCAMERA_H_


#include "rvc_cca_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_TestmodeMessages.h"
#include "AppHmi_TestmodeDatabinding.h"
#include "AppHmi_TestmodeStateMachine.h"
#include "Common/DataModel/ListRegistry.h"
#include "Widgets/2D/List/Data/ListDataProviderBuilder.h"
#include "AppBase/StartupSync/StartupSync.h"

namespace App {
namespace Core {

using namespace ::rvc_cca_fi;

class RearViewCamera : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ReverseSignalStatusCallbackIF

{
   public:
      static RearViewCamera* poGetInstance()
      {
         if (NULL == _RearViewClient)
         {
            _RearViewClient = new RearViewCamera();
         }

         return _RearViewClient;
      }

      virtual ~RearViewCamera();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onReverseSignalStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ReverseSignalStatusError >& error);
      void onReverseSignalStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ReverseSignalStatusStatus >& status);

      DataBindingItem<RVCTestModeDataBindingSource> m_RVCTestMode;
   private:

      RearViewCamera();
      static RearViewCamera* _RearViewClient;

      ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy > m_poRvcFiProxy;
};


}
}


#endif
