/**************************************************************************************
* @file         : <RearViewCamera.cpp>
* @author       : <ECG> <INF4CV> Sathiya Jayanth Raman
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <vector>
#include "hall_std_if.h"
#include "RearViewCamera.h"
#include "Common/DataModel/ListRegistry.h"
#include "Core/LanguageDefines.h"
#include "CanderaWidget/String/String.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TESTMODE_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX                 App::Core::RearViewCamera::
#include "trcGenProj/Header/RearViewCamera.cpp.trc.h"
#endif


using namespace ::rvc_cca_fi;
using namespace ::rvc_cca_fi_types;
using namespace ::App::Core;
using namespace ::asf::core;

namespace App {
namespace Core {

RearViewCamera* RearViewCamera::_RearViewClient = NULL;

RearViewCamera::RearViewCamera(): m_poRvcFiProxy(::rvc_cca_fi::Rvc_cca_fiProxy::createProxy("rvcFiPort", *this))
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("RearViewCamera Constructor is called"));
   if (m_poRvcFiProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, m_poRvcFiProxy->getPortName());
      ETG_TRACE_USR4(("RearViewCamera Constructor after creating proxy"));
   }
   else
   {
      ETG_TRACE_USR4(("RearViewCamera Constructor is failed"));
   }
}


RearViewCamera::~RearViewCamera()
{
   ETG_TRACE_USR4(("RearViewCamera destructor is called"));
}


void RearViewCamera::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
}


void RearViewCamera::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
}


void RearViewCamera::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("RearViewCamera Service onAvailable"));
   m_poRvcFiProxy->sendReverseSignalStatusUpReg(*this);
}


void RearViewCamera::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("RearViewCamera Service onUnavailable"));
   m_poRvcFiProxy->sendReverseSignalStatusRelUpRegAll();
}


void RearViewCamera::onReverseSignalStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ReverseSignalStatusError >& /*error*/)
{
   ETG_TRACE_USR4(("RearViewCamera:: onReverseSignalStatusError"));
}


void RearViewCamera::onReverseSignalStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ReverseSignalStatusStatus >& status)
{
   ETG_TRACE_USR4(("RearViewCamera:: onReverseSignalStatusStatus Reverse %u", status->getE8StatusReverseSignal()));
}


}//namespace
}//App
