/**************************************************************************************
* @file         : PhoneTestMode.cpp
* @author       : RBEI/EHM1-INF4CV_Team
* @addtogroup   : AppHmi_testmode
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*5.5.20 Rev. 0.1 wut4kor (RBEI/EHM1)
* 		  			Initial Revision.
**************************************************************************************/

#ifndef PhoneTestMode_H
#define PhoneTestMode_H

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_TestmodeDatabinding.h"
#include "AppHmi_TestmodeStateMachine.h"
#include "AppHmi_TestmodeMessages.h"
#include "AppHmi_TestmodeStateMachineData.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "mplay_MediaPlayer_FI.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "MOST_BTSet_FI.h"
#include "MOST_BTSet_FIProxy.h"

#include "MOST_Tel_FI.h"
#include "MOST_Tel_FIProxy.h"

using namespace ::MOST_BTSet_FI;
using namespace ::MOST_Tel_FI;

#define BTPHN_C_DEFAULT_VALUE_ZERO 0

typedef enum
{
   BTTM_EN_BTADDRESS_SYSTEM = 0UL,
   BTTM_EN_PROFILES_SYSTEM = 1UL,
   BTTM_EN_PBAP_SYSTEM = 2UL,
   BTTM_EN_MAP_SYSTEM = 3UL,
   BTTM_EN_A2DP_SYSTEM = 4UL,
   BTTM_EN_AVRC_SYSTEM = 5UL,
   BTTM_EN_HFP_SYSTEM = 6UL,
   BTTM_EN_HSP_SYSTEM = 7UL,
   BTTM_EN_BTADDRESS_DEVICE1 = 8UL,
   BTTM_EN_PROFILES_DEVICE1 = 9UL,
   BTTM_EN_PBAP_DEVICE1 = 10UL,
   BTTM_EN_MAP_DEVICE1 = 11UL,
   BTTM_EN_A2DP_DEVICE1 = 12UL,
   BTTM_EN_AVRC_DEVICE1 = 13UL,
   BTTM_EN_HFP_DEVICE1 = 14UL,
   BTTM_EN_HSP_DEVICE1 = 15UL,
   BTTM_EN_LINKKEY_DEVICE1 = 16UL,
   BTTM_EN_BTADDRESS_DEVICE2 = 17UL,
   BTTM_EN_PROFILES_DEVICE2 = 18UL,
   BTTM_EN_PBAP_DEVICE2 = 19UL,
   BTTM_EN_MAP_DEVICE2 = 20UL,
   BTTM_EN_A2DP_DEVICE2 = 21UL,
   BTTM_EN_AVRC_DEVICE2 = 22UL,
   BTTM_EN_HFP_DEVICE2 = 23UL,
   BTTM_EN_HSP_DEVICE2 = 24UL,
   BTTM_EN_LINKKEY_DEVICE2 = 25UL,
   BTPHN_EN_STREAMING_PLAY_STATUS = 26UL,
   BTPHN_EN_MPHONE_CURR_STATUS = 27UL,
   BTPHN_EN_ECNR_ENGINE = 28UL,
} btTM_enumtestmodeBTvalue;


namespace App {

namespace Core {

class PhoneTestMode :  public ListImplementation,
   public  hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public MOST_Tel_FI::CellDeviceNameCallbackIF,
   public MOST_Tel_FI::MicrophoneMuteStateCallbackIF,
   public MOST_BTSet_FI::GetDeviceInfoExtendedCallbackIF,
   public MOST_BTSet_FI::VehicleSupportedBTProfilesCallbackIF,
   public MOST_BTSet_FI::VehicleBTAddressCallbackIF,
   public ::mplay_MediaPlayer_FI::PlaybackStateCallbackIF,
   public ::mplay_MediaPlayer_FI::NowPlayingCallbackIF
{
   private:
      PhoneTestMode();
      std::string strDeviceNameCurrent;
      bool bMicrophoneState; // Stores the microphone status
      int DeviceHandleCurrent;
      std::string BTdeviceAddress;
   public:
      virtual ~PhoneTestMode();
      static PhoneTestMode* poGetInstance()
      {
         if (NULL == _PhoneTestModeInst)
         {
            _PhoneTestModeInst = new PhoneTestMode();
         }

         return _PhoneTestModeInst;
      }
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // class CellDeviceNameCallbackIF implementation
      virtual void onCellDeviceNameError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellDeviceNameError >& error);
      virtual void onCellDeviceNameStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellDeviceNameStatus >& status);
      // Microphone mute status
      virtual void onMicrophoneMuteStateError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::MicrophoneMuteStateError >& error);
      virtual void onMicrophoneMuteStateStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::MicrophoneMuteStateStatus >& status);
      //Device Info :BT Address and profiles
      virtual void onGetDeviceInfoExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedError >& error);
      virtual void onGetDeviceInfoExtendedResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedResult >& result);
      //BT Address of the system
      virtual void onVehicleBTAddressError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleBTAddressError >& error);
      virtual void onVehicleBTAddressStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleBTAddressStatus >& status);
      //BT profiles of system
      virtual void onVehicleSupportedBTProfilesError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleSupportedBTProfilesError >& error);
      virtual void onVehicleSupportedBTProfilesStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleSupportedBTProfilesStatus >& status);

      //Media updates
      virtual void onPlaybackStateError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                        const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackStateError >& error);

      virtual void onPlaybackStateStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                         const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackStateStatus >& status);

      virtual void onNowPlayingError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                     const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingError >& error);
      virtual void onNowPlayingStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingStatus >& status);
      /* Structure that maintains BT TestMode information */
      typedef struct
      {
         std::string btTestmodeName;
         std::string btTestmodevalue;
      } bt_testmodeInfo;

      std::vector<std::string> testmodeBTlist;
      std::string testmodeBTlistItemValue[29];
      uint8 connctedDeviceList[3];
      int currentDevice;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_VIEW_COMP)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      void TestmodeBTlistBuild(int startIndex);
      /*creates BTtestmode list rows with valid data and updates it to GUI*/
      void updateBTTestModeList(std::vector<bt_testmodeInfo>& artestmodeBTlistItem, int TMStartIndex, int lastItemIndex_TMList, int TotalListSize_TM);
      void vsendGetDeviceInfoExtendedStart(int DeviceHandleCurrent);
      void CleardeviceData(int device);
      std::string setTestmodeBTitemvalue(bool status);
      std::string getTestmodeBTStreamStatus(int status);
      void updateBTStreamStatusListItem(bool connectionStatus);
      std::string getBTStreamDataListItemText();
      void updateBTList(bool val);
   private:
      ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _btSetProxy;
      ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > _most_tel_fi;
      ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > _mediaPlayerProxy;
      static PhoneTestMode* _PhoneTestModeInst;

      int m_TM_btStartIndex;
      int m_TM_btlastItemIndex_PBList;
      int m_playbackstate;
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      int m_CurrentDeviceType;
      DataBindingItem<ListId_FlexDataBindingSource>m_ListID;/*Binding source to update the List Id */
      DataBindingItem<ListDataSizeDataBindingSource>m_ListDataSize; /*	Binding source to update the List Size */
};


}//end of namespace Core
}//end of namespace App


#endif
