/**************************************************************************************
* @file         : PhoneTestMode.cpp
* @author       : RBEI/EHM1-INF4CV_Team
* @addtogroup   : AppHmi_testmode
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*5.5.20 Rev. 0.1 wut4kor (RBEI/EHM1)
* 		  			Initial Revision.
**************************************************************************************/

#include <hmibase/hall_std_if.h>
#include "PhoneTestMode.h"
#include "SxmTestMonitor.h"
#include "iostream"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TESTMODE_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX                 App::Core::PhoneTestMode::
#include "trcGenProj/Header/PhoneTestMode.cpp.trc.h"

#include "Common/DataModel/ListModel.h"
#include "Common/DataModel/ListRegistry.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#endif


#define DEFAULT_VALUE  -1
using namespace std;

using namespace ::MOST_BTSet_FI;
using namespace ::most_BTSet_fi_types;
using namespace ::MOST_Tel_FI;
using namespace ::most_Tel_fi_types;

namespace App {

namespace Core {

/**
* Default Constructor for PhoneTestMode
* @param[in] None
*/
PhoneTestMode* PhoneTestMode::_PhoneTestModeInst = NULL;
PhoneTestMode::PhoneTestMode() :
   _btSetProxy(::MOST_BTSet_FI::MOST_BTSet_FIProxy::createProxy("btSetFiPort", *this)),
   _most_tel_fi(MOST_Tel_FIProxy::createProxy("btTelFiPort", *this)),
   _mediaPlayerProxy(mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy::createProxy("mediaPlayerFiPort", *this)),
   bMicrophoneState(FALSE),
   DeviceHandleCurrent(0),
   m_TM_btStartIndex(0),
   m_TM_btlastItemIndex_PBList(0),
   currentDevice(0)
{
   m_playbackstate = DEFAULT_VALUE;
   m_CurrentDeviceType = DEFAULT_VALUE;

   if (_mediaPlayerProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _mediaPlayerProxy->getPortName());
   }
   if (_btSetProxy.get())
   {
      ListRegistry::s_getInstance().addListImplementation(LIST_ID_TestmodeBT, this);
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _btSetProxy->getPortName());
   }
   if (_most_tel_fi.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _most_tel_fi->getPortName());
   }
   else
   {
      ETG_TRACE_USR4(("Phonetestmode _btSetProxy.get is FALSE"));
   }
}


PhoneTestMode::~PhoneTestMode()
{
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_TestmodeBT);
   _mediaPlayerProxy.reset();
}


/**
 * @brief   : Incomming message for HMI data model a message component
 * @param   :
 */
bool PhoneTestMode::onCourierMessage(const Courier::StartupMsg& /*oMsg*/)
{
   ETG_TRACE_USR4(("StartupMsg called..."));
   (*m_ListDataSize).mTestmodeBTListSize = BTPHN_C_DEFAULT_VALUE_ZERO;
   (*m_ListID).mTestmodeListId = LIST_ID_TestmodeBT;
   m_ListID.MarkAllItemsModified();
   m_ListID.SendUpdate(true);
   m_ListDataSize.MarkItemModified(ItemKey::ListDataSize::TestmodeBTListSizeItem);
   m_ListDataSize.SendUpdate(true);
   return true;
}


void PhoneTestMode::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


void PhoneTestMode::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


void PhoneTestMode::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core:: ServiceStateChange& stateChange)
{
   ETG_TRACE_USR2(("TestmodeBT onAvailable(_btSetProxy) entry"));
   if (proxy == _most_tel_fi && _most_tel_fi.get())
   {
      _most_tel_fi->sendCellDeviceNameUpReg(*this);
      _most_tel_fi->sendMicrophoneMuteStateUpReg(*this);
   }
   if ((proxy == _btSetProxy) && (_btSetProxy.get()))
   {
      ETG_TRACE_USR2(("TestmodeBT :_btSetProxy "));
      _btSetProxy->sendVehicleBTAddressUpReg(*this);
      _btSetProxy->sendVehicleSupportedBTProfilesUpReg(*this);
   }
   if ((proxy == _mediaPlayerProxy) && (_mediaPlayerProxy.get()))
   {
      _mediaPlayerProxy->sendNowPlayingUpReg(*this);
      _mediaPlayerProxy->sendPlaybackStateUpReg(*this);
   }
}


void PhoneTestMode::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core:: ServiceStateChange& stateChange)
{
   ETG_TRACE_USR2(("TestmodeBT onUnavailable"));

   if (proxy == _most_tel_fi && _most_tel_fi.get())
   {
      _most_tel_fi->sendCellDeviceNameRelUpRegAll();
      _most_tel_fi->sendMicrophoneMuteStateRelUpRegAll();
   }
   if ((proxy == _mediaPlayerProxy) && (_mediaPlayerProxy.get()))
   {
      ETG_TRACE_USR4(("PhoneTestMode onUnavailable......."));
      _mediaPlayerProxy->sendNowPlayingRelUpRegAll();
      _mediaPlayerProxy->sendPlaybackStateRelUpRegAll();
   }
   if ((proxy == _btSetProxy) && (_btSetProxy.get()))
   {
      _btSetProxy->sendVehicleBTAddressRelUpRegAll();
      _btSetProxy->sendVehicleSupportedBTProfilesRelUpRegAll();
   }
}


bool PhoneTestMode::onCourierMessage(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("PhoneTestMode : ListDateProviderReqMsg GetListId::%d", oMsg.GetListId()));

   switch (oMsg.GetListId())
   {
      case LIST_ID_TestmodeBT:
         ETG_TRACE_USR4(("PhoneTestMode : ListDateProviderReqMsg LIST_ID_TestmodeBT"));

         m_TM_btStartIndex = oMsg.GetStartIndex();
         ETG_TRACE_USR4(("PhoneTestMode : ListDateProviderReqMsg:startIndex = %d", m_TM_btStartIndex));
         /*request for List Data data*/
         TestmodeBTlistBuild(m_TM_btStartIndex);
         break;
   }
   return true;
}


void PhoneTestMode::CleardeviceData(int device)
{
   ETG_TRACE_USR2(("CleardeviceData entry"));
   if (device == 1)
   {
      ETG_TRACE_USR2(("CleardeviceData device 1"));
      testmodeBTlistItemValue[BTTM_EN_HFP_DEVICE1] = "";
      testmodeBTlistItemValue[BTTM_EN_MAP_DEVICE1] = "";
      testmodeBTlistItemValue[BTTM_EN_HSP_DEVICE1] = "";
      testmodeBTlistItemValue[BTTM_EN_BTADDRESS_DEVICE1] = "";
      testmodeBTlistItemValue[BTTM_EN_PBAP_DEVICE1] = "";
      testmodeBTlistItemValue[BTTM_EN_LINKKEY_DEVICE1] = "";
      testmodeBTlistItemValue[BTTM_EN_A2DP_DEVICE1] = "";
      testmodeBTlistItemValue[BTTM_EN_AVRC_DEVICE1] = "";
   }
   else if (device == 2)
   {
      ETG_TRACE_USR2(("CleardeviceData device 2"));
      testmodeBTlistItemValue[BTTM_EN_HFP_DEVICE2] = "";
      testmodeBTlistItemValue[BTTM_EN_MAP_DEVICE2] = "";
      testmodeBTlistItemValue[BTTM_EN_HSP_DEVICE2] = "";
      testmodeBTlistItemValue[BTTM_EN_BTADDRESS_DEVICE2] = "";
      testmodeBTlistItemValue[BTTM_EN_PBAP_DEVICE2] = "";
      testmodeBTlistItemValue[BTTM_EN_LINKKEY_DEVICE2] = "";
      testmodeBTlistItemValue[BTTM_EN_A2DP_DEVICE2] = "";
      testmodeBTlistItemValue[BTTM_EN_AVRC_DEVICE2] = "";
   }
   TestmodeBTlistBuild(m_TM_btStartIndex);
}


void PhoneTestMode::onCellDeviceNameError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellDeviceNameError >& error)
{
   //Add your code here
}


void PhoneTestMode::onCellDeviceNameStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::CellDeviceNameStatus >& status)
{
   //TODO: Varun changes for Device name
   int u8ListIterator;
   ETG_TRACE_USR2(("onCellDeviceNameStatus: Device Name :%s", status->getSDeviceName().c_str()));
   ETG_TRACE_USR2(("onCellDeviceNameStatus: Device Handle :%d", status->getU8DeviceHandle()));
   strDeviceNameCurrent = status->getSDeviceName().c_str();
   DeviceHandleCurrent = status->getU8DeviceHandle();

   //Delete device if device name empty
   if (strDeviceNameCurrent.empty())
   {
      ETG_TRACE_USR2(("onCellDeviceNameStatus empty : entry"));
      if (connctedDeviceList[0] == DeviceHandleCurrent)
      {
         ETG_TRACE_USR2(("onCellDeviceNameStatus, connctedDeviceList[0] == DeviceHandleCurrent : entry"));
         connctedDeviceList[0] = 0;
         CleardeviceData(1);
      }
      else if (connctedDeviceList[1] == DeviceHandleCurrent)
      {
         ETG_TRACE_USR2(("onCellDeviceNameStatus, connctedDeviceList[1] == DeviceHandleCurrent : entry"));
         connctedDeviceList[1] = 0;
         CleardeviceData(2);
      }
   }
   else // Add device
   {
      ETG_TRACE_USR2(("onCellDeviceNameStatus Add device : entry"));
      if (connctedDeviceList[0] == 0 && !strDeviceNameCurrent.empty())
      {
         ETG_TRACE_USR2(("onCellDeviceNameStatus, connctedDeviceList[0]== 0 && !strDeviceNameCurrent.empty() : entry"));
         connctedDeviceList[0] = DeviceHandleCurrent;//Fill all dev 1 param
         currentDevice = 1;
      }
      else if (connctedDeviceList[1] == 0 && !strDeviceNameCurrent.empty())
      {
         ETG_TRACE_USR2(("onCellDeviceNameStatus, connctedDeviceList[1]== 0 && !strDeviceNameCurrent.empty() : entry"));
         connctedDeviceList[1] = DeviceHandleCurrent;//Fill all dev 2 param
         currentDevice = 2;
      }
      vsendGetDeviceInfoExtendedStart(DeviceHandleCurrent);
   }
}


void PhoneTestMode::onMicrophoneMuteStateError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::MicrophoneMuteStateError >& error)
{
   ETG_TRACE_ERR(("PhoneTestMode::onMicrophoneMuteStateError "));
}


void PhoneTestMode::onMicrophoneMuteStateStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Tel_FI::MicrophoneMuteStateStatus >& status)
{
   ETG_TRACE_USR3(("PhoneTestMode::onMicrophoneMuteStateStatus status is %d", status->getBEnable()));
   // Storing the microphone mute status
   if (status->getBEnable())
   {
      ETG_TRACE_USR3(("PhoneTestMode::onMicrophoneMuteStateStatus : testmodeBTlistItemValue = ON"));
      testmodeBTlistItemValue[BTPHN_EN_MPHONE_CURR_STATUS] = "ON";
   }
   else
   {
      ETG_TRACE_USR3(("PhoneTestMode::onMicrophoneMuteStateStatus : testmodeBTlistItemValue = OFF"));
      testmodeBTlistItemValue[BTPHN_EN_MPHONE_CURR_STATUS] = "OFF";
   }
}


void PhoneTestMode:: onVehicleBTAddressError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleBTAddressError >& error)
{
}


void PhoneTestMode:: onVehicleBTAddressStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleBTAddressStatus >& status)
{
   ETG_TRACE_USR2(("onGetDeviceInfoExtendedResult:  systemAddr = %s", (status->getSVehicleBTAddress()).c_str()));
   testmodeBTlistItemValue[BTTM_EN_BTADDRESS_SYSTEM] = status->getSVehicleBTAddress();
}


void PhoneTestMode:: onVehicleSupportedBTProfilesError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleSupportedBTProfilesError >& error)
{
}


void PhoneTestMode:: onVehicleSupportedBTProfilesStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleSupportedBTProfilesStatus >& status)
{
   //ETG_TRACE_USR2(("onGetDeviceInfoExtendedResult:  systemAddr = %s", (status->getSVehicleBTAddress()).c_str()));
   testmodeBTlistItemValue[BTTM_EN_HFP_SYSTEM] = setTestmodeBTitemvalue(status->getOSupportedProfiles().getBHFPSupport());
   testmodeBTlistItemValue[BTTM_EN_PBAP_SYSTEM] = setTestmodeBTitemvalue(status->getOSupportedProfiles().getBPBAPSuport());
   testmodeBTlistItemValue[BTTM_EN_MAP_SYSTEM] = setTestmodeBTitemvalue(status->getOSupportedProfiles().getBMAPSupport());
   testmodeBTlistItemValue[BTTM_EN_A2DP_SYSTEM] = setTestmodeBTitemvalue(status->getOSupportedProfiles().getBA2DPSupport());
   testmodeBTlistItemValue[BTTM_EN_AVRC_SYSTEM] = setTestmodeBTitemvalue(status->getOSupportedProfiles().getBAVRCPSupport());
   testmodeBTlistItemValue[BTTM_EN_HSP_SYSTEM] = setTestmodeBTitemvalue(false);
}


void PhoneTestMode::vsendGetDeviceInfoExtendedStart(int DeviceHandleCurrent)
{
   ETG_TRACE_USR2(("onCourierMessage:  AddNewDeviceReqstart\n"));
   if (NULL != _btSetProxy)
   {
      _btSetProxy->sendGetDeviceInfoExtendedStart(*this, DeviceHandleCurrent);
   }
}


void PhoneTestMode::onGetDeviceInfoExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedError >& error)
{
}


void PhoneTestMode::onGetDeviceInfoExtendedResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedResult >& result)
{
   ETG_TRACE_USR2(("onGetDeviceInfoExtendedResult,  entry"));
   if (currentDevice == 1)
   {
      ETG_TRACE_USR2(("onGetDeviceInfoExtendedResult,  currentDevice == 1"));
      testmodeBTlistItemValue[BTTM_EN_BTADDRESS_DEVICE1] = result->getSBluetoothDeviceAddress();
      ETG_TRACE_USR2(("onGetDeviceInfoExtendedResult,  getSBluetoothDeviceAddress = %s", result->getSBluetoothDeviceAddress().c_str()));
      testmodeBTlistItemValue[BTTM_EN_LINKKEY_DEVICE1] = result->getSLinkKey();
      testmodeBTlistItemValue[BTTM_EN_HFP_DEVICE1] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBHFPSupport());
      testmodeBTlistItemValue[BTTM_EN_PBAP_DEVICE1] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBPBAPSuport());
      testmodeBTlistItemValue[BTTM_EN_MAP_DEVICE1] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBMAPSupport());
      testmodeBTlistItemValue[BTTM_EN_HSP_DEVICE1] = setTestmodeBTitemvalue(FALSE);
      testmodeBTlistItemValue[BTTM_EN_A2DP_DEVICE1] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBA2DPSupport());
      testmodeBTlistItemValue[BTTM_EN_AVRC_DEVICE1] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBAVRCPSupport());
   }
   else if (currentDevice == 2)
   {
      ETG_TRACE_USR2(("onGetDeviceInfoExtendedResult,  currentDevice == 2"));
      testmodeBTlistItemValue[BTTM_EN_BTADDRESS_DEVICE2] = result->getSBluetoothDeviceAddress();
      testmodeBTlistItemValue[BTTM_EN_LINKKEY_DEVICE2] = result->getSLinkKey();
      testmodeBTlistItemValue[BTTM_EN_HFP_DEVICE2] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBHFPSupport());
      testmodeBTlistItemValue[BTTM_EN_PBAP_DEVICE2] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBPBAPSuport());
      testmodeBTlistItemValue[BTTM_EN_MAP_DEVICE2] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBMAPSupport());
      testmodeBTlistItemValue[BTTM_EN_HSP_DEVICE2] = setTestmodeBTitemvalue(FALSE);
      testmodeBTlistItemValue[BTTM_EN_A2DP_DEVICE2] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBA2DPSupport());
      testmodeBTlistItemValue[BTTM_EN_AVRC_DEVICE2] = setTestmodeBTitemvalue(result->getOSupportedProfiles().getBAVRCPSupport());
   }
   TestmodeBTlistBuild(m_TM_btStartIndex);
}


std::string PhoneTestMode:: setTestmodeBTitemvalue(bool status)
{
   if (status)
   {
      return  "YES";
   }
   else
   {
      return "NO";
   }
}


std::string PhoneTestMode:: getTestmodeBTStreamStatus(int status)
{
   if (status == true)
   {
      return  "PAUSE";
   }
   else if (status == false)
   {
      return "PLAY";
   }
   else
   {
      return "";
   }
}


void PhoneTestMode::TestmodeBTlistBuild(int startIndex)
{
   int u8ListIterator;
   bt_testmodeInfo testmodeBTlistEntry;
   int u8ListSize = 29;
   m_TM_btlastItemIndex_PBList = startIndex + u8ListSize - 1;
   std::string ECNRStatus = "ON";
   testmodeBTlistItemValue[BTPHN_EN_ECNR_ENGINE] = ECNRStatus;//Always display ON, as per the requirement
   testmodeBTlistItemValue[BTPHN_EN_STREAMING_PLAY_STATUS] = getTestmodeBTStreamStatus(m_playbackstate);
   //ListBTDataUpdateMsg(SxmTestMonitor::poGetInstance()->getBTStreamingAvailability());

   const char* testmodeBTlistItemNames[] =
   {
      "BT Address of the system :",
      "Supported profiles of system",
      "Phonebook access profile (PBAP) :",
      "Message access profile (MAP) :",
      "Advanced audio distribution profile :",
      "Audio/video remote control profile :",
      "Hands free profile(HFP) :",
      "Headset Profile(HSP) :",
      "BT address of connected device 1 :",
      "Supported profiles of device 1 ",
      "Phonebook access profile (PBAP) :",
      "Message access Profile (MAP) :",
      "Advanced audio distribution profile :",
      "Audio/video remote control profile :",
      "Hands free profile (HFP) :",
      "Headset profile (HSP) :",
      "Link key of HDP device 1 :",
      "BT address of connected device 2 :",
      "Supported profiles of device 2 ",
      "Phonebook access profile (PBAP) :",
      "Message access Profile (MAP) :",
      "Advanced audio distribution profile :",
      "Audio/video remote control profile :",
      "Hands free profile (HFP) :",
      "Headset profile (HSP) :",
      "Link key of HDP device 1 :",
      "Streaming play status :",
      "Microphone current status :",
      "Device EC/NR engine :",
   };

   std::vector<bt_testmodeInfo> artestmodeBTlistItem;
   artestmodeBTlistItem.clear();
   for (u8ListIterator = 0; u8ListIterator < u8ListSize; u8ListIterator++)
   {
      testmodeBTlistEntry.btTestmodeName = testmodeBTlistItemNames[u8ListIterator];
      testmodeBTlistEntry.btTestmodevalue = testmodeBTlistItemValue[u8ListIterator];
      ETG_TRACE_USR4(("Item name  : %s", (testmodeBTlistEntry.btTestmodeName).c_str()));
      ETG_TRACE_USR4(("Item value : %s", (testmodeBTlistEntry.btTestmodevalue).c_str()));

      artestmodeBTlistItem.push_back(testmodeBTlistEntry);
   }
   updateBTTestModeList(artestmodeBTlistItem, m_TM_btStartIndex, m_TM_btlastItemIndex_PBList, u8ListSize);
}


void PhoneTestMode::updateBTTestModeList(std::vector<bt_testmodeInfo>& artestmodeBTlistItem, int TMStartIndex, int lastItemIndex_TMList, int TotalListSize_TM)
{
   ETG_TRACE_USR4(("UpdateBTTestModeList entry..."));
   (*m_ListDataSize).mTestmodeBTListSize = BTPHN_C_DEFAULT_VALUE_ZERO;
   (*m_ListID).mTestmodeListId = LIST_ID_TestmodeBT;
   m_ListID.MarkAllItemsModified();
   m_ListID.SendUpdate(true);
   m_ListDataSize.MarkItemModified(ItemKey::ListDataSize::TestmodeBTListSizeItem);
   m_ListDataSize.SendUpdate(true);

   int u8Windowsize = artestmodeBTlistItem.size();//usually will be the size of the list
   ListDataProviderBuilder listBuilder(LIST_ID_TestmodeBT);
   ListProviderEventInfo info;
   PhoneTestMode_ListItemData ListData[lastItemIndex_TMList + 1];
   /*Extract data from array artestmodeBTlistItem and fill the data to the list starting from start index to last index */
   for (int u8Index = BTPHN_C_DEFAULT_VALUE_ZERO, dataIndex = TMStartIndex;
         ((u8Index < u8Windowsize) && (dataIndex <= lastItemIndex_TMList));
         u8Index++, dataIndex++)
   {
      ListData[dataIndex].mTestmodeListItemName = (artestmodeBTlistItem[u8Index].btTestmodeName).c_str();
      ListData[dataIndex].mTestmodeListItemValue = (artestmodeBTlistItem[u8Index].btTestmodevalue).c_str();

      /*add each row items to the list*/
      listBuilder.AddItem(dataIndex, 0, "Layer_TestMode").AddDataBindingUpdater<PhoneTestMode_ListItemDataBindingSource>(ListData[dataIndex]);
   }
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider(TMStartIndex, TotalListSize_TM);
   POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
}


/************************************************************************
*FUNCTION		: onPlaybackStateStatus (SWFL-629,SWFL-630,SWFL-631,SWFL-632)
*DESCRIPTION	: update info of play/pause state
*PARAMETER		: proxy
*PARAMETER		: PlayBackState
*RETURNVALUE	: void
*SWFL			: [SWFL-2451]
************************************************************************/

void PhoneTestMode::onPlaybackStateStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackStateStatus >& status)
{
   ETG_TRACE_USR4(("PhoneTestMode::onPlaybackStateStatus() %d", status->getE8State()));
   ETG_TRACE_USR4(("PhoneTestMode::getBTStreamingAvailability() %d", SxmTestMonitor::poGetInstance()->getBTStreamingAvailability()));
   if (m_CurrentDeviceType == ::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH)
   {
      if (status->getE8State() == MPlay_fi_types::T_e8_MPlayState__e8PBS_PAUSED)
      {
         m_playbackstate = MPlay_fi_types::T_e8_MPlayState__e8PBS_PAUSED;
         ETG_TRACE_USR4(("PhoneTestMode::m_playbackstate in pause() %d", m_playbackstate));
      }
      else
      {
         m_playbackstate = MPlay_fi_types::T_e8_MPlayState__e8PBS_PLAYING;
         ETG_TRACE_USR4(("PhoneTestMode::m_playbackstate in play() %d", m_playbackstate));
      }
      updateBTStreamStatusListItem(true);
   }
   ETG_TRACE_USR4(("PhoneTestMode::m_playbackstate() %d", m_playbackstate));
}


std::string  PhoneTestMode::getBTStreamDataListItemText()
{
   return "Streaming play status :";
}


void PhoneTestMode::updateBTList(bool val)
{
   if (val == false)
   {
      m_playbackstate = DEFAULT_VALUE;
   }
   updateBTStreamStatusListItem(val);
}


void PhoneTestMode::updateBTStreamStatusListItem(bool connectionStatus)
{
   ListDataProviderBuilder listBuilder(LIST_ID_TestmodeBT);
   PhoneTestMode_ListItemData ListData;
   ListData.mTestmodeListItemName = getBTStreamDataListItemText().c_str();
   if (connectionStatus == true)
   {
      ListData.mTestmodeListItemValue = getTestmodeBTStreamStatus(m_playbackstate).c_str();
      ETG_TRACE_USR4(("Item value for BT PLAY/PAUSE : %s", getTestmodeBTStreamStatus(m_playbackstate).c_str()));
   }
   else
   {
      ListData.mTestmodeListItemValue = getTestmodeBTStreamStatus(DEFAULT_VALUE).c_str();
      ETG_TRACE_USR4(("Item value for BT invalid/not CONNECTED: %s", getTestmodeBTStreamStatus(DEFAULT_VALUE).c_str()));
   }
   listBuilder.AddItem(BTPHN_EN_STREAMING_PLAY_STATUS, 0, "Layer_TestMode", 0, BTPHN_EN_STREAMING_PLAY_STATUS) .AddDataBindingUpdater<PhoneTestMode_ListItemDataBindingSource>(ListData);
   tSharedPtrDataProviderUpdater dataProviderUpdater = listBuilder.CreateDataProviderUpdater();
   POST_MSG((COURIER_MESSAGE_NEW(ListDataProviderUpdMsg)(dataProviderUpdater)));
}


/************************************************************************
*FUNCTION		: onPlaybackStateError
*DESCRIPTION	: called if PlayBackState property is updated with error from media player
*PARAMETER		: proxy
*PARAMETER		: error
*RETURNVALUE	: void
************************************************************************/

void PhoneTestMode::onPlaybackStateError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackStateError >& error)
{
   ETG_TRACE_USR4(("onPlaybackStateError received........"));
}


/************************************************************************
*FUNCTION		: onNowPlayingStatus
*DESCRIPTION	: Receives info about the currently playing track and updates the same on playscreen
*PARAMETER		: proxy
*PARAMETER		: result
*RETURNVALUE	: void
************************************************************************/
void PhoneTestMode::onNowPlayingStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                       const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingStatus >& status)
{
   ETG_TRACE_USR4(("oMediaObject::e8DeviceType 	= %d", status->getOMediaObject().getE8DeviceType()));
   if (status->getOMediaObject().getE8DeviceType() == ::MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH)
   {
      m_CurrentDeviceType =  status->getOMediaObject().getE8DeviceType();
   }
}


/************************************************************************
*FUNCTION		: onNowPlayingError
*DESCRIPTION	: called if NowPlaying property is updated with error from media player
*PARAMETER		: proxy
*PARAMETER		: result
*RETURNVALUE	: void
************************************************************************/

void PhoneTestMode::onNowPlayingError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingError >& error)
{
   ETG_TRACE_USR4(("tclMediaClientHandler::onNowPlayingError() received..........."));
}


}//end of namespace Core
}//end of namespace App
