/************************************************************************
*FILE:			HealthcareUtility.cpp
*SW-COMPONENT: 	HealthcareUtility
*DESCRIPTION: 	Symbolic constants used across the healthcare application is defined.
*AUTHORS: 		Sheena Mathew
*COPYRIGHT: 	* Copyright (c) 2018-2020 Robert Bosch Car Multimedia GmbH
				* duplication and disclosure to third parties is prohibited.
************************************************************************/


#include <boost/algorithm/string.hpp>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea


#include "HealthcareUtility.h"
#include "HealthCareTestMode.h"


using namespace std;
using namespace boost::algorithm;

namespace App {
namespace Core {

/**
* @Constructor
*/
HealthcareUtility::HealthcareUtility()
{
}


/**
* @Destructor
*/
HealthcareUtility::~HealthcareUtility()
{
}


std::string HealthcareUtility::enumConversionToString(::bosch::cm::ai::HealthcareMonService::enDevID _DevID)
{
   std::stringstream stringToConvert;
   stringToConvert << _DevID;
   return stringToConvert.str();
}


/**
 * Description     : Function implements to convert uint32 value to hexstring.
 *
 * @param[in]      : u32Value : uint32 value.
 * @return         : hexstring
*/
std::string HealthcareUtility::u32ConversionTohexString(uint32 u32Value)
{
   std::stringstream stringToConvert;
   stringToConvert << "0x" << std::hex << u32Value;
   return stringToConvert.str();
}


/**
 * Description     : Function implements to convert uint16 value to hexstring.
 *
 * @param[in]      : u16Value : uint16 value.
 * @return         : hexstring
*/
std::string HealthcareUtility::u16TextidConversionTohexString(uint16 u16Value)
{
   std::stringstream stringToConvert;
   stringToConvert << hex << u16Value;				//	Dec to hex
   string strHexConv = stringToConvert.str();		//	hex to string
   to_upper(strHexConv);							// to upper case
   std::stringstream concatenatedString;
   concatenatedString << "0x" << strHexConv;
   std::string finalresult = concatenatedString.str();	//std string
   return finalresult;
}


/**
 * Description     : Function implements to convert uint8 value to hexstring.
 *
 * @param[in]      : u8Value : uint8 value.
 * @return         : hexstring
*/
std::string HealthcareUtility::u8ConversionTohexString(uint8 u8Value)
{
   std::stringstream stringToConvert;
   stringToConvert << "0x" << std::hex << u8Value;
   return stringToConvert.str();
}


}
}


/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
