/**************************************************************************************
* @file         : HealthCareTestMode.h
* @author       : RBEI/ECG5-INF4CV_Team
* @addtogroup   : AppHmi_TestMode
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*16.06.21 Rev. 0.1 Sheena Mathew (RBEI/ECH2)
* 		  			Initial Revision.
**************************************************************************************/
#ifndef HEALTHCARETESTMODE_H
#define HEALTHCARETESTMODE_H

#include "AppHmi_TestmodeMessages.h"
#include "AppHmi_TestmodeDatabinding.h"
#include "AppHmi_TestmodeStateMachine.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_TestmodeStateMachineData.h"
#include "bosch/cm/ai/HealthcareMonServiceClientBase.h"
#include "bosch/cm/ai/HealthcareMonServiceProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "asf/core/Types.h"
#include <boost/algorithm/string/join.hpp>
#include <vector>
#include<string>

#define HEALTHCARE_CONTROL ::bosch::cm::ai::HealthcareMonService
struct stHealthCareData
{
      uint8 deviceNum;
      uint32 dtcCode;
      uint16 textID;
      std::string devIDstr;
      std::string deviceNumstr;
      std::string dtcCodestr;
      std::string textIDstr;
      std::string defaultText;
   public :
      stHealthCareData() : deviceNum(0), dtcCode(0), textID(0), devIDstr(""), deviceNumstr(""), dtcCodestr(""), textIDstr(""), defaultText("")
      {
      }
};


namespace App {
namespace Core {

class HealthCareTestMode : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF,
   public HEALTHCARE_CONTROL::SendAcknowldgementCallbackIF,
   public HEALTHCARE_CONTROL::Sig_ShowDTCPopupCallbackIF
{
   public:
      static HealthCareTestMode* poGetInstance()
      {
         if (NULL == _HealthCareTestMode)
         {
            _HealthCareTestMode = new HealthCareTestMode();
         }
         return _HealthCareTestMode;
      }
      COURIER_MSG_MAP_BEGIN(0)	//TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_MODEL_COMP
      ON_COURIER_MESSAGE(HealthCareMntrDTCMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()
      bool onCourierMessage(const HealthCareMntrDTCMsg& oMsg);
      virtual ~HealthCareTestMode();
      //Singleton class implementation
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onSig_ShowDTCPopupError(const ::boost::shared_ptr<HEALTHCARE_CONTROL::HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr<HEALTHCARE_CONTROL::Sig_ShowDTCPopupError >& error) ;
      void onSig_ShowDTCPopupSignal(const ::boost::shared_ptr<HEALTHCARE_CONTROL::HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr<HEALTHCARE_CONTROL::Sig_ShowDTCPopupSignal >& signal) ;
      void onSendAcknowldgementError(const ::boost::shared_ptr<HEALTHCARE_CONTROL::HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr<HEALTHCARE_CONTROL::SendAcknowldgementError >& error) ;
      void onSendAcknowldgementResponse(const ::boost::shared_ptr<HEALTHCARE_CONTROL::HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr<HEALTHCARE_CONTROL::SendAcknowldgementResponse >& response) ;
      HEALTHCARE_CONTROL::enDevID _DevID;
   private:
      HealthCareTestMode();
      static HealthCareTestMode* _HealthCareTestMode;
      ::boost::shared_ptr< HEALTHCARE_CONTROL::HealthcareMonServiceProxy> _HealthcareProxy;
      void UpdatePopupTextReqMsg(struct stHealthCareData& _healthCareData);
      stHealthCareData _HCM;
      DataBindingItem<HealthCareMonitorDTCinfoDataBindingSource> oHealthCareMonitorDTCinfo;
};


}
}


#endif
