/**************************************************************************************
 * @file         :NACVdemo.cpp
 * @author       :ECV4-Sreelekshmi Gopakumar
 * @addtogroup   :VehicleSDSFocusHandler HALL
 * @brief        :
 * @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#include <hmibase/hall_std_if.h>
#include "NACVdemo.h"
//#include "AppHmi_MasterStateMachine.h"
//#include "AppHmi_MasterMessages.h"
#define DIAGNOSTICS_S_IMPORT_INTERFACE_CONFIGURATION
#include <fc_diagnosis_if.h>
#include <sys/time.h>
#include "ApplicationSwitchConst.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TESTMODE_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX                 App::Core::Nacvdemo::
#include "trcGenProj/Header/NACVdemo.cpp.trc.h"
#endif

using namespace Util;
using namespace ::Midw_Diagnostics_FI;
using namespace midw_diagnostics_fi_types;

namespace App {
namespace Core {

const unsigned int NAC_TIMER_REFRESH_RATE = 3000;
NACVdemo* NACVdemo::_mNACVdemo = NULL;
NACVdemo::~NACVdemo()
{
   _diagProxy.reset();
   _mNACVdemo = NULL;
   //ETG_TRACE_USR4(("NACVdemo::~NACVdemo"));
}


NACVdemo::NACVdemo()
   : _diagProxy(Midw_Diagnostics_FIProxy::createProxy("diagnosticsFiPort", *this))
     //, m_oTimerSlider(*this, TIMER_SLIDER_VAL_INTERVAL)
{
   ETG_TRACE_USR4(("NACVdemo::NACVdemo"));

   ETG_I_REGISTER_FILE();

   _mNACVdemo = this;
   updateReceived = false;
   _downloadStarted = false;
   _screenDownloadTimer = NULL;
   _nacScreenIndex = 0;
   _screenTimer = NULL;
   _applicationSwitchClientComponent = ApplicationSwitchClientComponent :: poGetInstance();
   testmode = SystemSettingTestMode::poGetInstance();
   // todo: should be removed, because registrations are not done
   if (_diagProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _diagProxy->getPortName());
      ETG_TRACE_USR4(("NACVdemo::NACVdemo after creating Proxy"));
   }
   showStartupVideo();
}


NACVdemo* NACVdemo::getInstance()
{
   ETG_TRACE_USR4(("NACVdemo::getInstance "));
   if (_mNACVdemo == NULL)
   {
      ETG_TRACE_USR4(("NACVdemo::getInstance inside"));
      _mNACVdemo = new NACVdemo();
   }
   return _mNACVdemo;
}


void NACVdemo::registerProperties(const boost::shared_ptr< asf::core::Proxy >& proxy,	const asf::core::ServiceStateChange& /*stateChange*/)
{
   //ETG_TRACE_USR4(("NACVdemo::registerProperties"));
}


void NACVdemo::deregisterProperties(const boost::shared_ptr< asf::core::Proxy >& proxy,	const asf::core::ServiceStateChange& /*stateChange*/)
{
   //ETG_TRACE_USR4(("NACVdemo::deregisterProperties"));
}


void NACVdemo::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   if ((proxy == _diagProxy) && (_diagProxy.get()))
   {
      _diagProxy->sendSetDisplayRelUpRegAll();
   }
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void NACVdemo::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR3(("NACVdemo::onAvailable()"));

   if ((proxy == _diagProxy) && (_diagProxy.get()))
   {
      _diagProxy->sendSetDisplayUpReg(*this);

      ETG_TRACE_USR3(("NACVdemo::onAvailable() 123"));
   }
}


void NACVdemo::onSetDisplayError(const ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< Midw_Diagnostics_FI::SetDisplayError >& error)
{
   //ETG_TRACE_USR4(("NACVdemo::onDiagConfigItemError"));
}


void NACVdemo::totest(int i)
{
   ETG_TRACE_USR4(("NACVdemo::totest %d", i));
   if (i == 1)
   {
      ETG_TRACE_USR4(("NACVdemo::totest 1"));
      _applicationSwitchClientComponent->requestContextSwitchApplication(2, APPID_APPHMI_TESTMODE, enActivityIDs__eActivityID_DIAGNOSIS, APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)80);
      // _applicationSwitchClientComponent->requestContextSwitchApplication(2,2,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0,0,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);//APPID_APPHMI_TESTMODE,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)eActivityID_DIAGNOSIS,0,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);
   }
   if (i == 2)
   {
      ETG_TRACE_USR4(("NACVdemo::totest 2"));
      _applicationSwitchClientComponent->requestContextSwitchApplication(2, 0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0 , APPID_APPHMI_TESTMODE, enActivityIDs__eActivityID_DIAGNOSIS);
      //_applicationSwitchClientComponent->requestContextSwitchApplication(2,2,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0,0,(bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);
   }
}


void NACVdemo::onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error)
{
}


void NACVdemo::onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal)
{
}


/*void NACVdemo::onSetDisplayStatus(const ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< Midw_Diagnostics_FI::SetDisplayStatus >& status)
{
   ETG_TRACE_USR4(("NACVdemo::onSetDisplayStatus"));

    if (status->getDisplayData().hasTestScreen())
       {
          ETG_TRACE_USR4(("NACVdemo::onSetDisplayStatus- TestScreenValue : %d", status->getDisplayData().getTestScreen()));

		enTestScreen i = static_cast<enTestScreen>(status->getDisplayData().getTestScreen());
		if((i>0) && (i<29))
		{
			testmode->DisplayUpdateImage(i);
		}
		else
		{
			//testmode->totest(1);
		}
      }
	else
	  {
		 ETG_TRACE_USR4(("NACVdemo::onSetDisplayStatus.. Something wrong"));
	  }
	_diagProxy->sendSetDisplaySet(*this, true);
         ETG_TRACE_USR4(("TMPDClient:: Send Positive Response to diagnosis"));
}*/


void NACVdemo::onSetDisplayStatus(const ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< Midw_Diagnostics_FI::SetDisplayStatus >& status)
{
   int check = 15;
   ETG_TRACE_USR4(("NACVdemo::onSetDisplayStatus %d", check));
   if (proxy == _diagProxy)
   {
      ETG_TRACE_USR4(("NACVdemo::TMPDClient:: _diagnosticProxy is valid"));
      if (status->getDisplayData().hasTestScreen())
      {
         uint32 testScr = static_cast<uint32>(status->getDisplayData().getTestScreen());
         enTestScreen testScreen = static_cast<enTestScreen>(testScr);
         ETG_TRACE_USR4(("NACVdemo::TMPDClient::onSetDisplayStatus- TestScreenValue : %d %d %d", ETG_CENUM(enTestScreen, testScreen), (enTestScreen)testScreen, check));
         ETG_TRACE_USR4(("NACVdemo::TMPDClient::onSetDisplayStatus- TestScreenValue check 1: %d %d ", (enTestScreen)testScreen, check));
         ETG_TRACE_USR4(("NACVdemo::TMPDClient::onSetDisplayStatus- TestScreenValue check 2: %d %d ", testScreen, check));
         stopNACTimer();
         switch (testScreen)
         {
            case TEFSpecial1:
            {
               if (::SceneSelectOption == 1)
               {
                  testmode->ActivateTestScreen();
                  setNACTimer();
                  ETG_TRACE_USR4(("NACVdemo::TMPDClient:: PD screen is created with NAC Test scene"));
               }
               else
               {
                  recallNACScreen();
                  ETG_TRACE_USR4(("NACVdemo::Recall Nacscreen has been called"));
               }
            }
            break;
            case NoTestScreen:
            {
               if (::SceneSelectOption == 2)
               {
                  //stopNACTimer();
                  _nacScreenIndex = 0;
                  //::SceneSelectOption = 1;
                  ETG_TRACE_USR4(("NACVdemo::Test Screnn Destroyed"));
                  testmode->ExitTestScreen();
               }
            }
            break;
            case PlainWhite:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IWhite) =%d", testScreen));
               testmode->DisplayUpdateImage(IWhite);
            }
            break;
            case PlainBlack:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IBlack) =%d", testScreen));
               testmode->DisplayUpdateImage(IBlack);
            }
            break;
            case PlainRed:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IRed) =%d", testScreen));
               testmode->DisplayUpdateImage(IRed);
            }
            break;
            case PlainGreen:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGreen) =%d", testScreen));
               testmode->DisplayUpdateImage(IGreen);
            }
            break;
            case PlainBlue:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IBlue) =%d", testScreen));
               testmode->DisplayUpdateImage(IBlue);
            }
            break;
            case Coloured:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IColorbar) =%d", testScreen));
               testmode->DisplayUpdateImage(IColorbar);
            }
            break;
            case FlickerTest:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IFlickerTest) =%d", testScreen));
               testmode->DisplayUpdateImage(IFlickerTest);
            }
            break;
            case TestMark:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(ITestMark) =%d", testScreen));
               testmode->DisplayUpdateImage(ITestMark);
            }
            break;
            case RGB_Nok:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IRGB_Nok) =%d", testScreen));
               testmode->DisplayUpdateImage(IRGB_Nok);
            }
            break;
            case RGB_Ok:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IRGB_Ok) =%d", testScreen));
               testmode->DisplayUpdateImage(IRGB_Ok);
            }
            break;
            case RGB_repDark:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IRGB-repDark) =%d", testScreen));
               testmode->DisplayUpdateImage(IRGB_repDark);
            }
            break;
            case Gamma_01:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_1);
            }
            break;
            case Gamma_02:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_2);
            }
            break;
            case Gamma_03:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_3);
            }
            break;
            case Gamma_04:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_4);
            }
            break;
            case Gamma_05:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_5);
            }
            break;
            case Gamma_06:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_6);
            }
            break;
            case Gamma_07:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_7);
            }
            break;
            case Gamma_08:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_8);
            }
            break;
            case Gamma_09:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_9);
            }
            break;
            case Gamma_10:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_10);
            }
            break;
            case Gamma_11:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_11);
            }
            break;
            case Gamma_12:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_12);
            }
            break;
            case Gamma_13:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_13);
            }
            break;
            case Gamma_14:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_14);
            }
            break;
            case Gamma_15:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_15);
            }
            break;
            case Gamma_16:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_16);
            }
            break;
            case Gamma_17:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_17);
            }
            break;
            case Gamma_18:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_18);
            }
            break;
            case Gamma_19:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IGAMMA_19);
            }
            break;
            case DotDet_01:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_01) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_01);
            }
            break;
            case DotDet_02:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_02) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_02);
            }
            break;
            case DotDet_03:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_03) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_03);
            }
            break;
            case DotDet_04:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_04) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_04);
            }
            break;
            case DotDet_05:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_05) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_05);
            }
            break;
            case DotDet_06:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_06) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_06);
            }
            break;
            case DotDet_07:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_07) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_07);
            }
            break;
            case DotDet_08:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_08) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_08);
            }
            break;
            case DotDet_09:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_09) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_09);
            }
            break;
            case DotDet_10:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_10) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_10);
            }
            break;
            case DotDet_11:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_11) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_11);
            }
            break;
            case DotDet_12:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_12) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_12);
            }
            break;
            case DotDet_13:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_13) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_13);
            }
            break;
            case DotDet_14:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_14) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_14);
            }
            break;
            case DotDet_15:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_15) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_15);
            }
            break;
            case DotDet_16:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_16) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_16);
            }
            break;
            case DotDet_17:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_17) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_17);
            }
            break;
            case DotDet_18:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_18) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_18);
            }
            break;
            case DotDet_19:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_19) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_19);
            }
            break;
            case DotDet_20:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_20) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_20);
            }
            break;
            case DotDet_21:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_21) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_21);
            }
            break;
            case DotDet_22:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_22) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_22);
            }
            break;
            case DotDet_23:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_23) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_23);
            }
            break;
            case DotDet_24:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_24) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_24);
            }
            break;
            case DotDet_25:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_25) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_25);
            }
            break;
            case DotDet_26:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_26) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_26);
            }
            break;
            case DotDet_27:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_27) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_27);
            }
            break;
            case DotDet_28:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IDotDet_28) =%d", testScreen));
               testmode->DisplayUpdateImage(IDotDet_28);
            }
            break;
            /**case Gamma_01:
              {
                 ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_1) =%d", testScreen));
                 testmode->DisplayUpdateImage(IGAMMA_1);
              }
            break;
             case Gamma_02:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_2) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_2);
               }
            break;
             case Gamma_03:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_3) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_3);
               }
            break;
             case Gamma_04:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_4) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_4);
               }
            break;
             case Gamma_05:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_5) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_5);
               }
            break;
             case Gamma_06:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_6) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_6);
               }
            break;
             case Gamma_07:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_7) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_7);
               }
            break;
             case Gamma_08:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_8) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_8);
               }
            break;
             case Gamma_09:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_9) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_9);
               }
            break;
             case Gamma_10:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_10) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_10);
               }
            break;
             case Gamma_11:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_11) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_11);
               }
            break;
             case Gamma_12:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_12) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_12);
               }
            break;
             case Gamma_13:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_13) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_13);
               }
            break;
             case Gamma_14:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_14) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_14);
               }
            break;
             case Gamma_15:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_15) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_15);
               }
            break;
             case Gamma_16:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_16) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_16);
               }
            break;
             case Gamma_17:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_17) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_17);
               }
            break;
             case Gamma_18:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_18) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_18);
               }
            break;
             case Gamma_19:
               {
                  ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IGAMMA_19) =%d", testScreen));
                  testmode->DisplayUpdateImage(IGAMMA_19);
               }
            break;**/
            case FLIP_HDUV:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IFLIP_HDUV) =%d", testScreen));
               testmode->DisplayUpdateImage(IFLIP_HDUV);
            }
            break;
            case POINT1BMP:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IPOINT1BMP) =%d", testScreen));
               testmode->DisplayUpdateImage(IPOINT1BMP);
            }
            break;
            case POINT2BMP:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IPOINT2BMP) =%d", testScreen));
               testmode->DisplayUpdateImage(IPOINT2BMP);
            }
            break;
            case POINT3BMP:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IPOINT3BMP) =%d", testScreen));
               testmode->DisplayUpdateImage(IPOINT3BMP);
            }
            break;
            case POINT4BMP:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IPOINT4BMP) =%d", testScreen));
               testmode->DisplayUpdateImage(IPOINT4BMP);
            }
            break;
            case POINT5BMP:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(IPOINT5BMP) =%d", testScreen));
               testmode->DisplayUpdateImage(IPOINT5BMP);
            }
            break;
            default:
            {
               ETG_TRACE_USR4(("NACVdemo::DisplayUpdateImage(Unknown Test Screen Value) =%d", testScreen));
               ETG_TRACE_ERR(("Unknown Test Screen Value"));
            }
            break;
         }
      }
      _diagProxy->sendSetDisplaySet(*this, true);
   }
}


void NACVdemo::setNACTimer()
{
   NACTimerExpiryMsg* pReqListMsg = COURIER_MESSAGE_NEW(NACTimerExpiryMsg)(); //creating message for Timer
   ETG_TRACE_USR4(("Timer Message is created"));
   //stop the Timer
   stopNACTimer();

   if (pReqListMsg)
   {
      _NACTimer.setTimeout(0, NAC_TIMER_REFRESH_RATE , pReqListMsg);//for every 3sec NACTimerExpiryMsg is called
      _NACTimer.start();

      ETG_TRACE_USR4(("Timer is Started"));
   }
}


bool NACVdemo::onCourierMessage(const NACTimerExpiryMsg& /*oMsg*/)
{
   ETG_TRACE_USR4(("NACVdemo::NACTimerExpiryMsg"));
   stopNACTimer();
   ETG_TRACE_USR4(("original index value : %d", _nacScreenIndex));
   _nacScreenIndex = (_nacScreenIndex + 1) % 3 ; // incrementing every time to have a loop like NAC2-NAC3-NAC1
   ETG_TRACE_USR4(("index value modulo three : %d", _nacScreenIndex));
   testmode->DisplayUpdateImage(_nacScreenIndex);
   setNACTimer();
   return true;
}


void NACVdemo::stopNACTimer()
{
   if (_NACTimer.getStatus() != 0)
   {
      _NACTimer.stop();

      ETG_TRACE_USR4(("Timer is Stopped"));
   }
}


void NACVdemo::recallNACScreen()
{
   stopNACTimer();
   _nacScreenIndex = 0;
   testmode->DisplayUpdateImage(_nacScreenIndex);
   setNACTimer();
}


/*bool NACVdemo::onCourierMessage(const TimerExpiredMsg& msg)
{
	//ETG_TRACE_USR4(("NACVdemo::onCourierMessage.. TimerExpiredMsg"));
	if(_screenTimer == msg.GetTimer())
	{
		deleteTimer(_screenTimer);
	}
	else if(_screenDownloadTimer == msg.GetTimer())
	{
		deleteTimer(_screenDownloadTimer);
		updateReceived = false;
	}
	if(updateReceived == true)
	{
		updateReceived = false;
		POST_MSG((COURIER_MESSAGE_NEW(Start_Download)()));
	}
	//if(_screenTimer == msg.GetTimer())
	return true;
}*/

void NACVdemo::showText()
{
   //Timer::Status timerStatus = _screenTimer->getStatus();
   //ETG_TRACE_USR4(("NACVdemo::showText"));
   std::string timeString1 = " seconds to restart !!";
   int timeValue = 1000;
   char DLString[50] = "\0";

   //ETG_TRACE_USR4(("NACVdemo::showText Before while"));

   if (_screenDownloadTimer != NULL)
   {
      while (_screenDownloadTimer->getStatus() == 1 && timeValue > 0) //Runnig
      {
         //ETG_TRACE_USR4(("NACVdemo::showText Timer loop"));
         timeValue = timeValue / 100;
         snprintf(DLString, sizeof DLString, "%d %s", timeValue, timeString1.c_str());
         //ETG_TRACE_USR4(("NACVdemo::showText Timer loop string %s", DLString ));
         /*(*oDownloadTextVisibity).mDownloadText = DLString;
           oDownloadTextVisibity.MarkAllItemsModified();
          oDownloadTextVisibity.SendUpdate();*/
         timeValue = (timeValue - 100);
      }
   }
   else
   {
      //ETG_TRACE_USR4(("NACVdemo::_screenDownloadTimer is  NULL"));
   }

   /* while (timeValue > 0) //Runnig
   {
    //ETG_TRACE_USR4(("NACVdemo::showText Timer loop"));
   	--timeValue;
     snprintf(DLString, sizeof DLString, "%d %s", timeValue, timeString1.c_str());
     //ETG_TRACE_USR4(("NACVdemo::showText Timer loop string %s", DLString ));
     (*oDownloadTextVisibity).mDownloadText = DLString;
       oDownloadTextVisibity.MarkAllItemsModified();
      oDownloadTextVisibity.SendUpdate();
   }
    */
}


/**
 * Description     : getDiagDpValue, reads the language id on startup
 *
 * @param[in]      : none
 * @param[in]      : none
 * @return         : uint8
 */
uint8 NACVdemo::getDiagDpValue()
{
   //dp_tclAppHmi_MasterNACVDiagDatapool _mDiagDataPool;
   //ETG_TRACE_USR4(("NACVdemo::getDiagDpValue() %d", _mDiagDataPool.tGetData()));
   return 0;//_mDiagDataPool.tGetData();
}


void NACVdemo::showStartupVideo()
{
   //ETG_TRACE_USR4(("NACVdemo::showStartupVideo()"));
   int selectVideo = 0;
   selectVideo = getDiagDpValue();
   //ETG_TRACE_USR4(("NACVdemo::showStartupVideo(%d)", selectVideo));
   if (selectVideo == 0)
   {
      // show logo  1
   }
   else
   {
      // show logo  2
   }
}


/*bool NACVdemo::onCourierMessage(const Start_Download& msg)
{
   //HallComponentBase::onCourierMessage(msg);
   //ETG_TRACE_USR4((" NACVdemo::onCourierMessage(const Start_Download& msg)"));
	//startTimer(20000, _screenDownloadTimer);
	startTimer(20000, 2);
		showText();
	return true;
}*/

/* bool NACVdemo::startTimer(int timeValue, ::Util::Timer* ptr)
{
   //ETG_TRACE_USR4(("NACVdemo::startTimer()"));

   if(ptr == getTimer())
   {
	 //ETG_TRACE_USR4(("NACVdemo::startTimer( First Timer)"));
   }
   bool bRet = false;
   if (ptr == NULL)
   {
      ptr = new Timer(timeValue);
   }
   if (ptr != NULL)
   {
      ptr->start();
      bRet = true;
   }
   return bRet;
}  */

void NACVdemo::startTimer(int timeValue , int whichTimer)
{
   //ETG_TRACE_USR4(("NACVdemo::startTimer whichTimer()"));

   /*if(whichTimer == 1 )
   {
     _screenTimer = new Timer(15000);
     if(_screenTimer != NULL)
     _screenTimer->start();
   }
   else
   {
     _screenDownloadTimer = new Timer(20000);
     if(_screenDownloadTimer != NULL)
     _screenDownloadTimer->start();
   }*/
}


void NACVdemo::deleteTimer(::Util::Timer* ptr)
{
   if (ptr != NULL)
   {
      ptr->stop();
      delete ptr;
      ptr = NULL;
   }
}


//void NACVdemo::vHandleTraceMessage(const tUChar* puchData)
//{
// tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
//ETG_TRACE_USR4(("NACVdemo::vHandleTraceMessage"));
//ETG_TRACE_USR1(("NACVdemo::vHandleTraceMessage(): process command: %d.", u32MsgCode));
//}

/*void NACVdemo::testSimulation()
{
	//ETG_TRACE_USR4(("NACVdemo::testSimulation"));
	_downloadStarted = true;
    //Download scene
	POST_MSG((COURIER_MESSAGE_NEW(Show_DownloadScene)()));
    (*oDownloadTextVisibity).mDownloadText = "Downloading ...";
    oDownloadTextVisibity.MarkAllItemsModified();
    oDownloadTextVisibity.SendUpdate();
	//startTimer(15000, _screenTimer);
}*/
}


}
