/**************************************************************************************
* @file         : AudioTestMode.h
* @author       : RBEI/ECG5-INF4CV_Team
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*21.09.17 Rev. 0.1 Sonia Kulkarni (RBEI/ECH2)
* 		  			Initial Revision.
**************************************************************************************/

#ifndef AudioTestMode_H
#define AudioTestMode_H

#include "mascf_main_fiProxy.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_TestmodeDatabinding.h"
#include "AppHmi_TestmodeStateMachine.h"
#include "AppHmi_TestmodeMessages.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppBase/StartupSync/StartupSync.h"

namespace App {

namespace Core {

struct AudioProperties
{
   ::masc_main_fi_types::T_e8_DiagAudMode _diagAudMode;
   ::masc_main_fi_types::T_e8_GenericDiagAudMode _onVolLimiterMode;
   ::masc_main_fi_types::T_e8_GenericDiagAudMode _muteRampMode;
   ::masc_main_fi_types::T_e8_GenericDiagAudMode _volumeRampMode;
   ::masc_main_fi_types::T_e8_GenericDiagAudMode _clippingMode;
   ::masc_main_fi_types::T_e8_GenericDiagAudMode _presetMode;
};


class AudioTestMode :
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::mascf_main_fi::DiagAudModeCallbackIF,
   public ::mascf_main_fi::FMEnhancerModeCallbackIF
{
   public:

      AudioTestMode();
      //AudioTestMode(::boost::shared_ptr<mascf_main_fi::Mascf_main_fiProxy > _deviceConnect);
      virtual ~AudioTestMode();

      static AudioTestMode* poGetInstance()
      {
         if (NULL == _AudioTestModeInst)
         {
            _AudioTestModeInst = new AudioTestMode();
         }

         return _AudioTestModeInst;
      }

      bool onCourierMessage(const LinearAudioReqMsg& /*oMsg*/);
      bool onCourierMessage(const FMEnhancerReqMsg& /*oMsg*/);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(LinearAudioReqMsg)
      ON_COURIER_MESSAGE(FMEnhancerReqMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void sendAudioStatus(bool);
      void sendFMEnhancerStatus(bool);

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onDiagAudModeError(const ::boost::shared_ptr< mascf_main_fi::Mascf_main_fiProxy >& proxy, const ::boost::shared_ptr< mascf_main_fi::DiagAudModeError >& error);
      void onDiagAudModeStatus(const ::boost::shared_ptr< mascf_main_fi::Mascf_main_fiProxy >& proxy, const ::boost::shared_ptr< mascf_main_fi::DiagAudModeStatus >& status);

      void onFMEnhancerModeError(const ::boost::shared_ptr< mascf_main_fi::Mascf_main_fiProxy >& proxy, const ::boost::shared_ptr< mascf_main_fi::FMEnhancerModeError >& error);
      void onFMEnhancerModeStatus(const ::boost::shared_ptr< mascf_main_fi::Mascf_main_fiProxy >& proxy, const ::boost::shared_ptr< mascf_main_fi::FMEnhancerModeStatus >& status);
      DataBindingItem<AudioTestModeDataBindingSource> m_AudioTestModeData;

   private:

      bool _toggleLinearAudioStatus;
      bool _toggleFMEnhancerStatus;

      ::boost::shared_ptr<mascf_main_fi::Mascf_main_fiProxy> _mascfFiProxy;

      static AudioTestMode* _AudioTestModeInst;
};


}//end of namespace Core
}//end of namespace App


#endif
