/**************************************************************************************
* @file         : AudioTestMode.cpp
* @author       : RBEI/ECG5-INF4CV_Team
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*21.09.17 Rev. 0.1 Sonia Kulkarni (RBEI/ECH2)
* 		  			Initial Revision.
**************************************************************************************/

#include <hmibase/hall_std_if.h>
#include "AudioTestMode.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TESTMODE_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX                 App::Core::AudioTestMode::
#include "trcGenProj/Header/AudioTestMode.cpp.trc.h"
#endif

using namespace ::mascf_main_fi;

namespace App {

namespace Core {

AudioTestMode* AudioTestMode::_AudioTestModeInst = NULL;
AudioProperties _audioStatus;

AudioTestMode::~AudioTestMode()
{
   ETG_TRACE_USR4(("AudioTestMode: AudioTestMode destructor"));
   _mascfFiProxy.reset();
}


/**
* Default Constructor for AudioTestMode
* @param[in] None
*/
AudioTestMode::AudioTestMode()
{
   ETG_TRACE_USR4(("AudioTestMode: AudioTestMode Default Constructor"));
   _toggleLinearAudioStatus = false;
   _toggleFMEnhancerStatus = false;

   _mascfFiProxy = Mascf_main_fiProxy::createProxy("audioMascfFiPort", *this); //Creating the proxy for Mascf_main_fi to access Mascf_main_fi service
   if (_mascfFiProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _mascfFiProxy->getPortName());
      //ETG_TRACE_USR4(("AudioTestMode proxy created.......%d", _mascfFiProxy));
   }

   _audioStatus._diagAudMode = masc_main_fi_types::T_e8_DiagAudMode__AUDIO_DIAG_AUD_MODE_NOT_DEF;
   _audioStatus._onVolLimiterMode = masc_main_fi_types::T_e8_GenericDiagAudMode__NOT_DEFINED;
   _audioStatus._muteRampMode = masc_main_fi_types::T_e8_GenericDiagAudMode__NOT_DEFINED;
   _audioStatus._volumeRampMode = masc_main_fi_types::T_e8_GenericDiagAudMode__NOT_DEFINED;
   _audioStatus._clippingMode = masc_main_fi_types::T_e8_GenericDiagAudMode__NOT_DEFINED;
   _audioStatus._presetMode = masc_main_fi_types::T_e8_GenericDiagAudMode__NOT_DEFINED;
}


/************************************************************************
*FUNCTION		: onUnavailable
*DESCRIPTION	: Method called when MediaPlayer service is not availble
*PARAMETER		: proxy
*PARAMETER		: stateChange - state change service for corrosponding  proxy
*RETURNVALUE	: void
************************************************************************/
void AudioTestMode::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4(("AudioTestMode onUnavailable......."));
   _mascfFiProxy->sendDiagAudModeRelUpRegAll();
   _mascfFiProxy->sendFMEnhancerModeRelUpRegAll();
}


/************************************************************************
*FUNCTION		: onAvailable
*DESCRIPTION	: Method called when MediaPlayer service is availble
*PARAMETER		: proxy
*PARAMETER		: stateChange - state change service for corrosponding  proxy
*RETURNVALUE	: void
************************************************************************/

void AudioTestMode::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   //Add your code here
   // Register for all the properties from the service
   ETG_TRACE_USR4(("AudioTestMode onAvailable......."));
   _mascfFiProxy->sendDiagAudModeUpReg(*this);
   _mascfFiProxy->sendFMEnhancerModeUpReg(*this);
}


/**
* set Audio Status
* @param[in] Bool
* @param[out] None
*/
void AudioTestMode::sendAudioStatus(bool status)
{
   ETG_TRACE_USR4(("AudioTestMode: sendAudioStatus-entry printing status - %d ", status));
   if (status == true)
   {
      _audioStatus._diagAudMode = masc_main_fi_types::T_e8_DiagAudMode__AUDIO_DIAG_AUD_MODE_LINEAR_ON;
   }
   else
   {
      _audioStatus._diagAudMode = masc_main_fi_types::T_e8_DiagAudMode__AUDIO_DIAG_AUD_MODE_LINEAR_OFF;
   }

   (*m_AudioTestModeData).mLinearAudio = status;
   m_AudioTestModeData.MarkAllItemsModified();
   m_AudioTestModeData.SendUpdate(true);

   _mascfFiProxy->sendDiagAudModeSet(*this,
                                     _audioStatus._diagAudMode,
                                     _audioStatus._onVolLimiterMode,
                                     _audioStatus._muteRampMode,
                                     _audioStatus._volumeRampMode,
                                     _audioStatus._clippingMode,
                                     _audioStatus._presetMode);
}


/**
* set FM Enhancer Status
* @param[in] Bool
* @param[out] None
*/
void AudioTestMode::sendFMEnhancerStatus(bool status)
{
   ETG_TRACE_USR4(("AudioTestMode: sendFMEnhancerStatus-entry"));
   ETG_TRACE_USR4(("AudioTestMode: sendFMEnhancerStatus FMEnhancer Status : %d", status));
   _mascfFiProxy->sendFMEnhancerModeSet(*this, status);
}


/**
* send upreg property for mascf_fi connection notification
* @param[in] <proxy> mascf_fi proxy object
* @param[in] <stateChange> state information
*/
void AudioTestMode::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
}


/**
* send relregall property for mascf_fi connection notification
* @param[in] <proxy> mascf_fi proxy object
* @param[in] <stateChange> state information
*/
void AudioTestMode::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
}


/**
* receive error property message for mascf_fi connection notification
* @param[in] <proxy> mascf_fi proxy object
* @param[in] <error> error object in case of error
*/
void AudioTestMode::onDiagAudModeError(const ::boost::shared_ptr< mascf_main_fi::Mascf_main_fiProxy >& /*proxy*/, const ::boost::shared_ptr< mascf_main_fi::DiagAudModeError >& /*error*/)
{
   ETG_TRACE_ERR(("AudioTestMode: onDiagAudModeError --entry"));
}


/**
* receive status property message for mascf_fi connection notification
* @param[in] <proxy> mascf_fi proxy object
* @param[in] <status> status object if not error
*/
void AudioTestMode::onDiagAudModeStatus(const ::boost::shared_ptr< mascf_main_fi::Mascf_main_fiProxy >& proxy, const ::boost::shared_ptr< mascf_main_fi::DiagAudModeStatus >& status)
{
   ETG_TRACE_USR4(("AudioTestMode: onDiagAudModeStatus --entry"));
   if (proxy == _mascfFiProxy)
   {
      _audioStatus._diagAudMode = status->getDiagAudMode();
      _audioStatus._clippingMode = status->getClippingMode();
      _audioStatus._muteRampMode = status->getMuteRampMode();
      _audioStatus._onVolLimiterMode = status->getOnVolLimiterMode();
      _audioStatus._presetMode = status->getPresetMode();
      _audioStatus._volumeRampMode = status->getVolumeRampMode();

      ETG_TRACE_USR4(("DTMAudioClient: onDiagAudModeStatus invoked"));
      ETG_TRACE_USR4(("DTMAudioClient: _audioStatus._diagAudMode : %d" , _audioStatus._diagAudMode));
      ETG_TRACE_USR4(("DTMAudioClient: _audioStatus._onVolLimiterMode : %d" , _audioStatus._onVolLimiterMode));
      ETG_TRACE_USR4(("DTMAudioClient: _audioStatus._muteRampMode : %d" , _audioStatus._muteRampMode));
      ETG_TRACE_USR4(("DTMAudioClient: _audioStatus._volumeRampMode : %d" , _audioStatus._volumeRampMode));
      ETG_TRACE_USR4(("DTMAudioClient: _audioStatus._clippingMode : %d" , _audioStatus._clippingMode));
      ETG_TRACE_USR4(("DTMAudioClient: _audioStatus._presetMode : %d" , _audioStatus._presetMode));
   }
}


/**
* receive error property message for mascf_fi connection notification
* @param[in] <proxy> mascf_fi proxy object
* @param[in] <error> error object in case error
*/
void AudioTestMode::onFMEnhancerModeError(const ::boost::shared_ptr< mascf_main_fi::Mascf_main_fiProxy >& /*proxy*/, const ::boost::shared_ptr< mascf_main_fi::FMEnhancerModeError >& /*error*/)
{
   ETG_TRACE_ERR(("AudioTestMode: onFMEnhancerModeError --entry"));
}


/**
* receive status property message for mascf_fi connection notification
* @param[in] <proxy> mascf_fi proxy object
* @param[in] <status> status object if not error
*/
void AudioTestMode::onFMEnhancerModeStatus(const ::boost::shared_ptr< mascf_main_fi::Mascf_main_fiProxy >& /*proxy*/, const ::boost::shared_ptr< mascf_main_fi::FMEnhancerModeStatus >& status)
{
   ETG_TRACE_USR4(("AudioTestMode: onFMEnhancerModeStatus --entry"));
   ETG_TRACE_USR4(("AudioTestMode: FMEnhancer Status : %d", status->getFMEnhancer()));

   (*m_AudioTestModeData).mFMEnhancer = status->getFMEnhancer();
   m_AudioTestModeData.MarkAllItemsModified();
   m_AudioTestModeData.SendUpdate(true);
}


bool AudioTestMode::onCourierMessage(const LinearAudioReqMsg& /*oMsg*/)
{
   ETG_TRACE_USR4(("AudioTestMode:onCourierMessage : LinearAudioReqMsg "));
   bool retVal = false;
   if (_toggleLinearAudioStatus == false)
   {
      _toggleLinearAudioStatus = true;
   }
   else
   {
      _toggleLinearAudioStatus = false;
   }
   //Set the audio Toggle Status
   sendAudioStatus(_toggleLinearAudioStatus);
   return retVal;
}


bool AudioTestMode::onCourierMessage(const FMEnhancerReqMsg& /*oMsg*/)
{
   ETG_TRACE_USR4(("DTMAudioList:onCourierMessage : EnableDisableFMEnhancerReqMsg "));
   bool retVal = false;
   if (_toggleFMEnhancerStatus == false)
   {
      _toggleFMEnhancerStatus = true;
   }
   else
   {
      _toggleFMEnhancerStatus = false;
   }
   sendFMEnhancerStatus(_toggleFMEnhancerStatus);
   return retVal;
}


}//end of namespace Core
}//end of namespace App
