/* ***************************************************************************************
* FILE:          CGIAppViewController_System.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewController_System.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined (_CGIAPPVIEWCONTROLLER_SYSTEM_H)
#define _CGIAPPVIEWCONTROLLER_SYSTEM_H

//#include "AppHmi_System_SimpleViewController.h"
#include "CgiExtensions/ViewControllerBase.h"

#define SIMPLE_CONTROLLER(tController)\
		class tController : public ViewControllerBase\
								{\
		private:\
				courier_messages:\
		COURIER_MSG_MAP_BEGIN(0)\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()\
      COURIER_MSG_MAP_ENDS()\
		public:\
static const char* _name;\
		tController() {}\
		virtual ~tController() {}\
		static Courier::ViewController* createInstance()\
								{\
			return COURIER_NEW(tController)();\
								}\
								};
SIMPLE_CONTROLLER(CGIAppViewController_S_AS)
SIMPLE_CONTROLLER(CGIAppViewController_S_AS_SpeedDepVol)
SIMPLE_CONTROLLER(CGIAppViewController_S_AS_EqlPrst)
SIMPLE_CONTROLLER(CGIAppViewController_S_AS_PrivateMode)
SIMPLE_CONTROLLER(CGIAppViewController_S_CS_Manual)
SIMPLE_CONTROLLER(CGIAppViewController_S_CS_DateFmt)
SIMPLE_CONTROLLER(CGIAppViewController_S_SO_DTCInformation)

SIMPLE_CONTROLLER(CGIAppViewController_S_SO_ConfigurationVersion)

SIMPLE_CONTROLLER(CGIAppViewController_S_CS_TimeZone)
SIMPLE_CONTROLLER(CGIAppViewController_S_SO_SysSettings_CA)
SIMPLE_CONTROLLER(CGIAppViewController_S_SO_GlassSettings_CA)
SIMPLE_CONTROLLER(CGIAppViewController_S_SO_AudioSettings_CA)
SIMPLE_CONTROLLER(CGIAppViewController_S_SO_VideoMixSource_CA)
SIMPLE_CONTROLLER(CGIAppViewController_S_SO_SysSettings_CB)
SIMPLE_CONTROLLER(CGIAppViewController_S_DS)
SIMPLE_CONTROLLER(CGIAppViewController_S_BS)
SIMPLE_CONTROLLER(CGIAppViewController_S_OSS)
SIMPLE_CONTROLLER(CGIAppViewController_S_LS_EU)
SIMPLE_CONTROLLER(CGIAppViewController_S_SystemSettings)
SIMPLE_CONTROLLER(CGIAppViewController_S_SW_screen_1)
SIMPLE_CONTROLLER(CGIAppViewController_S_screen_3)
SIMPLE_CONTROLLER(CGIAppViewController_S_screen_4)
SIMPLE_CONTROLLER(CGIAppViewController_S_screen_5)
SIMPLE_CONTROLLER(CGIAppViewController_S_screen_6)
SIMPLE_CONTROLLER(CGIAppViewController_S_Busy_screen)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_SoftwareVersionFetchingError)
SIMPLE_CONTROLLER(CGIAppViewController_S_PopUp_three_line_single_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_PopUp_three_line_three_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_PopUp_two_line_single_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_PopUp_two_line_two_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_PopUp_three_line_two_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_Popup_Four_line_single_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_PopUp_five_line_double_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_PopUp_six_line_two_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_PopUp_three_line_single_reboot_button)
SIMPLE_CONTROLLER(CGIAppViewController_S_MIS_SystemUpdate_Progress)
SIMPLE_CONTROLLER(CGIAppViewController_S_Stage_1_MIS_SystemUpdate)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_SysSetFactDefault)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_three_line_two_button_Swivel_GS_CA) ////GSpopup
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_three_line_Swivel_GS_CA)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_SysSetFactReset)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_SysSetSupplierReset)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_CabinAMonConnection)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_PrivateModeAudioSetting)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_SpeedLock_CP)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_SwivelCalibration)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_SysInst_SubSys_Unavailable)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_SystemInstallation)
SIMPLE_CONTROLLER(CGIAppViewController_Pin_Layout)
SIMPLE_CONTROLLER(CGIAppViewController_S_SO_OEM_PIN)
SIMPLE_CONTROLLER(CGIAppViewController_S_Pfo_2LineAbortStage2)
#endif // _CGIAPPVIEWCONTROLLER_SYSTEM_H
