/* ***************************************************************************************
* FILE:          CGIAppController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CGIAPPCONTROLLER_H
#define CGIAPPCONTROLLER_H

#include "Common/CGIAppController/CGIAppControllerProject.h"

class CGIAppController : public CGIAppControllerProject
{
   courier_messages:
      //COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_CTRL_COMP)
      COURIER_MSG_MAP_BEGIN(0)
      COURIER_CASE_DUMMY_ENTRY()
      ON_COURIER_MESSAGE(HKStatusChangedUpdMsg)
      ON_COURIER_MESSAGE(RenderingCompleteMsg)
      ON_COURIER_MESSAGE(EncoderStatusChangedUpdMsg)
      COURIER_MSG_MAP_END_DELEGATE(CGIAppControllerProject)
   public:
      using CGIAppControllerProject::onCourierMessage;
      CGIAppController(hmibase::services::hmiappctrl::ProxyHandler& proxyHandler) : CGIAppControllerProject(proxyHandler) {}
      virtual bool onCourierMessage(const HKStatusChangedUpdMsg& msg);
      virtual bool onCourierMessage(const RenderingCompleteMsg& msg);
      virtual bool onCourierMessage(const EncoderStatusChangedUpdMsg& msg);
};


#endif // CGIAPPCONTROLLER_H
