/**
 * @addtogroup <AppHmi_System>
 * @{
 * @file        SystemDataPoolConfig.h
 * @brief       SystemDataPoolConfig is to handle logic implementation of datapool(system app) properties.
 * @author      Sathiya Jayanth R INF4CV
 * @copyright   (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 * @}
 */

#ifndef SYSTEM_DATAPOOLCONFIG_H
#define SYSTEM_DATAPOOLCONFIG_H
/*
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_05_if.h"
#include "dp_generic_if.h"
#include "dp_hmi_02_if.h"
#endif*/


#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_02_if.h"
#include "dp_generic_if.h"
#include "dp_cdcvd_if.h"

#endif

#define SYS_STATIC_CLASS(_class_)             \
      _class_();                              \
      _class_(const _class_& obj);            \
      _class_& operator=(const _class_& obj);


#define SYS_DELETE_CLASS(_ptr_)         \
      if(NULL != _ptr_)                 \
      {                                 \
         delete _ptr_;                  \
         _ptr_ = NULL;                  \
      }

namespace App {
namespace Core {

//namespace SystemDataPool {


/**
 * class SystemDataPoolConfig is used to hold implementation related to Datapool elements.  (Method: SingleTon)
 *  - It provides interfaces to read/write DP elements
 */
class SystemDataPoolConfig
{
   public:

      /**
          *  Member Function Declaration
          */
      virtual ~SystemDataPoolConfig();
      static SystemDataPoolConfig* getInstance();
      static void createInstance();
      static void deleteInstance();

      /*   void readInitialSettings();
       uint8 getDpLanguageValue();
        bool getDpBeepToneStatus();
      void setDpLanguageValue(const uint8 languageReceived);
        uint8 getDpSystemCurrentMeasurementUnit();
        uint8 getDpBrightnessLevelDayMode();
        uint8 getDpBrightnessLevelNightMode();
        uint8 getDpSpeedLockStatus();*/

      void setRVCBrightnessValue(uint8 rvcbrightnesvalue);
      uint8 getRVCBrightnessValue();

      void setRVCContrastValue(uint8 rvccontrastvalue);
      uint8 getRVCContrastValue();

      void setMICBeepVol(uint8 setMICBeepVol);
      uint16 getMICBeepVol();

      void setSWUpdateTypeValue(uint8 swupdatetypevalue);
      uint8 getSWUpdateTypeValue();

   private:

      SYS_STATIC_CLASS(SystemDataPoolConfig)
      dp_tclAppHmi_SystemCAA_MicBeepVolValue _MicBeepVolVal;
      dp_tclAppHmi_SystemSWUpdateTypeValue _SWUpdateTypeValue;

      /* dp_tclAppHmi_SystemLanguageCode _mDpLanguageStatus;
       dp_tclAppHmi_SystemBeepToneStatus _mDpBeepToneStatus;
       dp_tclAppHmi_SystemCurrentMeasUnit  _mSystemCurrentMeasUnit;
       dp_tclAppHmi_SystemDISP_BrightnessLevelDayMode  _mBrightnessLevelDayMode;
       dp_tclAppHmi_SystemDISP_BrightnessLevelNightMode _mBrightnessLevelNightMode;
       dp_tclAppHmi_SystemSpeedLockStatus  _mSystemSpeedLockStatus;
       uint8 _languageIndex;
       bool _BeepStatus;
       uint8 _CurrentMeasurementUnit;
       uint8 _BrightnesslevelDayMode;
       uint8 _BrightnesslevelNightMode;
       uint8 _Systemlockstatus;*/
};


}
}


//}

#endif
