/**************************************************************************************
* @file         : <XMLParser.h>
* @author       : <Ramesh Kesavan> <ECH> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef XMLPARSER
#define XMLPARSER

#include <map>
#include <vector>
#include <string>
#include "tinystr.h"
#include "tinyxml.h"

using namespace std;
namespace App {
namespace Core {

enum enUpdateResult
{
   Updated,
   ConnectFail,
   Equal,
   SecAccFail,
   PrepFail,
   TransferFail,
   SignalFail,
   InstFail,
   Timedout,
   ReconnectFail,
   Unknown
};


class UpdReport
{
   public:
      UpdReport() : nameStr(""), resultStr(""), isUpdateSuccess(false)
      {
      }
      ~UpdReport() {}

      string nameStr;
      string resultStr;
      bool isUpdateSuccess;
};


class ConfigurationVersionItems
{
   public:
      ConfigurationVersionItems() : ConfigStr(" "), ConfigVal(" "), isConfigSuccess(false)
      {
      }
      ~ConfigurationVersionItems() {}

      string ConfigStr;
      string ConfigVal;
      bool isConfigSuccess;
};


class SWUpdateReport
{
   public:
      SWUpdateReport() : nameStr(""), serialnumberStr(""), macAddressStr("")
      {
      }
      ~SWUpdateReport() {}

      string nameStr;
      string serialnumberStr;
      string macAddressStr;
};


////New XML Adaption////

typedef struct
{
   string dtcCode;
   string dtcStatus;
} DTC;

typedef struct
{
   string subSystemName;
   vector<DTC> dtc;
} DTCInfo;


////New XML Adaption////

class XMLDocParser
{
   public:
      static XMLDocParser* m_xmlParser;
      static XMLDocParser* GetInstance();
      virtual ~XMLDocParser();
      TiXmlDocument _xmlDoc;
      TiXmlDocument _xmlInstallResultDoc;

      TiXmlDocument _xmlDtcInstallaedCodeStatusDoc;
      TiXmlDocument _xmlSystemInstallResultDoc;
      TiXmlDocument _xmlDtcCodeStatusDoc;

      TiXmlDocument xmlConfigVerCISnetworkDoc;      //pointer 1
      TiXmlDocument xmlConfigVerDoIpcInstallResultDoc;	//pointer 2

      int GetNecessaryInfo(TiXmlNode*, int);
      string ComponentMappingStr(string instr, bool IsEnumStr);
      int ExractTagInformation(TiXmlElement* pElement);

      //Task 1012776 and CRQ 952224

      int ExtractDTCTagInformation(TiXmlElement* pElement, const char* _deviceNameInExtTagInfo, int NodeIndex);
      int GetNecessaryInfo_DTC(TiXmlNode* pParent, int NodeEnum, const char* _deviceName, int NodeIndex);

      int GetTotalNodeInfo(TiXmlNode* pParent, int NodeEnum);
      int FetchTotalNodeNumberInfo();

      std::vector<UpdReport> GetDTCAmpResultUpdates();
      std::vector<UpdReport> GetDTCCMPResultUpdates();
      std::vector<UpdReport> GetDTCCMGAVBResultUpdates();
      std::vector<UpdReport> GetDTCCMG1ResultUpdates();

      bool FetchConfigurationVersionCisNetworkXml();
      bool FetchConfigurationVersionDoIpcInstallResultXml();

      bool FetchDtcXmlUpdateResults();
      bool FetchInstalledDTCResult();
      std::vector <UpdReport> GetResultUpdates();
      std::vector <UpdReport> GetCISResultUpdates();
      std::vector <SWUpdateReport> GetSerialandMACAddress();

      std::vector<const char*> GetDTCAmpCodeResultUpdates();
      std::vector<const char*> GetDTCAmpStatusResultUpdates();

      std::vector<const char*> GetDTCCMPCodeResultUpdates();
      std::vector<const char*> GetDTCCMPStatResultUpdates();

      std::vector<const char*> GetDTCCMGAVBCodeResultUpdates();
      std::vector<const char*> GetDTCCMGAVBStatResultUpdates();

      std::vector<const char*> GetDTCCMG1CodeResultUpdates();
      std::vector<const char*> GetDTCCMG1StatResultUpdates();

      std::vector<DTCInfo> GetDTCInfo();

      //Task 1012776 and CRQ 952224

      bool FetchUpdateResults();
      bool FetchInstallResult();
      bool FetchSystemInstallResult();

      uint32 GetStageOneEstimatedTime();
      std::string GetInstallationResultStatus();
      ConfigurationVersionItems  congVerCisNetworkObj; //struct variable 2 items
      ConfigurationVersionItems  congVerdoipcinstallObj; //items

      std::vector<ConfigurationVersionItems> GetConfigurationVersionCisNetworkData(); //Function to retrive the vector variable Data  of type struct ConfigurationVersionItems
      std::vector<ConfigurationVersionItems> GetConfigurationVersionDoIpcInstallData(); //Function to retrive the vector variable Data  of type struct ConfigurationVersionItems
      XMLDocParser();
   private:
      // Singleton

      std::vector<UpdReport> _statusReportVec;
      std::vector<UpdReport> _CISstatusReportVec;
      std::vector<SWUpdateReport> _SerialandMACAddressReportVec;
      std::vector<ConfigurationVersionItems> _confgVerCisNetworkVecItem; //vector variable of type struct ConfigurationVersionItems
      std::vector<ConfigurationVersionItems> _confgVerdoipcinstallVecItem; //vector variable of type struct ConfigurationVersionItems
      uint32 _stageOneEstimatedTime;
      std::string _Status_Str;

      // For sw update XML validation
      uint8 _nodeTagCounter;
      uint8 _gidAtrribCounter;
      uint8 _updateResultAtrribCounter;
      uint8 _SWVersionAtrribCounter;
      uint8 _DeviceNameAtrribCounter;
      uint8 _SerialnumberCounter;
      uint8 _MACaddressCounter;
      int _dtcCounter;

      bool _isNodeTagAvailable;

      const char* _deviceName;


//Task 1012776 and CRQ 952224

      bool _isTesterTagAvailable;
      bool _isSuccess;
      bool isValidItem;

      int NodeIndex;

      vector<DTCInfo> vecDTCInformation;
      DTCInfo _DTCinfo;
      DTC _dtc;
};


}
}


#endif
