/**************************************************************************************
* @file         : <SWUpdateUtility.h>
* @author       : <Ramesh Kesavan> <ECH> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef SWUPDATE_UTILITY_H
#define SWUPDATE_UTILITY_H

#include "asf/core/Types.h"
#include <map>
#include <vector>
#include <string>

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
struct swUpdateHisDetails
{
   std::string submodule;
   std::string submoduleversion;
   std::string devicename;
   std::string modulename;
   swUpdateHisDetails() :
      submodule(""),
      submoduleversion(""),
      devicename(""),
      modulename("")
   {
   }
};


/**
* Enumeration used to represent the update Option
*/
enum UpdOptions
{
   UpdOptions_NewOnly = 0u,
   UpdOptions_DifferentOnly = 1u,
   UpdOptions_Any = 2u,
   UpdOptions_NewAndSameOnly = 4u
};


/**
*  ReleaseDocInfo -To store ReleaseDoc property Information on Property Update
*/
struct ReleaseDocInfo
{
   std::string releaseName;
   std::string targetVersion;
   bool needFlashing;
   uint32 estimatedTime;
   uint8 filterOption;
   uint8 UpdateDirection;
   uint8 sourceType;
};


struct swDetailsInfo
{
   std::string subModuleName;
   std::string currentVersion;
   std::string mediaVersion;
   swDetailsInfo() :
      subModuleName(""),
      currentVersion(""),
      mediaVersion("")
   {
   }
};


/**
*  EstimatedTime - To get the expected estimated time info
*/
enum EstimatedTime
{
   ESTIMATED_TOTAL_TIME,
   ESTIMATED_HOURS,
   ESTIMATED_MINUTES
};


#endif

/**
* Enumeration used to store Error Type
*/
enum ErrorType
{
   error_default_SWL_OK = 0,  // similar to tenErrorId Enumeration in FcSwUpdateSrvConst.h file
   error_incompatible_stick = 1, //Value starting from 1 since, By Default the onUpdateErrorsUpdate is 0.
   error_unavailable_stick,
   error_removed_stick,
   error_downgrade_stick,
   error_samegrade_stick,
   error_incompatible_usb_format
};


namespace App {
namespace Core {


class SWUpdateUtility
{
   public:
      virtual~SWUpdateUtility();
      SWUpdateUtility();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      std::string getEstimatedTime(uint32 estimatedTime, uint8 item);
      std::string itoa(int16) const;
      std::string ltoa(uint64) const;
      std::string itoa(uint8, uint8) const;
      std::string replaceInTranslationTextID(std::string, std::string, std::string);
#endif
      bool isSameVersion(uint8);
};


}
}


#endif // SWUPDATE_UTILITY_H
