/**************************************************************************************
* @file         : PopupTimer.cpp
* @author       : ECH Ramesh Kesavan
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifdef _MSC_VER
#include "gui_std_if.h"
#else
#include "hall_std_if.h"
#endif
#include "PopupTimer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 PopupTimerHandler::PopupTimer
#include "trcGenProj/Header/PopupTimer.cpp.trc.h"
#endif

using namespace Util;

namespace PopupTimerHandler {
PopupTimer::PopupTimer()
{
}


PopupTimer::~PopupTimer()
{
   _popupTimerMap.clear();
}


void PopupTimer::deletepopupTimer(::Util::Timer* popupTimer)
{
   if (popupTimer != NULL)
   {
      popupTimer->stop();
      delete popupTimer;
   }
}


bool PopupTimer::onCourierMessage(const StartPopupTimerReqMsg& oMsg)
{
   ETG_TRACE_USR4(("PopupTimer::StartPopupTimerReqMsg is called"));
   bool bRet = false;
   ::Util::Timer* popupTimer;
   uint32_t viewId = oMsg.GetViewId();
   uint32_t timerValue = oMsg.GetTimeout();
   ETG_TRACE_USR4(("PopupTimer::StartPopupTimerReqMsg starting the Timer for viewId : %d", viewId));
   ETG_TRACE_USR4(("PopupTimer::StartPopupTimerReqMsg starting the Timer for viewId : %d", timerValue));
   ::std::map<uint32_t, ::Util::Timer*>::const_iterator itr;

   //if timer exist then stop before start
   itr = _popupTimerMap.find(viewId);
   if (itr != _popupTimerMap.end())
   {
      deletepopupTimer(itr->second);
      _popupTimerMap.erase(viewId);
   }

   //start the timer
   popupTimer = new Timer(timerValue);
   if (popupTimer != NULL)
   {
      ETG_TRACE_USR4(("PopupTimer::StartPopupTimerReqMsg starting the Timer"));
      popupTimer->start();
      _popupTimerMap[viewId] = popupTimer; //todo:
      bRet = true;
   }
   return bRet;
}


bool PopupTimer::onCourierMessage(const StopPopupTimerReqMsg& oMsg)
{
   ETG_TRACE_USR4(("PopupTimer::StopPopupTimerReqMsg is called"));
   bool bRet = false;
   ::Util::Timer* popupTimer;
   uint32_t viewId = oMsg.GetViewId();

   ::std::map<uint32_t, ::Util::Timer*>::const_iterator itr = _popupTimerMap.find(viewId);
   if (itr != _popupTimerMap.end())
   {
      ETG_TRACE_USR4(("PopupTimer::StopPopupTimerReqMsg is called - Deleting PopupTimer"));
      popupTimer = itr->second;
      //remove from map
      _popupTimerMap.erase(itr->first);

      // As a part of Stop, Sending expired notification for other if they are waitong on this message
      POST_MSG((COURIER_MESSAGE_NEW(ExpiredPopupTimerResMsg)(viewId)));

      deletepopupTimer(popupTimer);
      ETG_TRACE_USR4(("PopupTimer::StopPopupTimerReqMsg is called - deleted PopupTimer"));
   }
   return bRet;
}


bool PopupTimer::onCourierMessage(const RestartPopupTimerReqMsg& oMsg)
{
   bool bRet = false;
   ::std::map<uint32_t, ::Util::Timer*>::const_iterator itr = _popupTimerMap.find(oMsg.GetViewId());
   if ((itr != _popupTimerMap.end()) && (NULL != itr->second))
   {
      itr->second->restart();
      bRet = true;
   }
   return bRet;
}


uint32_t PopupTimer::getViewName(::Util::Timer* popupTimerval)
{
   // Iterate through all elements and search for view name
   std::map<uint32_t, ::Util::Timer*>::iterator it = _popupTimerMap.begin();
   while (it != _popupTimerMap.end())
   {
      if (it->second == popupTimerval)
      {
         return it->first;
      }
      it++;
   }
   return 0;
}


bool PopupTimer::onCourierMessage(const TimerExpiredMsg& oMsg)
{
   ETG_TRACE_USR4(("PopupTimer::TimerExpiredMsg is called"));
   bool bRet = false;
   ::Util::Timer* popupTimer = oMsg.GetTimer();
   if (popupTimer != NULL)
   {
      uint32_t viewId = getViewName(popupTimer);
      //Check the received timer is created by Popup timer, if it is true then consume the TimerExpiredMsg
      // otherwiese send the TimerExpiredMsg to others -sve2cob
      if (viewId != 0)
      {
         ETG_TRACE_USR4(("PopupTimer::StartPopupTimerReqMsg Timer Expired"));
         POST_MSG((COURIER_MESSAGE_NEW(ExpiredPopupTimerResMsg)(viewId)));
         deletepopupTimer(popupTimer);
         _popupTimerMap.erase(viewId);
         bRet = true;
      }
   }
   return bRet;
}


}
