/**************************************************************************************
* @file         : <ClockUtility.cpp>
* @author       : <Monisha Venkatakrishnan> <ECH2> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2021 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hmi_trace_if.h"
#endif

#include "ClockUtility.h"
#include "../../AppLogic/ClockSettings/ClockSettings.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::ClockUtility::
#include "trcGenProj/Header/ClockUtility.cpp.trc.h"
#endif

namespace App {
namespace Core {

/**
* @Constructor
*/
ClockUtility::ClockUtility()
{
}


/**
* @Destructor
*/
ClockUtility::~ClockUtility()
{
}


/**
 * convert12To24h - To convert hr value from 12h to 24h format
 * @param[in] currentHourValue, clockMode
 * @parm[out] updatedHourValue
 * @return int
 *
 */
int ClockUtility::convert12To24h(int currentHourValue, int clockMode)
{
   int updatedHourValue = currentHourValue;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_COMP(("ClockUtility::convert12To24h: clockMode = %d", clockMode));
#endif
   if (currentHourValue == 12 && clockMode == CLOCK_C_AM)
   {
      updatedHourValue = 0;
   }
   if (currentHourValue >= 1 && currentHourValue <= 11 && clockMode == CLOCK_C_PM)
   {
      updatedHourValue = currentHourValue + 12;
   }
   if (currentHourValue <= 0 || currentHourValue > 12)
   {
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      updatedHourValue = INVALID;
#endif
   }
   return updatedHourValue;
}


/**
 * getMinutesValue - To increment/ decrement minute value according to the button pressed
 * @param[in] btnType, minutes
 * @parm[out] minuteValue
 * @return uint8
 *
 */
uint8 ClockUtility::getMinutesValue(int minutes, int btnType)
{
   uint8 minuteValue = 0;
   if (btnType == COLUMN_BUTTON_PLUS)
   {
      minuteValue = static_cast<uint8>(++minutes);
      if (minuteValue == 60)
      {
         minuteValue = 00;
      }
      if (minutes < 1 || minutes > 60)
      {
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
         minuteValue = INVALID;
#endif
      }
   }
   else if (btnType == COLUMN_BUTTON_MINUS)
   {
      if (minutes == 0)
      {
         minuteValue = 59;
      }
      else if (minutes < 0 || minutes >= 60)
      {
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
         minuteValue = INVALID;
#endif
      }
      else
      {
         minuteValue = static_cast<uint8>(--minutes);
      }
   }
   return minuteValue;
}


/**
*  convert24To12h - To convert hr value from 24h to 12h format
* @param[in] currentHr
* @parm[out] covertedHr
* @return int
*/
int ClockUtility::convert24To12h(int currentHr)
{
   int covertedHr = currentHr;
   if (currentHr == 0)
   {
      covertedHr = 12;
   }
   else if (currentHr < 0 || currentHr > 23)
   {
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      covertedHr = INVALID;
#endif
   }
   else if (currentHr > 12)
   {
      covertedHr = currentHr - 12;
   }
   return covertedHr;
}


/**
* getClockMode- To set clock mode according to the hr value
* @param[in] hours
* @parm[out] clockMode
* @return int
*/
int ClockUtility::getClockMode(int hours)
{
   int clockMode = 0;
   if (hours < 0 || hours > 23)
   {
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      clockMode = INVALID ;
#endif
   }
   else if (hours <= 11)
   {
      clockMode = CLOCK_C_AM ;
   }
   else if (hours >= 12 && hours <= 23)
   {
      clockMode = CLOCK_C_PM ;
   }
   return clockMode;
}


}
}
