/**************************************************************************************
* @file         : <CabinAUtility.cpp>
* @author       : <Monisha Venkatakrishnan> <ECH2> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2021 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hmi_trace_if.h"
#endif

#include "CabinAUtility.h"
#include "../../AppLogic/CabinA/CabinASettingListhandler/CabinAAudioSettingListHandler/CabinAAudioSettingListHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::CabinAUtility::
#include "trcGenProj/Header/CabinAUtility.cpp.trc.h"
#endif

namespace App {
namespace Core {

/**
* @Constructor
*/
CabinAUtility::CabinAUtility()
{
}


/**
* @Destructor
*/
CabinAUtility::~CabinAUtility()
{
}


/**
 * updateVolumeValue - To increment/decrement volume value accordingly
 * @param[in] btnType, volumeValue
 * @parm[out] updatedvolumeValue
 * @return int
 *
 */
int CabinAUtility::updateVolumeValue(int btnType, int16 volumeValue)
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_COMP(("CabinAUtility::updateVolumeValue: volumeValue = %d", volumeValue));
#endif
   int updatedVolumeValue;
   if ((btnType == COLUMN_BUTTON_PLUS) && ((volumeValue < 10) && (volumeValue >= 0)))
   {
      ++volumeValue;
   }
   else if ((btnType == COLUMN_BUTTON_MINUS) && ((volumeValue > 0) && (volumeValue <= 10)))
   {
      --volumeValue;
   }
   else
   {
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      volumeValue = INVALID;
#endif
   }
   updatedVolumeValue = volumeValue;
   return updatedVolumeValue;
}


}
}
