/* ***************************************************************************************
* FILE:          SystemHall.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SystemHall.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef SystemHall_h
#define SystemHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"
#include "App/Core/ClientHandler/Display/DisplaySrvClient.h"
//#include "App/Core/ClientHandler/SystemCourierMsgHandler.h"
#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
#include "App/Core/ClientHandler/ClockSrvClient/ClockSrvClient.h"
#include "App/Core/ClientHandler/Diagnosis/MIDWDiagnosis.h"
#include "App/Core/ClientHandler/SpeedLock/HmiDataServiceClientHandler.h"
#include "App/Core/ClientHandler/SpeedLock/Stub/HmiDataStubHandler.h"
#include "App/Core/ClientHandler/HmiState/HmiStateHandler.h"
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
#include "App/Core/AppLogic/CabinA/CabinASettingListhandler/CabinASettingListhandler.h"
#include "App/Core/AppLogic/CabinA/CabinASettingListhandler/CabinAGlassSettingListhandler/CabinAGlassSettingListhandler.h"
#include "App/Core/AppLogic/CabinA/CabinASettingListhandler/CabinAVideoMixSourceListHandler/CabinAVideoMixSourceListHandler.h"
#include "App/Core/AppLogic/CabinA/CabinASettingListhandler/CabinAGlassSettingListhandler/CabinASwivelCalibration/CabinASwivelCalibration.h"
#include "App/Core/AppLogic/CabinA/CabinASettingListhandler/CabinAAudioSettingListHandler/CabinAAudioSettingListHandler.h"
#include "App/Core/AppLogic/SoftwareUpdate/DTCInfoCodeStatus4AllSubSM/DTCInfoCodeStatus4AllSubSM.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
#include "App/Core/AppLogic/CabinB/CabinBSettingListhandler/CabinBSettingListhandler.h"
#endif
#include "App/Core/AppLogic/RVCSettingListHandler/RVCSettingListHandler.h"
//#include "App/Core/AppLogic/RVCSettingListHandler/RVCSettingListHandler.cpp"
#include "App/Core/AppLogic/RVCSettingListHandler/RVCContrastHandler/RVCContrastHandler.h"
//#include "App/Core/AppLogic/RVCSettingListHandler/RVCContrastHandler/RVCContrastHandler.cpp"
#include "App/Core/AppLogic/RVCSettingListHandler/RVCBrightnessHandler/RVCBrightnessHandler.h"
//#include "App/Core/AppLogic/RVCSettingListHandler/RVCBrightnessHandler/RVCBrightnessHandler.cpp"
#include "App/Core/AppLogic/DisplaySettings/DisplaySettings.h"
#include "App/Core/AppLogic/AudioSettingListHandler/AudioSpdDepdentVolCntrlRBtn/AudioSpdDepdentVolCntrlRBtn.h"
#include "App/Core/AppLogic/AudioSettingListHandler/AudioPrivateModeRBtn/AudioPrivateModeRBtn.h"
#include "App/Core/AppLogic/AudioSettingListHandler/AudioEqlPrstRBtn/AudioEqlPrstRBtn.h"
#include "App/Core/AppLogic/ClockSettings/ClockDateFormat/ClockDateFormatRbtn.h"
#include "App/Core/AppLogic/MicSettings/MicSetting.h"
#include "App/Core/AppLogic/OEM/OEMmenu.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
//#include "App/Core/AppLogic/BluetoothSetting/BluetoothFormatRbtn.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_SystemStateMachine.h"
#endif
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemMessages.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "App/Core/ClientHandler/RVC/RearViewCamera.h"
#include "App/datapool/SystemDataPoolConfig.h"
// #include "ClockDateFormatRbtn.h"
#include "SystemSettingsListHandler.h"
#include "AudioSettingListHandler.h"
#include "App/Core/AppLogic/ConfigurationVersion/ConfigurationVersion.h"
#include "App/Core/AppLogic/ClockSettings/ClockSettings.h"
#include "App/Core/AppLogic/ClockSettings/GpsClockListHandler.h"

// Software update inculde headers
#include "App/Core/ClientHandler/DownloadSrvClient/SWUpdateClient.h"
#include "App/Core/AppLogic/SoftwareUpdate/SWUpdate.h"
#include "App/Core/Utils/PopupTimer/PopupTimer.h"
#include "App/Core/SoftwareUpdateListHandler/SoftwareUpdateListHandler.h"
#include "App/Core/ClientHandler/Diagnosis/DiagnosisServiceClientHandler.h"
#include "App/Core/ClientHandler/Diagnosis/DiagnosisSrvClient/DiagnosisSrvClient.h"
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
#include "App/Core/ClientHandler/BTSrvClient/ServiceBT.h"
#include "App/Core/ClientHandler/NavigationSrvClient/NavigationServiceClient.h"
//#include "App/Core/AppLogic/BluetoothSetting/BluetoothFormatRbtn.h"
#endif
#include "NaftaLanguageSettingListHandler.h"
#include "App/Core/ClientHandler/SPM/SpmSrvClient.h"

#include "App/Core/ClientHandler/CabinInfoSrvClient/CabinInfoSrvClient.h"
#include "LanguageSettingListHandler.h"
#include "App/Core/System_Types.h"
#include "AppHmi_SystemMessages.h"
//applicationSwitch changes
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "Common/PluginClientHandler/PluginClientHandler.h"

#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include <Adapter/LanguageHandlerAdapter.h>


using namespace PopupTimerHandler;
namespace App {
namespace Core {


class SystemHall:
   public HallComponentBase,
   public ActiveRegionIdCallbackIF,
   public Sig_ActivateContextCallbackIF,
   public RequestContextSwitchCallbackIF,
   public SendContextCallbackIF
   , public ::languageHandler::LanguageHandlerAdapter

{
   public:
      SystemHall();
      virtual ~SystemHall();

      // TimerCallbackIF
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      static void TraceCmd_SystemSettingsTrigger(bool i);
      static void TraceCmd_IlluminationControl(int i);
      static void TraceCmd_SpeedVolumeControl(int i);
      virtual bool onCourierMessage(const SwitchApplicationReq& oMsg);
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
      virtual bool onCourierMessage(const SwitchCabin_A_ApplicationReq& oMsg);
#endif
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
      virtual bool onCourierMessage(const SwitchCabin_B_ApplicationReq& oMsg);

#endif

      virtual bool onCourierMessage(const MediaRadioBack4mAudio& Msg);
      virtual bool onCourierMessage(const VideoMixedSourceBack4mCabinHome& Msg);
      virtual bool onCourierMessage(const SettingSceneMsg& oMsg);
      // SWDL forward context switch request from Any Scene to SWDL inProgress, on trigger from SWDL middleware,or marker file presence
      virtual bool onCourierMessage(const RequestMISupdateContextSwitchMsg& oMsg);

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);
      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);
      virtual void onRequestContextSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchError >& error);
      virtual void onRequestContextSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchResponse >& response);

      virtual void onSendContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextError >& error);
      virtual void onSendContextResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextResponse >& response);
      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                         const ::boost::shared_ptr< ActiveRegionIdError >& error);

      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                          const ::boost::shared_ptr< ActiveRegionIdUpdate >& update);

      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      uint8 getActiveRegion();
      uint8 ReturnActiveRegionStatus();
      uint8 sm_mot_flag;
   protected:

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SwitchApplicationReq)
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
      ON_COURIER_MESSAGE(SwitchCabin_A_ApplicationReq)
#endif
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
      ON_COURIER_MESSAGE(SwitchCabin_B_ApplicationReq)
#endif
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      ON_COURIER_MESSAGE(MediaRadioBack4mAudio)
      ON_COURIER_MESSAGE(VideoMixedSourceBack4mCabinHome)
      ON_COURIER_MESSAGE(SettingSceneMsg)
      ON_COURIER_MESSAGE(RequestMISupdateContextSwitchMsg)

      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_systemSettingsListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_micsetting)
      COURIER_MSG_DELEGATE_TO_OBJ(_OEMmenu)
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
      COURIER_MSG_DELEGATE_TO_OBJ(_cabinAsettingListhandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_dtcInfoCodeStatus4AllSubSM)
      COURIER_MSG_DELEGATE_TO_OBJ(_cabinAglassSettingListhandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_cabinASwivelCalibration)
      COURIER_MSG_DELEGATE_TO_OBJ(_cabinAAudioSettingListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_cabinAVideoMixSourceListHandler)
#endif
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
      COURIER_MSG_DELEGATE_TO_OBJ(_cabinBsettingListhandler)
#endif

      COURIER_MSG_DELEGATE_TO_OBJ(_DisplaySettings)
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
      //COURIER_MSG_DELEGATE_TO_OBJ(_navigationSrvClient)
      //COURIER_MSG_DELEGATE_TO_OBJ(_BluetoothSetting)
#endif
      COURIER_MSG_DELEGATE_TO_OBJ(_audioSettingListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_languageSettingListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_NaftaLanguageSettingListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_configurationVersion)
      COURIER_MSG_DELEGATE_TO_OBJ(_AudioSpdDepdentVolCntrlRBtn)
      COURIER_MSG_DELEGATE_TO_OBJ(_ClockDateFormatRadioBtn)
      COURIER_MSG_DELEGATE_TO_OBJ(_AudioEquilizerPresetRBtn)
      COURIER_MSG_DELEGATE_TO_OBJ(_AudioPrivateModeRBtn)
      COURIER_MSG_DELEGATE_TO_OBJ(_clockSettings)
      COURIER_MSG_DELEGATE_TO_OBJ(_GpsClockListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_swupdatelisthandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_swupdate)
      COURIER_MSG_DELEGATE_TO_OBJ(_popupTimer)
      COURIER_MSG_DELEGATE_TO_OBJ(_diagnosisclient)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_DELEGATE_TO_OBJ(_RVCSettingListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_RVCBrightnessHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_RVCContrastHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_rearviewhandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_pluginClientHandler)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_MAP_DELEGATE_END()

      // bool onCourierMessage(const GuiStartupFinishedUpdMsg& Msg);
   private:

      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchProxy;
      SystemHall(const SystemHall&);
      SystemHall& operator =(const SystemHall&);
      bool onCourierMessage(const GuiStartupFinishedUpdMsg& msg);
      ApplicationSwitchClientComponent* _applicationSwitchClient;//applicationSwitch
      DisplaySrvClient* _displayclient;
      DisplaySettings* _DisplaySettings;
      HmiStateHandler* _HmiStateHandler;
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
      ServiceBT*       _SrvClientBT;
      NavigationServiceClient* _navigationSrvClient;
#endif

      SystemDataPoolConfig* _systemdatapoolconfig;			//datapool
      RVCSettingListHandler* _RVCSettingListHandler;
      RVCBrightnessHandler* _RVCBrightnessHandler;
      RVCContrastHandler* _RVCContrastHandler;
      AudioServiceClient* _audioserviceclient;
      LanguageSettingListHandler* _languageSettingListHandler;
      NaftaLanguageSettingListHandler* _NaftaLanguageSettingListHandler;
      ConfigurationVersion* _configurationVersion;
      VehicleSrvClient* _vehicleserviceClient;
      SystemSettingsListHandler* _systemSettingsListHandler;

      MicSetting* _micsetting;
      OEMmenu* _OEMmenu;
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
      DTCInfoCodeStatus4AllSubSM* _dtcInfoCodeStatus4AllSubSM;
      CabinASettingListhandler* _cabinAsettingListhandler;
      CabinAGlassSettingListhandler* _cabinAglassSettingListhandler;
      CabinASwivelCalibration* _cabinASwivelCalibration;
      CabinAAudioSettingListHandler* _cabinAAudioSettingListHandler;
      CabinAVideoMixSourceListHandler* _cabinAVideoMixSourceListHandler;
#endif
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
      CabinBSettingListhandler* _cabinBsettingListhandler;
#endif

      AudioSettingListHandler* _audioSettingListHandler;
      CabinInfoSrvClient* _cabinInfoSrvClient;
      DiagnosisServiceClientHandler* _diagnosisserviceclnthandler;
      DiagnosisSrvClient* _diagnosisclient;
      RearViewCamera* _rearviewhandler;
      ClockSettings* _clockSettings;
      ClockSrvClient* _clockSrvClient;
      GpsClockListHandler* _GpsClockListHandler;
      PopupTimer* _popupTimer;
      PluginClientHandler* _pluginClientHandler;
      MIDWDiagnosis* _midwDiagnosis;
      // Software Update classes
      SWUpdateClient* _swupdateclient;
      SWUpdate* _swupdate;
      SoftwareUpdateListHandler* _swupdatelisthandler;
      SpmSrvClient* _spmSrvClient;
//	   SystemCourierMsgHandler* _systemcouriermessagehandler;

      AudioPrivateModeRBtn* _AudioPrivateModeRBtn;
      AudioSpdDepdentVolCntrlRBtn* _AudioSpdDepdentVolCntrlRBtn;
      AudioEquilizerPresetRBtn* _AudioEquilizerPresetRBtn;
      ClockDateFormatRadioBtn* _ClockDateFormatRadioBtn;
      HmiDataServiceClientHandler* _hmidatasrvhandler;
      HmiDataStubHandler*     _hmidatastubhandler;

      DECLARE_CLASS_LOGGER();

      uint8 m_u8activeRegion;
      uint8 CurrentActiveRegion;
};


} // namespace Core
} // namespace App


#endif
