/**************************************************************************************
* @file         : SoftwareUpdateListHandler.cpp
* @author       : ECG-Ramesh Kesavan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include "SoftwareUpdateListHandler.h"
#include "List/Data/ListDataProviderDistributor.h"
#include <vector>
#include <iostream>
#include <string>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SoftwareUpdateListHandler.cpp.trc.h"
#endif

using namespace App::Core;
using namespace std;

static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_StartSystemSoftwareUpdate";

static const int MAX_LISTSIZE = 2;
static const int LIST_ID_SW_UPDATE = 1000;


SoftwareUpdateListHandler::SoftwareUpdateListHandler()
   : _listId(1000)
{
   ETG_TRACE_USR4(("SoftwareUpdateListHandler:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SW_UPDATE, this);
}


SoftwareUpdateListHandler::~SoftwareUpdateListHandler()
{
   ETG_TRACE_USR4(("SoftwareUpdateListHandler:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SW_UPDATE);
}


void SoftwareUpdateListHandler::initialize()
{
   ETG_TRACE_USR4(("SoftwareUpdateListHandler::initialize()"));
}


void SoftwareUpdateListHandler::deinitialize()
{
   ETG_TRACE_USR4(("SoftwareUpdateListHandler::deinitialize()"));
}


bool SoftwareUpdateListHandler::onCourierMessage(const Courier::StartupMsg& /*oMsg*/)
{
   return false;
}


tSharedPtrDataProvider SoftwareUpdateListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("SoftwareUpdateListHandler::getListDataProvider()"));

   tSharedPtrDataProvider dataProvider;
   _listId = oMsg.GetListId();
   ListDataProviderBuilder listBuilder(_listId);

   if (LIST_ID_SW_UPDATE == _listId)
   {
      listBuilder.AddItem(
         0UL, // - identifies the row
         0UL, // - unused
         DATA_CONTEXT_TEXT_LIST_ITEM)
      .AddData("System Software Update");

      listBuilder.AddItem(
         0UL, // - identifies the row
         0UL, // - unused
         DATA_CONTEXT_TEXT_LIST_ITEM)
      .AddData("Software Update History");

      //for (unsigned long listIndex = 0; listIndex < MAX_TEXT_LISTITEMS; ++listIndex)      // Navigation Settings Menu list
      //{
      //   listBuilder.AddItem(
      //      listIndex, // - identifies the row
      //      0UL, // - unused
      //      DATA_CONTEXT_TEXT_LIST_ITEM)
      //      .AddData(SoftwareUpdate_ListItemText[listIndex]);
      //}

      //AddSensitivitySliderListItem(listBuilder, false);

      //CheckBoxListItemData OnMapSpeedLimitSentivity;
      //OnMapSpeedLimitSentivity.mListItemName = SoftwareUpdate_ListItemText[SPEED_LIMIT_INDICATION_ON_MAP];
      //OnMapSpeedLimitSentivity.mToggleIconSwitchIndex = safetyGuidanceSettings.isSpeedLimitActive() ? CHECKBOX_ENABLED : CHECKBOX_DISABLED;
      //listBuilder.AddItem(
      //   SPEED_LIMIT_INDICATION_ON_MAP,
      //   0UL,
      //   DATA_CONTEXT_CHECKBOX_LIST_ITEM)
      //   .AddDataBindingUpdater<CheckBoxListItemDataBindingSource>(OnMapSpeedLimitSentivity)
      //   .AddData(OnMapSpeedLimitSentivity.mToggleIconSwitchIndex);

      //CheckBoxListItemData enableSpeedLimitSentivityWarning;
      //enableSpeedLimitSentivityWarning.mListItemName = SoftwareUpdate_ListItemText[SPEED_LIMIT_WARNING];
      //enableSpeedLimitSentivityWarning.mToggleIconSwitchIndex = safetyGuidanceSettings.isOverSpeedWarningActive() ? CHECKBOX_ENABLED : CHECKBOX_DISABLED;

      //listBuilder.AddItem(
      //   SPEED_LIMIT_WARNING,
      //   0UL,
      //   DATA_CONTEXT_CHECKBOX_LIST_ITEM)
      //   .AddDataBindingUpdater<CheckBoxListItemDataBindingSource>(enableSpeedLimitSentivityWarning)
      //   .AddData(enableSpeedLimitSentivityWarning.mToggleIconSwitchIndex);
   }
   else
   {
      //invalid listId
      return tSharedPtrDataProvider();
   }

   return listBuilder.CreateDataProvider();
}


bool SoftwareUpdateListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool msgProcessed = false;
   bool checkboxStatus = false;
   bool listUpdateNeeded = false;
   ListDataProviderBuilder modifiedListItems(LIST_ID_SW_UPDATE);

   unsigned int listID = oMsg.GetListId();
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   unsigned int hdlCol = (unsigned int)oMsg.GetSubHdl();
   const enReaction  reaction = oMsg.GetReaction();

   ETG_TRACE_USR4(("SettingsListHandler::handleButtonReactionMsg(%d, %d)", rowIdx, hdlCol));

   if (LIST_ID_SW_UPDATE == listID)
   {
      if (oMsg.GetReaction() == enRelease)
      {
         switch (rowIdx)
         {
            case 0:
            {
               modifiedListItems.AddItem(
                  0UL,
                  0UL,
                  DATA_CONTEXT_TEXT_LIST_ITEM,
                  0UL,
                  0UL) // index to be updated
               .AddData("System Software Update Touched");

               listUpdateNeeded = true;
               break;
            }
            case 1:
            {
               modifiedListItems.AddItem(
                  0UL,
                  0UL,
                  DATA_CONTEXT_TEXT_LIST_ITEM,
                  0UL,
                  0UL) // index to be updated
               .AddData("Software Update History Touched");

               listUpdateNeeded = true;
               break;
            }
            default:
            {
               break;
            }
         } // end of Switch case
      } // if (oMsg.GetReaction() == enRelease)
   } // if (LIST_ID_SW_UPDATE == listID)

   if (listUpdateNeeded)
   {
      // Create a ListDataProviderUpdater using ListDataProviderBuilder and post it with a ListDataProviderUpdMsg.
      tSharedPtrDataProviderUpdater dataProviderUpdater = modifiedListItems.CreateDataProviderUpdater();
      POST_MSG(COURIER_MESSAGE_NEW(ListDataProviderUpdMsg)(dataProviderUpdater));
   }

   return msgProcessed;
}
