/**************************************************************************************
* @file         : <VehicleSrvClient.cpp>
* @author       : <ECG> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "VehicleSrvClient.h"
#include "LanguageSettingListHandler.h"
#include "SystemSettingsListHandler.h"
#include "NaftaLanguageSettingListHandler.h"
#include "CabinAGlassSettingListhandler.h"
#include "App/Core/AppLogic/SoftwareUpdate/SWUpdate.h"
#define CAN_INP 1

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::VehicleSrvClient::
#include "trcGenProj/Header/VehicleSrvClient.cpp.trc.h"
#endif

using namespace ::vehicle_main_fi_types;
using namespace ::VEHICLE_MAIN_FI;
//using namespace ::datacollector_main_fi;
//using namespace ::datacollector_main_fi_types;


namespace App {
namespace Core {
/**
 * @Constructor
 */
VehicleSrvClient* VehicleSrvClient::_VehicleSrvClient = NULL;
VehicleSrvClient::VehicleSrvClient(): _vehicleProxy(::VEHICLE_MAIN_FIProxy::createProxy("vehicleMainFiPort", *this))
{
   _vregionType4SystemSetting = 0X00;
   _currentLanguageStatus = 23;
   ETG_TRACE_USR4(("VehicleSrvClient Constructor is called"));
   if (_vehicleProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _vehicleProxy->getPortName());
      ETG_TRACE_USR4(("VehicleSrvClient Constructor after creating proxy"));
   }

   dp_tclKdsVehicleInformation _KdsVehicleInformation4LangSetting;
   _KdsVehicleInformation4LangSetting.u8GetDestinationRegion1(_vregionType4SystemSetting);

   ETG_TRACE_USR4(("VehicleSrvClient _vregionType4SystemSetting :%d", _vregionType4SystemSetting))
}


/**
* @Destructor
*/

VehicleSrvClient::~VehicleSrvClient()
{
   ETG_TRACE_USR4(("VehicleSrvClient destructor is called"));
}


/**
 * @onAvailable
 */
void VehicleSrvClient::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   StartupSync::getInstance().onAvailable(proxy, stateChange);
   ETG_TRACE_USR4(("VehicleSrvClient onAvailable is called"));
}


/**
 * @onUnavailable
 */
void VehicleSrvClient::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
   ETG_TRACE_USR4(("VehicleSrvClient onAvailable is called"));
}


void VehicleSrvClient::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient register property is called"));
   // _vregionType4SystemSetting = 0X06;

   if (_vehicleProxy && (proxy == _vehicleProxy))
   {
      ETG_TRACE_USR4(("VehicleSrvClient register property insideis called"));
      _vehicleProxy->sendLanguageUpReg(*this);
      _vehicleProxy->sendDistanceUnitUpReg(*this);
      _vehicleProxy->sendSwivMonAutoOpenUpReg(*this);
      _vehicleProxy->sendDeviceInfoSWversionUpReg(*this);
      _vehicleProxy->sendDriverDoorOpenUpReg(*this);
   }
   dp_tclKdsVehicleInformation _KdsVehicleInformation4LangSetting;
   _KdsVehicleInformation4LangSetting.u8GetDestinationRegion1(_vregionType4SystemSetting);
}


void VehicleSrvClient::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient deregister property is called"));
   if (_vehicleProxy && (proxy == _vehicleProxy))
   {
      ETG_TRACE_USR4(("VehicleSrvClient deregister property inside is called"));
      _vehicleProxy->sendLanguageRelUpRegAll();
      _vehicleProxy->sendDistanceUnitRelUpRegAll();
      _vehicleProxy->sendSwivMonAutoOpenRelUpRegAll();
      _vehicleProxy->sendDeviceInfoSWversionRelUpRegAll();
      _vehicleProxy->sendDriverDoorOpenRelUpRegAll();
   }
}


void VehicleSrvClient::onDeviceInfoSWversionError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /* proxy*/, const ::boost::shared_ptr< DeviceInfoSWversionError >& /*error*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient onDeviceInfoSWversionError"));
}


void VehicleSrvClient::onDeviceInfoSWversionStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /* proxy*/, const ::boost::shared_ptr< DeviceInfoSWversionStatus >& status)
{
   uint32  _SWversionValue = status->getSWversionValue();
   ETG_TRACE_USR4(("VehicleSrvClient onDeviceInfoSWversionStatus _SWversionValue ::%d", _SWversionValue));
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   SWUpdate::GetInstance()->sendMCPVersionUpdatetoGUI(_SWversionValue);
#endif
}


void VehicleSrvClient:: onReq_DeviceInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::Req_DeviceInfoError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient onReq_DeviceInfoError is called"));
}


void VehicleSrvClient:: onReq_DeviceInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::Req_DeviceInfoResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient onReq_DeviceInfoResult is called"));
}


void VehicleSrvClient::setdeviceinfo(uint8 reqdeviceinfo)
{
   ETG_TRACE_USR4(("VehicleSrvClient setdeviceinfo reqdeviceinfo=%d", reqdeviceinfo));
   if (_vehicleProxy)
   {
      _vehicleProxy->sendReq_DeviceInfoStart(*this, reqdeviceinfo);
   }
}


void VehicleSrvClient::onDistanceUnitError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >&  /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DistanceUnitError >&  /*error*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient onDistanceUnitError is called"));
}


void VehicleSrvClient::onPrivacyResetAckError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PrivacyResetAckError >& /*error*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient onPrivacyResetAckError is called"));
}


void VehicleSrvClient::onPrivacyResetAckResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PrivacyResetAckResult >& /*result*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient onPrivacyResetAckResult is called"));
}


void VehicleSrvClient::onDistanceUnitStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >&  /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DistanceUnitStatus >&  status)
{
   ETG_TRACE_USR4(("VehicleSrvClient onDistanceUnitStatus is called"));
   uint8 distanceunit = status->getE8DistanceUnit();

   ETG_TRACE_USR4(("onDistanceUnitStatus distanceunit=%d", distanceunit));
   SystemSettingsListHandler::poGetInstance()->sendDistanceUnitUpdateToGUI(distanceunit);
}


void VehicleSrvClient::sendPrivacyResetAck()
{
   uint8 ackval = 1;
   ETG_TRACE_USR4(("VehicleSrvClient sendPrivacyResetAck"));
   if (_vehicleProxy)
   {
      _vehicleProxy->sendPrivacyResetAckStart(*this, ackval);
   }
}


void VehicleSrvClient::setdistanceunit(uint u8distanceunit)
{
   ETG_TRACE_USR4(("VehicleSrvClient Set Distance Unit is called with value %d", u8distanceunit));
   if (_vehicleProxy)
   {
      _vehicleProxy->sendDistanceUnitSet(*this, (T_e8_Vehicle_DistanceUnit)u8distanceunit);
   }
}


void VehicleSrvClient::onSwivMonAutoOpenError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SwivMonAutoOpenError >& /*error*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient onSwivMonAutoOpenError"));
}


void VehicleSrvClient::onSwivMonAutoOpenStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SwivMonAutoOpenStatus >& status)
{
   uint8 doorstatus = status->getSwivMonAutoOpenValue();
   ETG_TRACE_USR4(("VehicleSrvClient onSwivMonAutoOpenStatus %d", doorstatus));
   CabinAGlassSettingListhandler::poGetInstance()->sendPassengerDoorStatusRequestToPlugin(doorstatus);
}


void VehicleSrvClient::onDriverDoorOpenError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DriverDoorOpenError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient onDriverDoorOpenError "));
}


void VehicleSrvClient::onDriverDoorOpenStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DriverDoorOpenStatus >& status)
{
   uint8 driverDoorStatus = status->getDriverDoorOpenValue();
   ETG_TRACE_USR4(("VehicleSrvClient onDriverDoorOpenStatus %d", driverDoorStatus));
   CabinAGlassSettingListhandler::poGetInstance()->sendDriverDoorStatusRequestToPlugin(driverDoorStatus);
}


/*
 * onSetLanguageResult - ASF framework callback which is after SetLanguage
 * @param[in] proxy
 * @param[in] result
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onSetLanguageResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/,  const ::boost::shared_ptr< SetLanguageResult >& result)
{
   ETG_TRACE_USR4(("onSetLanguageResult received :  %d", result->getResult()));
}


/*
 * onSetLanguageError - ASF framework callback which is after SetLanguage
 * @param[in] proxy
 * @param[in] error
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onSetLanguageError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SetLanguageError >& /*error*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onSetLanguageError"));
}


void VehicleSrvClient::setHMILanguage(uint32 langcode)
{
   ETG_TRACE_USR4(("VehicleSrvClient::setHMILanguage langcode =%d", langcode));
   if (_vehicleProxy)
   {
      //Set SyncSource id -> Options :
      //						 1. HMI
      //Case 1. Set Language SyncSrc id and SetLanguage for HMI when the language id is other than 'Auto'

      _vehicleProxy->sendSetLanguageStart(*this, T_e8_Language_SourceId__HMI, (T_e8_Language_Code)langcode);

      _vehicleProxy->sendLanguageSyncSourceSet(*this, T_e8_Language_SourceId__HMI);
   }
}


/*
 * onLanguageStatus - ASF framework callback which is triggered on every setLanguage()
 * @param[in] proxy
 * @param[in] status
 * @param[out] None
 * @return voidl
 * todo :check As of now, after setLanguage, onLanguageStatus() is received twice from the VD_Vehicle data.
 * First update represents, previously configured Language ID and the second one represents currently configured ID.*/

void VehicleSrvClient::onLanguageStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/,  const ::boost::shared_ptr< LanguageStatus >& status)
{
   ETG_TRACE_USR4(("onLanguageStatus"));
   std::vector<T_Language_SourceTable> langTable = status->getLangTable();
   uint32 langIndex = status->getLanguage();

   ETG_TRACE_USR4(("VehicleSrvClient::onLanguageStatus OutSide: %d", langIndex));
   //uint32 languageindexTable = langTable[T_e8_Language_SourceId__HMI].getEnLanguage;
   ETG_TRACE_USR4(("onLanguageStatus langIndex=%d", langIndex));
   _currentLanguageStatus = langIndex;
   ETG_TRACE_USR4(("VehicleSrvClient _vregionType4SystemSetting onLanguageStatus:%d", _vregionType4SystemSetting))
   if (_vregionType4SystemSetting == LANGUAGE_EUROPE_SELECT)
   {
      //Europe Variant Selection=0X06
      LanguageKds_Selection = 1;
      LanguageSettingListHandler::poGetInstance()->sendLanguageUpdateToGUI(langIndex);
      ETG_TRACE_USR4(("onLanguageStatus LANGUAGE_EUROPE_SELECT _vregionType4SystemSetting=%d", _vregionType4SystemSetting));
   }
   else
   {
      //Nafta Variant Selection=0X00
      LanguageKds_Selection = 0;
      ETG_TRACE_USR4(("onLanguageStatus LANGUAGE_NAFTA_SELECT _vregionType4SystemSetting=%d", _vregionType4SystemSetting));
      NaftaLanguageSettingListHandler::poGetInstance()->sendNaftaLanguageUpdateToGUI(langIndex);
   }
}


// const std::string VehicleSrvClient::getCurrentLanguageStatusData()
uint32 VehicleSrvClient::getCurrentLanguageStatusData()
{
   return _currentLanguageStatus;
}


void VehicleSrvClient::destroy()
{
   delete _VehicleSrvClient;
   _VehicleSrvClient = NULL;
}


/*
 * onLanguageError - ASF framework callback which is triggered if there is any error in setLanguage()
 * @param[in] proxy
 * @param[in] error
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onLanguageError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< LanguageError >& /*error*/)
{
   ETG_TRACE_USR4(("onLanguageError"));
}


}
}
