/**************************************************************************************
* @file         : SystemCourierMsgHandler.h
* @author       : ECG - Sathiya Jayanth
* @addtogroup   : Tuner HALL
* @brief        : Class contains utility functions to handle courier messages required for System Settings.
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#if !defined(_SystemCourierMsgHandler_H)
#define _SystemCourierMsgHandler_H


#include <AppHmi_SystemMessages.h>
#include "CgiExtensions/DataBindingItem.hpp"
#include "asf/core/Types.h"


namespace App {
namespace Core {

//Forward decleration
class DisplaySrvClient;

/* class SystemCourierMsgHandler
 * This class handles the courier messages received as "subscriber = Model".
 */

class SystemCourierMsgHandler
{
   public:

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      COURIER_MSG_MAP_END()
      SystemCourierMsgHandler(DisplaySrvClient* _dispclientif);
      virtual ~SystemCourierMsgHandler();
      DisplaySrvClient* _displayclientif;
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
};


}
}


#endif
