/**************************************************************************************
* @file         : SystemCourierMsgHandler.h
* @author       : ECG - Sathiya Jayanth
* @addtogroup   : Tuner HALL
* @brief        : Class contains utility functions to handle courier messages required for System Settings.
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "SystemCourierMsgHandler.h"
#include "AppHmi_SystemStateMachine.h"
#include "hmi_trace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                  SystemCourierHandler::
#include "trcGenProj/Header/SystemCourierMsgHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

SystemCourierMsgHandler::SystemCourierMsgHandler(DisplaySrvClient* _dispclientif)
{
   _displayclientif = _dispclientif;
}


bool SystemCourierMsgHandler::onCourierMessage(const ButtonReactionMsg& /*oMsg*/)
{
   return false;
}


SystemCourierMsgHandler::~SystemCourierMsgHandler()
{
   _displayclientif = NULL;
}


}
}
