/**************************************************************************************
* @file         : HmiDataStubHandler.h
* @author       :
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMIDATASTUBHANDLER_H_
#define HMIDATASTUBHANDLER_H_

//#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataProxy.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataStub.h"


#ifndef HMI_DATA_SERVICE_NS
#define HMI_DATA_SERVICE_NS bosch::cm::ai::nissan::hmi::hmidataservice::HmiData
#endif

namespace App {
namespace Core {

class HmiDataStubHandler: public HMI_DATA_SERVICE_NS::HmiDataStub
{
   public:
      HmiDataStubHandler();
      virtual ~HmiDataStubHandler();

      static HmiDataStubHandler*  _hmidatastub;

      static HmiDataStubHandler* poGetInstance()
      {
         if (NULL == _hmidatastub)
         {
            _hmidatastub = new HmiDataStubHandler();
         }

         return _hmidatastub;
      }
      // virtual void onSetSpeedLockStatusRequest (const ::boost::shared_ptr< HMI_DATA_SERVICE_NS::SetSpeedLockStatusRequest >& request);

      static void destroy();

   private:
};


}
}


#undef HMI_DATA_SERVICE_NS
#endif /* HMIDATASTUBHANDLER_H_ */
