/**************************************************************************************
* @file         : HmiDataStubHandler.cpp
* @author       :
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <hmibase/hall_std_if.h>
#include "HmiDataStubHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::HmiDataStubHandler::
#include "trcGenProj/Header/HmiDataStubHandler.cpp.trc.h"
#endif

using namespace ::asf::core;
using namespace ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData;

namespace App {
namespace Core {

HmiDataStubHandler* HmiDataStubHandler::_hmidatastub = NULL;

HmiDataStubHandler::HmiDataStubHandler() : HmiDataStub("hmiDataServerPort")
{
   ETG_TRACE_USR4(("IN HmiDataStubHandler Constructor "));
}


HmiDataStubHandler::~HmiDataStubHandler()
{
   destroy();
}


void HmiDataStubHandler::destroy()
{
   delete _hmidatastub;
   _hmidatastub = NULL;
}


/*void HmiDataStubHandler::onSetSpeedLockStatusRequest (const ::boost::shared_ptr< SetSpeedLockStatusRequest >& request)
{
	ETG_TRACE_USR4(("IN onSetSpeedLockStatusRequest "));
	setSpeedLockStatus(request->getSpeedLockStatus());
}*/
}


}
