/***************************************************************************
* Copyright(c) 2018-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
#include <hmibase/hall_std_if.h>
#include "HmiDataServiceClientHandler.h"
#include "SystemSettingsListHandler.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::HmiDataServiceClientHandler::
#include "trcGenProj/Header/HmiDataServiceClientHandler.cpp.trc.h"
#endif


using namespace ::asf::core;
using namespace ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData;

namespace App {
namespace Core {

HmiDataServiceClientHandler* HmiDataServiceClientHandler::_hmidatasrvclient = NULL;

HmiDataServiceClientHandler::HmiDataServiceClientHandler(): _hmiDataProxyClient(HmiDataProxy::createProxy("hmiDataServicePort", *this))
{
   StartupSync::getInstance().registerPropertyRegistrationIF(this, _hmiDataProxyClient->getPortName());
   DiagnosisServiceClientHandler* pdiagServiceClientHandler = DiagnosisServiceClientHandler::GetInstance();
   if (pdiagServiceClientHandler != NULL)
   {
      pdiagServiceClientHandler->registerRestoreFactorySettingInfoChange(this);
      ETG_TRACE_USR4(("Registerred for Factory Reset"));
   }
   ETG_TRACE_USR4(("IN HmiDataServiceClient CTOR   "));
   //_hmiDataProxy = ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy::createProxy("hmiDataServicePort", *this);
   //init();
   speedlockstatus = 1;
}


void HmiDataServiceClientHandler::onAvailable(const ::boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange)
{
   if (_hmiDataProxyClient == proxy)
   {
      ETG_TRACE_USR4(("HmiDataServiceClientHandler::onAvailable()"));
      StartupSync::getInstance().onAvailable(proxy, stateChange);
      SetSpeedlock(true);
      // _hmiDataProxyClient->sendSpeedLockStatusRegister(*this);
   }
}


void HmiDataServiceClientHandler::onUnavailable(const ::boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange)
{
   if (_hmiDataProxyClient == proxy)
   {
      ETG_TRACE_USR4(("HmiDataServiceClientHandler::onUnavailable()"));
      StartupSync::getInstance().onUnavailable(proxy, stateChange);
   }
}


void HmiDataServiceClientHandler::registerProperties(const ::boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& /*stateChange*/)
{
   if (proxy == _hmiDataProxyClient)
   {
      ETG_TRACE_USR4(("HmiDataServiceClientHandler::Registering for Speed lock"));
      _hmiDataProxyClient->sendSpeedLockStatusRegister(*this);
      _hmiDataProxyClient->sendDimmingModeRegister(*this);
   }
}


void HmiDataServiceClientHandler::deregisterProperties(const ::boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& /*stateChange*/)
{
   if (proxy == _hmiDataProxyClient)
   {
      ETG_TRACE_USR4(("HmiDataServiceClientHandler::DeRegistering for Speed lock"));
      _hmiDataProxyClient->sendSpeedLockStatusDeregisterAll();
      _hmiDataProxyClient->sendDimmingModeDeregisterAll();
   }
}


void HmiDataServiceClientHandler::onSpeedLockStatusUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& /*proxy*/, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SpeedLockStatusUpdate >& update)
{
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::onSpeedLockStatusUpdate()"));
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::onSpeedLockStatusUpdate(%d)", update->getSpeedLockStatus()));

   //speedlockstatus=update->getSpeedLockStatus();

   //SystemSettingsListHandler::poGetInstance()->SPEEDLOCKSTATUS(speedlockstatus);
   SystemSettingsListHandler::poGetInstance()->SetspeedlockVisibilityStatus(update->getSpeedLockStatus());
}


void HmiDataServiceClientHandler::onSpeedLockStatusError(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& /*proxy*/, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SpeedLockStatusError >& /*error*/)
{
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::onSpeedLockStatusError()"));
}


void HmiDataServiceClientHandler::updateResetFactorySettingsInfo()
{
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::updateResetFactorySettingsInfo()"));
   SetSpeedlock(true);
}


/*void HmiDataServiceClientHandler::onSetSpeedLockStatusError(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SetSpeedLockStatusError >& error)
{
	ETG_TRACE_USR4(("HmiDataServiceClientHandler::onSetSpeedLockStatusError() before if"));
	if (proxy == _hmiDataProxyClient)
   {
		ETG_TRACE_USR4(("HmiDataServiceClientHandler::onSetSpeedLockStatusError()"));
		ETG_TRACE_USR4(("HmiDataServiceClientHandler::onSetSpeedLockStatusError number is %d",error->getAct()));
	}
}


void HmiDataServiceClientHandler::onSetSpeedLockStatusResponse(const ::boost::shared_ptr<  ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy, const ::boost::shared_ptr<  ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SetSpeedLockStatusResponse >& response)
{
	ETG_TRACE_USR4(("HmiDataServiceClientHandler::onSetSpeedLockStatusResponse()"));
}*/
int HmiDataServiceClientHandler::getSpeedlock()
{
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::getSpeedlock  %d", speedlockstatus));
   return speedlockstatus;
}


void HmiDataServiceClientHandler:: SetSpeedlock(bool status)
{
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::recieved status is  %d", status));
   _hmiDataProxyClient->sendSpeedLockStatusSet(*this, status);
}


void HmiDataServiceClientHandler::onDimmingModeError(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& /*proxy*/, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::DimmingModeError >& /*error*/)
{
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::onDimmingModeError"));
}


void HmiDataServiceClientHandler::onDimmingModeUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& /*proxy*/, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::DimmingModeUpdate >& update)
{
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::onDimmingModeUpdate"));
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::onDimmingModeUpdate(%d)", update->getDimmingMode()));
}


void HmiDataServiceClientHandler::SetDimmingMode(int mode)
{
   ETG_TRACE_USR4(("HmiDataServiceClientHandler::Dimming mode to set is %d", mode));
   _hmiDataProxyClient->sendDimmingModeSet(static_cast<uint8>(mode));
}


/*void HmiDataServiceClient::init()
{
   ETG_TRACE_USR4(("IN HmiDataServiceClient INIT"));
   if (_hmiDataProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _hmiDataProxy->getPortName());
   }
}*/

/**
 * @Destructor
 */
HmiDataServiceClientHandler::~HmiDataServiceClientHandler()
{
   //clear();
   DiagnosisServiceClientHandler* pdiagServiceClientHandler = DiagnosisServiceClientHandler::GetInstance();
   if (pdiagServiceClientHandler != NULL)
   {
      pdiagServiceClientHandler->deRegisterRestoreFactorySettingInfoChange(this);
   }
   destroy();
}


void HmiDataServiceClientHandler::destroy()
{
   delete _hmidatasrvclient;
   _hmidatasrvclient = NULL;
}


} // namespace Core
} // namespace App
