/**************************************************************************************
* @file         : <SpmSrvClient.h>
* @author       : <Ramesh Kesavan> <ECH> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef SPM_SRV_CLIENT_HEADER
#define SPM_SRV_CLIENT_HEADER


#include "SPM_CORE_FIProxy.h"
#include "SPM_CORE_FI.h"
#include "asf/core/Types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "App/Core/AppLogic/SoftwareUpdate/SWUpdate.h"

using namespace ::SPM_CORE_FI;

//class StartupSync;
namespace App {
namespace Core {


class SpmSrvClient :
   public ::StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
// public SPM_CORE_FI::RestartCallbackIF,
   public SPM_CORE_FI::RestartSystemCallbackIF,
   public SPM_CORE_FI::OnOffTriggerCallbackIF
{
   public:

      static SpmSrvClient* GetInstance()
      {
         if (NULL == _spmSrvClient)
         {
            _spmSrvClient = new SpmSrvClient();
         }

         return _spmSrvClient;
      }

      virtual ~SpmSrvClient();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onRestartSystemError(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const ::boost::shared_ptr< ::SPM_CORE_FI::RestartSystemError >& error);
      void onRestartSystemResult(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const ::boost::shared_ptr< ::SPM_CORE_FI::RestartSystemResult >& result);

      void onOnOffTriggerError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SPM_CORE_FI::OnOffTriggerError >& /*error*/) {}
      void onOnOffTriggerResult(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SPM_CORE_FI::OnOffTriggerResult >& /*result*/) {}

      ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy > _spmCoreFiProxy;

      void TriggerIMXReboot();
      void TriggerCMCRestartdownloadaborted();
      void sendSWUpdateStatus(bool status);
      void destroy();
   private:
      SpmSrvClient();

      static SpmSrvClient*  _spmSrvClient;
};


}
}


#endif //SPM_SRV_CLIENT_HEADER
