/**************************************************************************************
* @file         : SpmSrvClient.cpp
* @author       : <Ramesh Kesavan> <ECH> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        : Class contains necessary business logic required to handle Display Settings.
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "SpmSrvClient.h"
//#include "ClientServicesIFProxy.h"
#include "midw_fi_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                  SpmSrvClient::
#include "trcGenProj/Header/SpmSrvClient.cpp.trc.h"
#endif

using namespace SPM_CORE_FI;
using namespace spm_core_fi_types;
using namespace ::asf::core;

namespace App {
namespace Core {

SpmSrvClient* SpmSrvClient::_spmSrvClient = NULL;

/**
 * @Destructor*
 */
SpmSrvClient::~SpmSrvClient()
{
}


/**
 * @Constructor
 */

SpmSrvClient::SpmSrvClient()
{
   ETG_I_REGISTER_FILE();
   _spmCoreFiProxy = SPM_CORE_FIProxy::createProxy("spmFiPort", *this);

   ETG_TRACE_USR4(("SpmSrvClient Constructor "));

   if (_spmCoreFiProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _spmCoreFiProxy->getPortName());
      ETG_TRACE_USR4(("SpmSrvClient registerPropertyRegistrationIF"));
   }
}


/**
 * onAvailable - Checks for the availability of service
 * @param[in] proxy, stateChange
 * @parm[out] none
 * @return void
 */
void SpmSrvClient::onAvailable(const ::boost::shared_ptr< ::Proxy >& proxy,
                               const ServiceStateChange& stateChange)
{
   //ETG_TRACE_FATAL(("SpmSrvClient onAvailable"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
   ETG_TRACE_USR4(("SpmSrvClient onAvailable"));
}


/**
 * onUnavailable - Checks for the unavailability of service
 * @param[in] proxy, stateChange
 * @parm[out] none
 * @return void
 */
void SpmSrvClient::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                 const ServiceStateChange& stateChange)
{
   //ETG_TRACE_USR4(("SpmSrvClient onUnavailable"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
   ETG_TRACE_USR4(("SpmSrvClient onUnavailable "));
}


void SpmSrvClient::destroy()
{
   delete _spmSrvClient;
   _spmSrvClient = NULL;
}


/**
 * registerProperties - Register for the DIM_INFO_DimmingMode property available in the dimming proxy
 * @param[in] proxy , stateChange
 * @parm[out] none
 * @return void
 */
void SpmSrvClient::registerProperties(const ::boost::shared_ptr< Proxy >& proxy,
                                      const ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4(("SpmSrvClient registerProperties"));
   if (_spmCoreFiProxy && (_spmCoreFiProxy == proxy))
   {
      //_spmCoreFiProxy->sendRestartRelUpRegAll(*this);
      //   _spmCoreFiProxy->sendRestartUpReg(*this);
      ETG_TRACE_USR4(("SpmSrvClient registerProperties done"));
   }
}


/**
 * deregisterProperties - Deregister DIM_INFO_DimmingMode property in the dimming proxy
 * @param[in] proxy , stateChange
 * @parm[out] none
 * @return void
 */
void SpmSrvClient::deregisterProperties(const ::boost::shared_ptr< Proxy >& proxy,
                                        const ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4(("SpmSrvClient deregisterProperties"));

   if (_spmCoreFiProxy && (_spmCoreFiProxy == proxy))
   {
      //  _spmCoreFiProxy->sendRestartRelUpRegAll();
      ETG_TRACE_USR4(("SpmSrvClient deregisterProperties done"));
   }
}


void SpmSrvClient::onRestartSystemError(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const ::boost::shared_ptr< RestartSystemError >& /*error*/)
{
   ETG_TRACE_USR4(("SpmSrvClient onRestartSystemError"));
}


void SpmSrvClient::onRestartSystemResult(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const ::boost::shared_ptr< RestartSystemResult >& /*result*/)
{
   ETG_TRACE_USR4(("SpmSrvClient onRestartSystemResult"));
}


void SpmSrvClient::TriggerIMXReboot()
{
   ETG_TRACE_USR4(("SpmSrvClient TriggerIMXReboot - User Triggered Restart"));
   if (_spmCoreFiProxy)
   {
      ETG_TRACE_ERR(("AppHmi_System --> SpmSrvClient - User Trigger Reboot for MIS software Update"))

      // ref Type T_SPM_e32_RESTART_TYPE in spm_core_fi file
      //const uint32 SPM_U32_RESTART_ECU_WITH_SYNC = 5;
      _spmCoreFiProxy->sendRestartSystemStart(*this, T_SPM_e32_RESTART_TYPE__SPM_U32_RESTART_ECU_WITH_SYNC/*spm_core_fi_types::T_SPM_e32_RESTART_TYPE*/);
   }
}


void SpmSrvClient::TriggerCMCRestartdownloadaborted()
{
   ETG_TRACE_USR4(("SpmSrvClient TriggerCMCRestartdownloadaborted - User Triggered Restart for Head Unit after download aborted"));
   if (_spmCoreFiProxy)
   {
      ETG_TRACE_ERR(("AppHmi_System --> SpmSrvClient - User Trigger Reboot for MIS software Update and download aborted"))
      _spmCoreFiProxy->sendRestartSystemStart(*this, T_SPM_e32_RESTART_TYPE__SPM_U32_RESTART_DOWNLOAD_ABORTED);
   }
}


void SpmSrvClient::sendSWUpdateStatus(bool status)
{
   ETG_TRACE_COMP(("SpmSrvClient sendSWUpdateStatus status = %d", status));
   if (_spmCoreFiProxy)
   {
      ETG_TRACE_ERR(("SpmSrvClient::sendSWUpdateStatus"))
      _spmCoreFiProxy->sendOnOffTriggerStart(*this, T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_DOWNLOAD_PERMISSION, status);
   }
}


}
}
