/**
 * @addtogroup <AppHmi_System>
 * @{
 * @file        NavigationServiceClient.h
 * @brief       NavigationServiceClient is to handle ServiceClient impl of Navigation services.
 * @author      Sriganesh Dayananda Sagar
 * @copyright   (C) 2016 Robert Bosch GmbH.
 *              (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 * @}
 */


#ifndef NAVIGATION_SERVICE_CLIENT_H
#define NAVIGATION_SERVICE_CLIENT_H


//#include "SystemFeatures.dat"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "AppBase/ServiceAvailableIF.h"

/**
 *  Defines Declaration
 */

#define NAVIGATION_INTERFACE ::org::bosch::cm::navigation::NavigationService

using namespace std;

/**
 * Classes declaration
 */
namespace App {
namespace Core {


/**
 * NavigationServiceClient is used to
 *    - Handle the Navigation service.
 *    - Enable FS: FTR_ENABLE_NAVIGATION_SERVICE_CLIENT
 *    - It is supporting the client implementation for VoiceGuidanceMethod of Navigation service *
 *    - It is supporting the client implementation for SpeakSamplePhrase method of Navigation service
 *    -> Note: For this method's result CB is not implemented because its not required to applogic
 */
class NavigationServiceClient :  public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public NAVIGATION_INTERFACE::DatasetVersionCallbackIF
{
   public:
      /**
       *  Member Function Declaration
       */
      static NavigationServiceClient* poGetInstance()
      {
         if (NULL == _navigationSrvClient)
         {
            _navigationSrvClient = new NavigationServiceClient();
         }

         return _navigationSrvClient;
      }

      virtual ~NavigationServiceClient();
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);

      void onDatasetVersionError(const ::boost::shared_ptr< NAVIGATION_INTERFACE::NavigationServiceProxy >& /*proxy*/, const ::boost::shared_ptr< NAVIGATION_INTERFACE::DatasetVersionError >& /*error*/);
      void onDatasetVersionUpdate(const ::boost::shared_ptr< NAVIGATION_INTERFACE::NavigationServiceProxy >& /*proxy*/, const ::boost::shared_ptr< NAVIGATION_INTERFACE::DatasetVersionUpdate >& update);

   private:

      NavigationServiceClient();
      static NavigationServiceClient* _navigationSrvClient;

      ::boost::shared_ptr < NAVIGATION_INTERFACE::NavigationServiceProxy > _navigationServiceProxy;
};


} //Core
} //App

#endif //NAVIGATION_SERVICE_CLIENT_H
