/**************************************************************************************
* @file         : <HmiStateHandler.h>
* @author       : Sriganesh
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (C) 2018 Robert Bosch GmbH
*                 (C) 2018 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMISTATEHANDLER_HEADER
#define HMISTATEHANDLER_HEADER

#include "AppBase/ServiceAvailableIF.h"
#include "SPM_CORE_FIProxy.h"

namespace App {
namespace Core {


class HmiStateHandler : public hmibase::ServiceAvailableIF,
   public SPM_CORE_FI::HmiStateCallbackIF
{
   public:

      static HmiStateHandler* poGetInstance()
      {
         if (NULL == _HmiStateHandler)
         {
            _HmiStateHandler = new HmiStateHandler();
         }

         return _HmiStateHandler;
      }

      virtual ~HmiStateHandler();

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onHmiStateError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SPM_CORE_FI::HmiStateError >& error);
      void onHmiStateStatus(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SPM_CORE_FI::HmiStateStatus >& status);

      bool isPartialUserModeOn();
      bool isUserStandbyOff();
      uint8 GetHmiState();
      uint8 HMIState;

   private:

      HmiStateHandler();
      static HmiStateHandler*  _HmiStateHandler;
      ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy > _spmProxy;
};


}
}


#endif //DISPLAY_SRV_CLIENT_HEADER
