/**************************************************************************************
* @file         : <SWUpdateClient.h>
* @author       : <Ramesh Kesavan> <ECH> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef SWUPDATECLIENT_HEADER
#define SWUPDATECLIENT_HEADER


#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"
#include "App/Core/System_Types.h"
#include "asf/core/Types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "App/Core/AppLogic/SoftwareUpdate/SWUpdate.h"
#include "App/Core/Utils/SWUpdateUtility.h"
#include <map>
#include <vector>
#include <string>
const uint8  TEXT_BUFFER_SIZE	= 10;
const uint64  LONG_TEXT_BUFFER_SIZE	= 64;

namespace App {
namespace Core {

class SWUpdateClient :
   public hmibase::ServiceAvailableIF,
   public ::StartupSync::PropertyRegistrationIF,
   public fcswupdatesrv::FcSwUpdateSrv::UpdateStateCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::ReleaseDocCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::ApplyDocCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::UpdateProgressCallbackIF,
   public fcswupdatesrv::FcSwUpdateSrv::UpdateAbortCallbackIF
{
   public:
      static SWUpdateClient* GetInstance()
      {
         if (NULL == _swUpdateClient)
         {
            _swUpdateClient = new SWUpdateClient();
         }

         return _swUpdateClient;
      }
      virtual~SWUpdateClient();

      // Member Functions
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                               const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                 const asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                              const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                const asf::core::ServiceStateChange& stateChange);

      void onUpdateStateError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                              const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateStateError >& error);
      void onUpdateStateUpdate(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                               const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateStateUpdate >& update);

      void onReleaseDocError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                             const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::ReleaseDocError >& error);
      void onReleaseDocUpdate(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                              const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::ReleaseDocUpdate >& update);

      void onUpdateErrorsError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                               const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsError >& error);
      void onUpdateErrorsUpdate(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateErrorsUpdate >& update);

      void onApplyDocError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                           const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::ApplyDocError >& error);
      void onApplyDocResponse(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                              const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::ApplyDocResponse >& response);

      void onSetUpdateOptionsError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                   const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsError >& error);
      void onSetUpdateOptionsResponse(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                      const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::SetUpdateOptionsResponse >& response);

      void onUpdateSetReleaseFilterError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                         const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterError >& error);
      void onUpdateSetReleaseFilterResponse(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                            const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterResponse >& response);

      void onGetUpdateHistoryError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                   const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryError >& error);
      void onGetUpdateHistoryResponse(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                      const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::GetUpdateHistoryResponse >& response);

      void onSetAllowRecoveryModeError(const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
                                       const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeError >& error);
      virtual void onSetAllowRecoveryModeResponse(const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy,
            const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeResponse >& response);

      virtual void onUpdateProgressError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateProgressError >& error);

      virtual void onUpdateProgressUpdate(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateProgressUpdate >& update);

      virtual void onUpdateAbortError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateAbortError >& error);

      virtual void onUpdateAbortResponse(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateAbortResponse >& response);

      const std::string getCurrentSytemVersion();
      const std::string getOverallSoftwareVersion();
      void setAllowRecoveryModeRequest(bool flag);
      //Software Update Interface
      void handleStartDownloadRequest();
      void getDeviceDataReleaseDoc();
      void SetReleaseFilter(const uint8 downloadMode);
      void SetSoftwareUpdateType(const uint8 updateType);
      std::vector <swDetailsInfo> getSWDetailsVector();
      std::vector < UpdateHistoryInfo > getSWUpdateHistoryVector();
      std::vector <std::string> getSWUpdateHistoryDetailsVector();
      void getUpdateHistory();
      static void destroy();
      void sendAbortRequest();
   private:
      SWUpdateClient();
      static SWUpdateClient*  _swUpdateClient;
      swUpdateHisDetails _swUpdateHisDetails;
      swDetailsInfo  _stswDetailsInfo;

      // Member variables
      ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy > _fcSwUpdateProxy;
      std::vector <swDetailsInfo> _swUpdateDetailsVector;
      std::vector< UpdateHistoryInfo > _swUpdateHistoryVector;
      std::vector <std::string> _swUpdateHistoryDetailsVector;
      std::string _currentSystemVersion;
      std::string _overallsoftwareVersion;

      uint8 _updateState;
};


} // namespace Core
} // namespace App


#endif //SWUPDATECLIENT_HEADER
