/**************************************************************************************
* @file         : <DisplaySrvCient.h>
* @author       : <Sathiya Jayanth> <ECG> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DISPLAY_SRV_CLIENT_HEADER
#define DISPLAY_SRV_CLIENT_HEADER

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "dimming_main_fiProxy.h"
#include "dimming_main_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"
#endif


#include "App/Core/AppLogic/DisplaySettings/DisplaySettings.h"
#include "App/Core/ClientHandler/SpeedLock/HmiDataServiceClientHandler.h"

//class StartupSync;

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
namespace App {
namespace Core {
class DisplaySrvClient :
   public ::StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,

   public ::dimming_main_fi::DIM_DISP_SetBrightnessLevelExtendedCallbackIF,

   public ::dimming_main_fi::DIM_DISP_BrightnessLevelExtendedCallbackIF,
   public ::dimming_main_fi::DIM_INFO_DimmingModeCallbackIF,
   public ::dimming_main_fi::DIM_INFO_SetDimmingModeCallbackIF
{
   public:

      static DisplaySrvClient* poGetInstance()
      {
         if (NULL == _DisplaySrvClient)
         {
            _DisplaySrvClient = new DisplaySrvClient();
         }

         return _DisplaySrvClient;
      }

      virtual ~DisplaySrvClient();
      DisplaySrvClient(const DisplaySrvClient&);
      DisplaySrvClient& operator =(const DisplaySrvClient&);
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      //virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange &stateChange);

      void onDIM_INFO_DimmingModeError(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
                                       const boost::shared_ptr< ::dimming_main_fi::DIM_INFO_DimmingModeError >& /*error*/);
      void onDIM_INFO_DimmingModeStatus(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
                                        const boost::shared_ptr< ::dimming_main_fi::DIM_INFO_DimmingModeStatus >& status);
      void onDIM_DISP_SetBrightnessLevelExtendedError(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::dimming_main_fi::DIM_DISP_SetBrightnessLevelExtendedError >& /*error*/);

      void onDIM_DISP_SetBrightnessLevelExtendedResult(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::dimming_main_fi::DIM_DISP_SetBrightnessLevelExtendedResult >& /*result*/);

      void onDIM_DISP_BrightnessLevelExtendedError(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
            const ::boost::shared_ptr< ::dimming_main_fi::DIM_DISP_BrightnessLevelExtendedError >& /*error*/);

      void onDIM_DISP_BrightnessLevelExtendedStatus(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
            const ::boost::shared_ptr< ::dimming_main_fi::DIM_DISP_BrightnessLevelExtendedStatus >& status);

      void onDIM_INFO_SetDimmingModeError(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& proxy, const ::boost::shared_ptr< ::dimming_main_fi::DIM_INFO_SetDimmingModeError >& error);

      void onDIM_INFO_SetDimmingModeResult(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& proxy, const ::boost::shared_ptr< ::dimming_main_fi::DIM_INFO_SetDimmingModeResult >& result);

      ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy > _dimmingProxy;
      int m_brightvalue;
      int dimmingmodestatus;

      void Inc_Dec_Brightness_Service(int BrightnessVal);
      void SetDimmingMode(const uint32& mode);
      uint8 getCurrentBrightnessVal4mModeStatusData();
      uint8 getCurrentModeStatusData();
      void DisplayCompRxUpdate();
      static void destroy();

   private:

      DisplaySrvClient();
      static DisplaySrvClient*  _DisplaySrvClient;
      HmiDataServiceClientHandler* _hmidatasrvhandler;
};


}
}


#endif

#endif //DISPLAY_SRV_CLIENT_HEADER
